/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.input.paper;

import com.google.common.base.Preconditions;
import io.github.portlek.input.ChatInput;
import io.github.portlek.input.ChatPlatform;
import io.github.portlek.input.ChatSender;
import io.github.portlek.input.ChatTask;
import io.github.portlek.input.paper.PprChatEvent;
import io.github.portlek.input.paper.PprChatSender;
import io.github.portlek.input.paper.PprChatTask;
import io.github.portlek.input.paper.PprQuitEvent;
import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.concurrent.atomic.AtomicReference;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class PaperChatPlatform
implements ChatPlatform<Player>,
Listener {
    @NotNull
    private final AtomicReference<ChatInput<?, Player>> input = new AtomicReference();
    @NotNull
    private final Plugin plugin;

    @NotNull
    public static <T> ChatInput.Builder<T, Player> builder(@NotNull Player sender) {
        Plugin[] plugins = Bukkit.getPluginManager().getPlugins();
        Preconditions.checkArgument((plugins.length != 0 ? 1 : 0) != 0, (Object)"not found any plugin");
        return PaperChatPlatform.builder(plugins[0], sender);
    }

    @NotNull
    public static <T> ChatInput.Builder<T, Player> builder(@NotNull Plugin plugin, @NotNull Player sender) {
        return PaperChatPlatform.builder((ChatPlatform<Player>)new PaperChatPlatform(plugin), sender);
    }

    @NotNull
    public static <T> ChatInput.Builder<T, Player> builder(@NotNull ChatPlatform<Player> platform, @NotNull Player sender) {
        return PaperChatPlatform.builder(platform, new PprChatSender(sender));
    }

    @NotNull
    public static <T> ChatInput.Builder<T, Player> builder(@NotNull ChatPlatform<Player> platform, @NotNull ChatSender<Player> sender) {
        return ChatInput.builder(platform, sender);
    }

    @Override
    @NotNull
    public ChatTask createRunTaskLater(@NotNull Runnable runnable, long time) {
        return new PprChatTask(Bukkit.getScheduler().runTaskLater(this.plugin, runnable, time));
    }

    @Override
    public void init(@NotNull ChatInput<?, Player> input) {
        this.input.set(input);
        Bukkit.getPluginManager().registerEvents((Listener)this, this.plugin);
    }

    @Override
    public void unregisterListeners() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void whenChat(@NotNull AsyncChatEvent event) {
        this.input.get().onChat(new PprChatEvent(event, new PprChatSender(event.getPlayer())));
    }

    @EventHandler
    public void whenQuit(@NotNull PlayerQuitEvent event) {
        this.input.get().onQuit(new PprQuitEvent(new PprChatSender(event.getPlayer())));
    }

    public PaperChatPlatform(@NotNull Plugin plugin) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        this.plugin = plugin;
    }
}

