/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.loaders.impl;

import io.github.portlek.configs.ConfigHolder;
import io.github.portlek.configs.FieldLoader;
import io.github.portlek.configs.configuration.ConfigurationSection;
import io.github.portlek.configs.loaders.GenericFieldLoader;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FlUniqueId
extends GenericFieldLoader<String, UUID> {
    public static final FieldLoader.Func INSTANCE = FlUniqueId::new;

    private FlUniqueId(@NotNull ConfigHolder holder, @NotNull ConfigurationSection section) {
        super(holder, section, UUID.class);
    }

    @NotNull
    private static Optional<UUID> convertToUniqueId(@Nullable String raw) {
        if (raw == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(UUID.fromString(raw));
        }
        catch (Throwable throwable) {
            return Optional.empty();
        }
    }

    @Override
    @NotNull
    public Optional<String> toConfigObject(@NotNull ConfigurationSection section, @NotNull String path) {
        return Optional.ofNullable(section.getString(path));
    }

    @Override
    @NotNull
    public Optional<UUID> toFinal(@NotNull String rawValue, @Nullable UUID fieldValue) {
        return FlUniqueId.convertToUniqueId(rawValue);
    }

    @Override
    @NotNull
    public Optional<String> toRaw(@NotNull UUID finalValue) {
        return Optional.ofNullable(finalValue.toString());
    }
}

