/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.loaders.impl;

import io.github.portlek.configs.ConfigHolder;
import io.github.portlek.configs.FieldLoader;
import io.github.portlek.configs.configuration.ConfigurationSection;
import io.github.portlek.configs.loaders.GenericFieldLoader;
import java.util.Locale;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FlLocale
extends GenericFieldLoader<String, Locale> {
    public static final FieldLoader.Func INSTANCE = FlLocale::new;

    private FlLocale(@NotNull ConfigHolder holder, @NotNull ConfigurationSection section) {
        super(holder, section, Locale.class);
    }

    @NotNull
    private static Optional<Locale> convertToLocale(@Nullable String raw) {
        if (raw == null) {
            return Optional.empty();
        }
        String trim = raw.trim();
        String[] strings = trim.split("_");
        if (trim.contains("_") && strings.length != 2) {
            return Optional.of(Locale.ROOT);
        }
        if (strings.length != 2) {
            return Optional.empty();
        }
        return Optional.of(new Locale(strings[0], strings[1]));
    }

    @Override
    @NotNull
    public Optional<String> toConfigObject(@NotNull ConfigurationSection section, @NotNull String path) {
        return Optional.ofNullable(section.getString(path));
    }

    @Override
    @NotNull
    public Optional<Locale> toFinal(@NotNull String rawValue, @Nullable Locale fieldValue) {
        return FlLocale.convertToLocale(rawValue);
    }

    @Override
    @NotNull
    public Optional<String> toRaw(@NotNull Locale finalValue) {
        return Optional.of(finalValue.getLanguage() + "_" + finalValue.getCountry());
    }
}

