/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries;

import com.cryptomorin.xseries.SkullUtils;
import com.cryptomorin.xseries.XMaterial;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

final class SkullCacheListener {
    protected static final Map<UUID, String> CACHE = new HashMap<UUID, String>();
    private static final String SESSION = "https://sessionserver.mojang.com/session/minecraft/profile/";

    SkullCacheListener() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String getSkinValue(@Nonnull String id) {
        Objects.requireNonNull(id, "Player UUID cannot be null");
        try {
            JsonParser parser = new JsonParser();
            URL properties = new URL(SESSION + id);
            try (InputStreamReader readProperties = new InputStreamReader(properties.openStream());){
                JsonObject jObjectP = parser.parse(readProperties).getAsJsonObject();
                if (SkullCacheListener.mojangError(jObjectP)) {
                    String string = null;
                    return string;
                }
                JsonObject textureProperty = jObjectP.get("properties").getAsJsonArray().get(0).getAsJsonObject();
                String string = textureProperty.get("value").getAsString();
                return string;
            }
        }
        catch (IOException | IllegalStateException e) {
            System.err.println("Could not get skin data from session servers! " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String getIdFromUsername(@Nonnull String username) {
        Validate.notEmpty((String)username, (String)"Cannot get UUID of a null or empty username");
        int len = username.length();
        if (len < 3) throw new IllegalArgumentException("Username cannot be less than 3 and longer than 16 characters: " + username);
        if (len > 16) {
            throw new IllegalArgumentException("Username cannot be less than 3 and longer than 16 characters: " + username);
        }
        try {
            URL convertName = new URL("https://api.mojang.com/users/profiles/minecraft/" + username);
            JsonParser parser = new JsonParser();
            try (InputStreamReader idReader = new InputStreamReader(convertName.openStream());){
                JsonElement jElement = parser.parse(idReader);
                if (!jElement.isJsonObject()) {
                    String string = null;
                    return string;
                }
                JsonObject jObject = jElement.getAsJsonObject();
                if (SkullCacheListener.mojangError(jObject)) {
                    String string = null;
                    return string;
                }
                String string = jObject.get("id").getAsString();
                return string;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static boolean mojangError(@Nonnull JsonObject jsonObject) {
        if (!jsonObject.has("error")) {
            return false;
        }
        String err = jsonObject.get("error").getAsString();
        String msg = jsonObject.get("errorMessage").getAsString();
        System.err.println("Mojang Error " + err + ": " + msg);
        return true;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        GameProfile profile = new GameProfile(player.getUniqueId(), player.getName());
        ItemStack head = XMaterial.PLAYER_HEAD.parseItem();
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        try {
            SkullUtils.GAME_PROFILE.invoke(meta, profile);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        head.setItemMeta((ItemMeta)meta);
        player.getInventory().addItem(new ItemStack[]{head});
    }
}

