/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.paper.hooks.hooks;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.node.types.ChatMetaNode;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.hooks.Wrapped;

public final class LuckPermsWrapper
implements Wrapped {
    @NotNull
    private final LuckPerms luckPerms;

    @NotNull
    public Optional<String> getGroup(@NotNull String world, @NotNull Player player) {
        return Optional.ofNullable(this.luckPerms.getUserManager().getUser(player.getUniqueId())).map(User::getPrimaryGroup);
    }

    @NotNull
    public Optional<List<String>> getGroupPrefix(@NotNull String world, @NotNull String group) {
        return Optional.ofNullable(this.luckPerms.getGroupManager().getGroup(group)).map(gr -> new ArrayList(gr.getNodes(NodeType.PREFIX))).map(nodes -> nodes.stream().map(ChatMetaNode::getMetaValue).collect(Collectors.toList()));
    }

    @NotNull
    public Optional<List<String>> getGroupSuffix(@NotNull String world, @NotNull String group) {
        return Optional.ofNullable(this.luckPerms.getGroupManager().getGroup(group)).map(gr -> new ArrayList(gr.getNodes(NodeType.SUFFIX))).map(nodes -> nodes.stream().map(ChatMetaNode::getMetaValue).collect(Collectors.toList()));
    }

    @NotNull
    public Optional<List<String>> getUserPrefix(@NotNull Player player) {
        return Optional.ofNullable(this.luckPerms.getUserManager().getUser(player.getUniqueId())).map(gr -> new ArrayList(gr.getNodes(NodeType.PREFIX))).map(nodes -> nodes.stream().map(ChatMetaNode::getMetaValue).collect(Collectors.toList()));
    }

    @NotNull
    public Optional<List<String>> getUserSuffix(@NotNull Player player) {
        return Optional.ofNullable(this.luckPerms.getUserManager().getUser(player.getUniqueId())).map(gr -> new ArrayList(gr.getNodes(NodeType.SUFFIX))).map(nodes -> nodes.stream().map(ChatMetaNode::getMetaValue).collect(Collectors.toList()));
    }

    public LuckPermsWrapper(@NotNull LuckPerms luckPerms) {
        if (luckPerms == null) {
            throw new NullPointerException("luckPerms is marked non-null but is null");
        }
        this.luckPerms = luckPerms;
    }
}

