/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.paper.element;

import com.cryptomorin.xseries.XMaterial;
import io.github.portlek.bukkititembuilder.ItemStackBuilder;
import io.github.portlek.bukkititembuilder.util.ItemStackUtil;
import io.github.portlek.configs.configuration.ConfigurationSection;
import io.github.portlek.configs.loaders.DataSerializer;
import io.github.portlek.smartinventory.Icon;
import io.github.portlek.smartinventory.InventoryContents;
import io.github.portlek.smartinventory.event.abs.ClickEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.element.Placeholder;
import tr.com.infumia.infumialib.paper.element.PlaceType;

public final class FileElement
implements DataSerializer {
    @NotNull
    private final List<Consumer<ClickEvent>> events;
    @NotNull
    private final ItemStack itemStack;
    @NotNull
    private final PlaceType placeType;
    @NotNull
    private final Map<String, Object> values;

    @SafeVarargs
    @NotNull
    public static FileElement fill(@NotNull ItemStack itemStack, Consumer<ClickEvent> ... events) {
        return FileElement.from(itemStack, PlaceType.FILL, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fill(@NotNull ItemStackBuilder builder, Consumer<ClickEvent> ... events) {
        return FileElement.fill(builder.getItemStack(), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fill(@NotNull Material material, Consumer<ClickEvent> ... events) {
        return FileElement.fill(ItemStackBuilder.from(material), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fill(@NotNull XMaterial material, Consumer<ClickEvent> ... events) {
        return FileElement.fill(ItemStackBuilder.from(material), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillBorders(@NotNull ItemStack itemStack, Consumer<ClickEvent> ... events) {
        return FileElement.from(itemStack, PlaceType.FILL_BORDERS, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillBorders(@NotNull ItemStackBuilder builder, Consumer<ClickEvent> ... events) {
        return FileElement.fillBorders(builder.getItemStack(), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillBorders(@NotNull Material material, Consumer<ClickEvent> ... events) {
        return FileElement.fillBorders(ItemStackBuilder.from(material), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillBorders(@NotNull XMaterial material, Consumer<ClickEvent> ... events) {
        return FileElement.fillBorders(ItemStackBuilder.from(material), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillColumn(@NotNull ItemStack itemStack, int column, Consumer<ClickEvent> ... events) {
        return FileElement.from(itemStack, PlaceType.FILL_COLUMN, PlaceType.parse("column", column), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillColumn(@NotNull ItemStackBuilder builder, int column, Consumer<ClickEvent> ... events) {
        return FileElement.fillColumn(builder.getItemStack(), column, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillColumn(@NotNull Material material, int column, Consumer<ClickEvent> ... events) {
        return FileElement.fillColumn(ItemStackBuilder.from(material), column, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillColumn(@NotNull XMaterial material, int column, Consumer<ClickEvent> ... events) {
        return FileElement.fillColumn(ItemStackBuilder.from(material), column, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillEmpties(@NotNull ItemStack itemStack, Consumer<ClickEvent> ... events) {
        return FileElement.from(itemStack, PlaceType.FILL_EMPTIES, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillEmpties(@NotNull ItemStackBuilder builder, Consumer<ClickEvent> ... events) {
        return FileElement.fillEmpties(builder.getItemStack(), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillEmpties(@NotNull Material material, Consumer<ClickEvent> ... events) {
        return FileElement.fillEmpties(ItemStackBuilder.from(material), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillEmpties(@NotNull XMaterial material, Consumer<ClickEvent> ... events) {
        return FileElement.fillEmpties(ItemStackBuilder.from(material), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillPattern(@NotNull ItemStack itemStack, boolean wrapAround, @NotNull String[] pattern, Consumer<ClickEvent> ... events) {
        return FileElement.from(itemStack, PlaceType.FILL_PATTERN, PlaceType.parse("wrapAround", wrapAround, "pattern", pattern), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillPattern(@NotNull ItemStackBuilder builder, boolean wrapAround, @NotNull String[] pattern, Consumer<ClickEvent> ... events) {
        return FileElement.fillPattern(builder.getItemStack(), wrapAround, pattern, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillPattern(@NotNull Material material, boolean wrapAround, @NotNull String[] pattern, Consumer<ClickEvent> ... events) {
        return FileElement.fillPattern(ItemStackBuilder.from(material), wrapAround, pattern, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillPattern(@NotNull XMaterial material, boolean wrapAround, @NotNull String[] pattern, Consumer<ClickEvent> ... events) {
        return FileElement.fillPattern(ItemStackBuilder.from(material), wrapAround, pattern, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillPatternStart(@NotNull ItemStack itemStack, boolean wrapAround, @NotNull String[] pattern, int startRow, int startColumn, Consumer<ClickEvent> ... events) {
        return FileElement.from(itemStack, PlaceType.FILL_PATTERN_START, PlaceType.parse("wrapAround", wrapAround, "pattern", pattern, "startRow", startRow, "startColumn", startColumn), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillPatternStart(@NotNull ItemStackBuilder builder, boolean wrapAround, @NotNull String[] pattern, int startRow, int startColumn, Consumer<ClickEvent> ... events) {
        return FileElement.fillPatternStart(builder.getItemStack(), wrapAround, pattern, startRow, startColumn, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillPatternStart(@NotNull Material material, boolean wrapAround, @NotNull String[] pattern, int startRow, int startColumn, Consumer<ClickEvent> ... events) {
        return FileElement.fillPatternStart(ItemStackBuilder.from(material), wrapAround, pattern, startRow, startColumn, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillPatternStart(@NotNull XMaterial material, boolean wrapAround, @NotNull String[] pattern, int startRow, int startColumn, Consumer<ClickEvent> ... events) {
        return FileElement.fillPatternStart(ItemStackBuilder.from(material), wrapAround, pattern, startRow, startColumn, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillPatternStartIndex(@NotNull ItemStack itemStack, boolean wrapAround, @NotNull String[] pattern, int startIndex, Consumer<ClickEvent> ... events) {
        return FileElement.from(itemStack, PlaceType.FILL_PATTERN_START_INDEX, PlaceType.parse("wrapAround", wrapAround, "pattern", pattern, "startIndex", startIndex), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillPatternStartIndex(@NotNull ItemStackBuilder builder, boolean wrapAround, @NotNull String[] pattern, int startIndex, Consumer<ClickEvent> ... events) {
        return FileElement.fillPatternStartIndex(builder.getItemStack(), wrapAround, pattern, startIndex, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillPatternStartIndex(@NotNull Material material, boolean wrapAround, @NotNull String[] pattern, int startIndex, Consumer<ClickEvent> ... events) {
        return FileElement.fillPatternStartIndex(ItemStackBuilder.from(material), wrapAround, pattern, startIndex, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillPatternStartIndex(@NotNull XMaterial material, boolean wrapAround, @NotNull String[] pattern, int startIndex, Consumer<ClickEvent> ... events) {
        return FileElement.fillPatternStartIndex(ItemStackBuilder.from(material), wrapAround, pattern, startIndex, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRectFromTo(@NotNull ItemStack itemStack, int fromRow, int fromColumn, int toRow, int toColumn, Consumer<ClickEvent> ... events) {
        return FileElement.from(itemStack, PlaceType.FILL_RECT_FROM_TO, PlaceType.parse("fromRow", fromRow, "fromColumn", fromColumn, "toRow", toRow, "toColumn", toColumn), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRectFromTo(@NotNull ItemStackBuilder builder, int fromRow, int fromColumn, int toRow, int toColumn, Consumer<ClickEvent> ... events) {
        return FileElement.fillRectFromTo(builder.getItemStack(), fromRow, fromColumn, toRow, toColumn, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRectFromTo(@NotNull Material material, int fromRow, int fromColumn, int toRow, int toColumn, Consumer<ClickEvent> ... events) {
        return FileElement.fillRectFromTo(ItemStackBuilder.from(material), fromRow, fromColumn, toRow, toColumn, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRectFromTo(@NotNull XMaterial material, int fromRow, int fromColumn, int toRow, int toColumn, Consumer<ClickEvent> ... events) {
        return FileElement.fillRectFromTo(ItemStackBuilder.from(material), fromRow, fromColumn, toRow, toColumn, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRectIndex(@NotNull ItemStack itemStack, int fromIndex, int toIndex, Consumer<ClickEvent> ... events) {
        return FileElement.from(itemStack, PlaceType.FILL_RECT_INDEX, PlaceType.parse("fromIndex", fromIndex, "toIndex", toIndex), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRectIndex(@NotNull ItemStackBuilder builder, int fromIndex, int toIndex, Consumer<ClickEvent> ... events) {
        return FileElement.fillRectIndex(builder.getItemStack(), fromIndex, toIndex, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRectIndex(@NotNull Material material, int fromIndex, int toIndex, Consumer<ClickEvent> ... events) {
        return FileElement.fillRectIndex(ItemStackBuilder.from(material), fromIndex, toIndex, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRectIndex(@NotNull XMaterial material, int fromIndex, int toIndex, Consumer<ClickEvent> ... events) {
        return FileElement.fillRectIndex(ItemStackBuilder.from(material), fromIndex, toIndex, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRepeatingPattern(@NotNull ItemStack itemStack, boolean wrapAround, @NotNull String[] pattern, Consumer<ClickEvent> ... events) {
        return FileElement.from(itemStack, PlaceType.FILL_REPEATING_PATTERN, PlaceType.parse("wrapAround", wrapAround, "pattern", pattern), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRepeatingPattern(@NotNull ItemStackBuilder builder, boolean wrapAround, @NotNull String[] pattern, Consumer<ClickEvent> ... events) {
        return FileElement.fillRepeatingPattern(builder.getItemStack(), wrapAround, pattern, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRepeatingPattern(@NotNull Material material, boolean wrapAround, @NotNull String[] pattern, Consumer<ClickEvent> ... events) {
        return FileElement.fillRepeatingPattern(ItemStackBuilder.from(material), wrapAround, pattern, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRepeatingPattern(@NotNull XMaterial material, boolean wrapAround, @NotNull String[] pattern, Consumer<ClickEvent> ... events) {
        return FileElement.fillRepeatingPattern(ItemStackBuilder.from(material), wrapAround, pattern, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRepeatingPatternStart(@NotNull ItemStack itemStack, boolean wrapAround, @NotNull String[] pattern, int startRow, int startColumn, int endRow, int endColumn, Consumer<ClickEvent> ... events) {
        return FileElement.from(itemStack, PlaceType.FILL_REPEATING_PATTERN_START, PlaceType.parse("wrapAround", wrapAround, "pattern", pattern, "startRow", startRow, "startColumn", startColumn, "endRow", endRow, "endColumn", endColumn), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRepeatingPatternStart(@NotNull ItemStackBuilder builder, boolean wrapAround, @NotNull String[] pattern, int startRow, int startColumn, int endRow, int endColumn, Consumer<ClickEvent> ... events) {
        return FileElement.fillRepeatingPatternStart(builder.getItemStack(), wrapAround, pattern, startRow, startColumn, endRow, endColumn, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRepeatingPatternStart(@NotNull Material material, boolean wrapAround, @NotNull String[] pattern, int startRow, int startColumn, int endRow, int endColumn, Consumer<ClickEvent> ... events) {
        return FileElement.fillRepeatingPatternStart(ItemStackBuilder.from(material), wrapAround, pattern, startRow, startColumn, endRow, endColumn, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRepeatingPatternStart(@NotNull XMaterial material, boolean wrapAround, @NotNull String[] pattern, int startRow, int startColumn, int endRow, int endColumn, Consumer<ClickEvent> ... events) {
        return FileElement.fillRepeatingPatternStart(ItemStackBuilder.from(material), wrapAround, pattern, startRow, startColumn, endRow, endColumn, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRepeatingPatternStartIndex(@NotNull ItemStack itemStack, boolean wrapAround, @NotNull String[] pattern, int startIndex, int endIndex, Consumer<ClickEvent> ... events) {
        return FileElement.from(itemStack, PlaceType.FILL_REPEATING_PATTERN_START_INDEX, PlaceType.parse("wrapAround", wrapAround, "pattern", pattern, "startIndex", startIndex, "endIndex", endIndex), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRepeatingPatternStartIndex(@NotNull ItemStackBuilder builder, boolean wrapAround, @NotNull String[] pattern, int startIndex, int endIndex, Consumer<ClickEvent> ... events) {
        return FileElement.fillRepeatingPatternStartIndex(builder.getItemStack(), wrapAround, pattern, startIndex, endIndex, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRepeatingPatternStartIndex(@NotNull Material material, boolean wrapAround, @NotNull String[] pattern, int startIndex, int endIndex, Consumer<ClickEvent> ... events) {
        return FileElement.fillRepeatingPatternStartIndex(ItemStackBuilder.from(material), wrapAround, pattern, startIndex, endIndex, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRepeatingPatternStartIndex(@NotNull XMaterial material, boolean wrapAround, @NotNull String[] pattern, int startIndex, int endIndex, Consumer<ClickEvent> ... events) {
        return FileElement.fillRepeatingPatternStartIndex(ItemStackBuilder.from(material), wrapAround, pattern, startIndex, endIndex, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRow(@NotNull ItemStack itemStack, int row, Consumer<ClickEvent> ... events) {
        return FileElement.from(itemStack, PlaceType.FILL_ROW, PlaceType.parse("row", row), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRow(@NotNull ItemStackBuilder builder, int row, Consumer<ClickEvent> ... events) {
        return FileElement.fillRow(builder.getItemStack(), row, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRow(@NotNull Material material, int row, Consumer<ClickEvent> ... events) {
        return FileElement.fillRow(ItemStackBuilder.from(material), row, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRow(@NotNull XMaterial material, int row, Consumer<ClickEvent> ... events) {
        return FileElement.fillRow(ItemStackBuilder.from(material), row, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillSquareFromTo(@NotNull ItemStack itemStack, int fromRow, int fromColumn, int toRow, int toColumn, Consumer<ClickEvent> ... events) {
        return FileElement.from(itemStack, PlaceType.FILL_SQUARE_FROM_TO, PlaceType.parse("fromRow", fromRow, "fromColumn", fromColumn, "toRow", toRow, "toColumn", toColumn), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillSquareFromTo(@NotNull ItemStackBuilder builder, int fromRow, int fromColumn, int toRow, int toColumn, Consumer<ClickEvent> ... events) {
        return FileElement.fillSquareFromTo(builder.getItemStack(), fromRow, fromColumn, toRow, toColumn, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillSquareFromTo(@NotNull Material material, int fromRow, int fromColumn, int toRow, int toColumn, Consumer<ClickEvent> ... events) {
        return FileElement.fillSquareFromTo(ItemStackBuilder.from(material), fromRow, fromColumn, toRow, toColumn, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillSquareFromTo(@NotNull XMaterial material, int fromRow, int fromColumn, int toRow, int toColumn, Consumer<ClickEvent> ... events) {
        return FileElement.fillSquareFromTo(ItemStackBuilder.from(material), fromRow, fromColumn, toRow, toColumn, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillSquareIndex(@NotNull ItemStack itemStack, int fromIndex, int toIndex, Consumer<ClickEvent> ... events) {
        return FileElement.from(itemStack, PlaceType.FILL_SQUARE_INDEX, PlaceType.parse("fromIndex", fromIndex, "toIndex", toIndex), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillSquareIndex(@NotNull ItemStackBuilder builder, int fromIndex, int toIndex, Consumer<ClickEvent> ... events) {
        return FileElement.fillSquareIndex(builder.getItemStack(), fromIndex, toIndex, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillSquareIndex(@NotNull Material material, int fromIndex, int toIndex, Consumer<ClickEvent> ... events) {
        return FileElement.fillSquareIndex(ItemStackBuilder.from(material), fromIndex, toIndex, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillSquareIndex(@NotNull XMaterial material, int fromIndex, int toIndex, Consumer<ClickEvent> ... events) {
        return FileElement.fillSquareIndex(ItemStackBuilder.from(material), fromIndex, toIndex, events);
    }

    @NotNull
    public static FileElement from(@NotNull ItemStack itemStack, @NotNull PlaceType placeType, @NotNull Map<String, Object> values, @NotNull List<Consumer<ClickEvent>> events) {
        return new FileElement(events, itemStack, placeType, new HashMap<String, Object>(values));
    }

    @SafeVarargs
    @NotNull
    public static FileElement from(@NotNull ItemStack itemStack, @NotNull PlaceType placeType, @NotNull Map<String, Object> values, Consumer<ClickEvent> ... events) {
        return FileElement.from(itemStack, placeType, new HashMap<String, Object>(values), Arrays.asList(events));
    }

    @NotNull
    public static FileElement from(@NotNull ItemStack itemStack, @NotNull PlaceType placeType, @NotNull List<Consumer<ClickEvent>> events) {
        return FileElement.from(itemStack, placeType, new HashMap<String, Object>(), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement from(@NotNull ItemStack itemStack, @NotNull PlaceType placeType, Consumer<ClickEvent> ... events) {
        return FileElement.from(itemStack, placeType, Arrays.asList(events));
    }

    @SafeVarargs
    @NotNull
    public static FileElement insert(@NotNull ItemStack itemStack, int row, int column, Consumer<ClickEvent> ... events) {
        return FileElement.from(itemStack, PlaceType.INSERT, PlaceType.parse("row", row, "column", column), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement insert(@NotNull ItemStackBuilder builder, int row, int column, Consumer<ClickEvent> ... events) {
        return FileElement.insert(builder.getItemStack(), row, column, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement insert(@NotNull Material material, int row, int column, Consumer<ClickEvent> ... events) {
        return FileElement.insert(ItemStackBuilder.from(material), row, column, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement insert(@NotNull XMaterial material, int row, int column, Consumer<ClickEvent> ... events) {
        return FileElement.insert(ItemStackBuilder.from(material), row, column, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement insertIndex(@NotNull ItemStack itemStack, int index, Consumer<ClickEvent> ... events) {
        return FileElement.from(itemStack, PlaceType.INSERT_INDEX, PlaceType.parse("index", index), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement insertIndex(@NotNull ItemStackBuilder builder, int index, Consumer<ClickEvent> ... events) {
        return FileElement.insertIndex(builder.getItemStack(), index, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement insertIndex(@NotNull Material material, int index, Consumer<ClickEvent> ... events) {
        return FileElement.insertIndex(ItemStackBuilder.from(material), index, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement insertIndex(@NotNull XMaterial material, int index, Consumer<ClickEvent> ... events) {
        return FileElement.insertIndex(ItemStackBuilder.from(material), index, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement none(@NotNull ItemStack itemStack, Consumer<ClickEvent> ... events) {
        return FileElement.from(itemStack, PlaceType.NONE, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement none(@NotNull ItemStackBuilder builder, Consumer<ClickEvent> ... events) {
        return FileElement.none(builder.getItemStack(), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement none(@NotNull Material material, Consumer<ClickEvent> ... events) {
        return FileElement.none(ItemStackBuilder.from(material), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement none(@NotNull XMaterial material, Consumer<ClickEvent> ... events) {
        return FileElement.none(ItemStackBuilder.from(material), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement slots(@NotNull ItemStack itemStack, @NotNull List<Integer> slots, Consumer<ClickEvent> ... events) {
        return FileElement.from(itemStack, PlaceType.SLOTS, PlaceType.parse("slots", slots), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement slots(@NotNull ItemStackBuilder builder, @NotNull List<Integer> slots, Consumer<ClickEvent> ... events) {
        return FileElement.slots(builder.getItemStack(), slots, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement slots(@NotNull Material material, @NotNull List<Integer> slots, Consumer<ClickEvent> ... events) {
        return FileElement.slots(ItemStackBuilder.from(material), slots, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement slots(@NotNull XMaterial material, @NotNull List<Integer> slots, Consumer<ClickEvent> ... events) {
        return FileElement.slots(ItemStackBuilder.from(material), slots, events);
    }

    @NotNull
    static Optional<FileElement> deserialize(@NotNull ConfigurationSection section) {
        Map values;
        ConfigurationSection itemSection = section.getConfigurationSection("item");
        if (itemSection == null) {
            return Optional.empty();
        }
        Optional<ItemStack> itemStackOptional = ItemStackUtil.deserialize(itemSection.getMapValues(false));
        String typeOptional = section.getString("type");
        if (itemStackOptional.isEmpty() || typeOptional == null) {
            return Optional.empty();
        }
        PlaceType type = PlaceType.fromString(typeOptional);
        if (type.control(values = (Map)Optional.ofNullable(section.getConfigurationSection("values")).map(configurationSection -> configurationSection.getMapValues(false)).orElse(new HashMap()))) {
            return Optional.of(FileElement.from(itemStackOptional.get(), type, (Map<String, Object>)values, new Consumer[0]));
        }
        Map<String, Object> defaults = type.defaultValues();
        if (defaults.isEmpty()) {
            section.set("values", null);
        } else {
            defaults.forEach((s2, o) -> section.set("values." + s2, o));
        }
        return Optional.empty();
    }

    public FileElement addEvent(@NotNull Consumer<ClickEvent> event) {
        ArrayList<Consumer<ClickEvent>> events = new ArrayList<Consumer<ClickEvent>>(this.events());
        events.add(event);
        return this.changeEvent(events);
    }

    @NotNull
    public FileElement addValue(@NotNull String key, @NotNull Object object) {
        HashMap<String, Object> copy = new HashMap<String, Object>(this.values);
        copy.put(key, object);
        return this.duplicate(copy);
    }

    @NotNull
    public FileElement changeEvent(@NotNull List<Consumer<ClickEvent>> events) {
        return this.duplicate(events);
    }

    @NotNull
    public FileElement changeItemStack(@NotNull ItemStack itemStack) {
        return this.duplicate(itemStack);
    }

    @NotNull
    public FileElement changeLore(boolean colored, @NotNull List<String> lore) {
        return this.changeItemStack(((ItemStackBuilder)ItemStackBuilder.from(this.getItemStack()).setLore(lore, colored)).getItemStack());
    }

    @NotNull
    public FileElement changeLore(boolean colored, String ... lore) {
        return this.changeLore(colored, Arrays.asList(lore));
    }

    @NotNull
    public FileElement changeLore(@NotNull List<String> lore) {
        return this.changeLore(true, lore);
    }

    @NotNull
    public FileElement changeLore(String ... lore) {
        return this.changeLore(true, lore);
    }

    @NotNull
    public FileElement changeMaterial(@NotNull Material material) {
        ItemStack clone = this.getItemStack();
        clone.setType(material);
        return this.changeItemStack(clone);
    }

    @NotNull
    public FileElement changeMaterial(@NotNull XMaterial xmaterial) {
        ItemStack clone = this.getItemStack();
        Optional.ofNullable(xmaterial.parseMaterial()).ifPresent(arg_0 -> ((ItemStack)clone).setType(arg_0));
        return this.changeItemStack(clone);
    }

    @NotNull
    public FileElement changeName(boolean colored, @NotNull String name) {
        return this.changeItemStack(((ItemStackBuilder)ItemStackBuilder.from(this.getItemStack()).setName(name, colored)).getItemStack());
    }

    @NotNull
    public FileElement changeName(@NotNull String name) {
        return this.changeName(true, name);
    }

    @NotNull
    public FileElement changeType(@NotNull PlaceType type) {
        return this.duplicate(type);
    }

    @NotNull
    public FileElement changeValues(@NotNull Map<String, Object> values) {
        return this.duplicate(values);
    }

    @NotNull
    public Icon clickableItem() {
        Icon icon = Icon.from(this.getItemStack());
        this.events().forEach(icon::whenClick);
        return icon;
    }

    @NotNull
    public List<Consumer<ClickEvent>> events() {
        return Collections.unmodifiableList(this.events);
    }

    @NotNull
    public ItemStack getItemStack() {
        return this.itemStack.clone();
    }

    public void place(@NotNull InventoryContents contents) {
        this.type().place(this.clickableItem(), contents, this.values());
    }

    @NotNull
    public FileElement removeValue(@NotNull String key) {
        HashMap<String, Object> copy = new HashMap<String, Object>(this.values);
        copy.remove(key);
        return this.duplicate(copy);
    }

    @NotNull
    public FileElement replace(@NotNull String regex, @NotNull Object replace) {
        return this.replace(true, true, regex, replace);
    }

    @NotNull
    public FileElement replace(boolean name, boolean lore, @NotNull String regex, @NotNull Object replace) {
        return this.replace(name, lore, Placeholder.from(regex, replace));
    }

    @NotNull
    public FileElement replace(Placeholder ... placeholders) {
        return this.replace(true, true, placeholders);
    }

    @NotNull
    public FileElement replace(boolean name, boolean lore, Placeholder ... placeholders) {
        return this.replace(name, lore, Arrays.asList(placeholders));
    }

    @NotNull
    public FileElement replace(@NotNull Iterable<Placeholder> placeholders) {
        return this.replace(true, true, placeholders);
    }

    @NotNull
    public FileElement replace(boolean name, boolean lore, @NotNull Iterable<Placeholder> placeholders) {
        ItemStack clone = this.getItemStack();
        Optional.ofNullable(clone.getItemMeta()).ifPresent(itemMeta -> {
            if (name && itemMeta.hasDisplayName()) {
                placeholders.forEach(placeholder -> itemMeta.setDisplayName(placeholder.replace(itemMeta.getDisplayName())));
            }
            if (lore && itemMeta.getLore() != null && itemMeta.hasLore()) {
                ArrayList finallore = new ArrayList();
                itemMeta.getLore().forEach(s2 -> {
                    AtomicReference<String> finalstring = new AtomicReference<String>((String)s2);
                    placeholders.forEach(placeholder -> finalstring.set(placeholder.replace((String)finalstring.get())));
                    finallore.add(finalstring.get());
                });
                itemMeta.setLore(finallore);
            }
            clone.setItemMeta(itemMeta);
        });
        return this.changeItemStack(clone);
    }

    @Override
    public void serialize(@NotNull ConfigurationSection section) {
        section.set("item", ItemStackUtil.serialize(this.getItemStack()));
        section.set("type", this.type().name());
        section.set("values", null);
        this.values().forEach((s2, o) -> section.set("values." + s2, o));
    }

    public void set(@NotNull InventoryContents contents, int row, int column) {
        contents.set(row, column, this.clickableItem());
    }

    @NotNull
    public PlaceType type() {
        return this.placeType;
    }

    @NotNull
    public Optional<Object> value(@NotNull String key) {
        return Optional.ofNullable(this.values().get(key));
    }

    @NotNull
    public Map<String, Object> values() {
        return Collections.unmodifiableMap(this.values);
    }

    @NotNull
    private FileElement duplicate(@NotNull ItemStack itemStack) {
        return FileElement.from(itemStack, this.type(), this.values(), this.events());
    }

    @NotNull
    private FileElement duplicate(@NotNull PlaceType type) {
        return FileElement.from(this.getItemStack(), type, this.values(), this.events());
    }

    @NotNull
    private FileElement duplicate(@NotNull Map<String, Object> values) {
        return FileElement.from(this.getItemStack(), this.type(), values, this.events());
    }

    @NotNull
    private FileElement duplicate(@NotNull List<Consumer<ClickEvent>> events) {
        return FileElement.from(this.getItemStack(), this.type(), this.values(), events);
    }

    public FileElement(@NotNull List<Consumer<ClickEvent>> events, @NotNull ItemStack itemStack, @NotNull PlaceType placeType, @NotNull Map<String, Object> values) {
        if (events == null) {
            throw new NullPointerException("events is marked non-null but is null");
        }
        if (itemStack == null) {
            throw new NullPointerException("itemStack is marked non-null but is null");
        }
        if (placeType == null) {
            throw new NullPointerException("placeType is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        this.events = events;
        this.itemStack = itemStack;
        this.placeType = placeType;
        this.values = values;
    }
}

