/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.paper.commands;

import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.CommandPermission;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.files.InfumiaLibConfig;
import tr.com.infumia.infumialib.paper.utils.GitHubUpdateChecker;

public final class InfumiaPluginCommands {
    private static final CommandPermission MAIN = CommandPermission.fromString("infumiaplugin.command.main");
    private static final CommandPermission RELOAD = CommandPermission.fromString("infumiaplugin.command.reload");
    private static final CommandPermission UPDATE = CommandPermission.fromString("infumiaplugin.command.update");
    @NotNull
    private final Plugin plugin;

    @NotNull
    private static Component getReloadCompleteMessage() {
        return ((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Component.text("[InfumiaPlugin] ").color(NamedTextColor.YELLOW))).append(Component.text("Reload complete!").color(NamedTextColor.GREEN))).build();
    }

    public void register() {
        this.getCommandTree().register();
    }

    @NotNull
    private CommandAPICommand getCommandTree() {
        return this.getMainCommand().withSubcommand(this.getReloadCommand()).withSubcommand(this.getUpdateCommand());
    }

    @NotNull
    private CommandAPICommand getMainCommand() {
        return new CommandAPICommand("infumia").withPermission(MAIN).executes((sender, objects) -> sender.sendMessage(this.getVersionMessage()));
    }

    @NotNull
    private CommandAPICommand getReloadCommand() {
        return new CommandAPICommand("reload").withPermission(RELOAD).executes((sender, objects) -> InfumiaLibConfig.load(this.plugin.getDataFolder(), true).whenComplete((configLoader, throwable) -> sender.sendMessage(InfumiaPluginCommands.getReloadCompleteMessage())));
    }

    @NotNull
    private CommandAPICommand getUpdateCommand() {
        return new CommandAPICommand("update").withPermission(UPDATE).executes((sender, objects) -> GitHubUpdateChecker.checkForUpdate(sender, this.plugin, "Infumia", "InfumiaLib"));
    }

    @NotNull
    private Component getVersionMessage() {
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Component.text("Infumia Plugin made by ").color(NamedTextColor.YELLOW))).append(((TextComponent)Component.text("Infumia").color(NamedTextColor.GOLD)).clickEvent(ClickEvent.openUrl("https://github.com/Infumia/")))).append((Component)Component.newline())).append(((TextComponent)Component.text("Current version").color(NamedTextColor.GOLD)).clickEvent(ClickEvent.openUrl("https://github.com/Infumia/InfumiaPlugin/releases/tag/" + this.plugin.getDescription().getVersion())))).append(((TextComponent)Component.text("Latest version").color(NamedTextColor.GOLD)).clickEvent(ClickEvent.openUrl("https://github.com/Infumia/InfumiaPlugin/releases/latest/")))).build();
    }

    public InfumiaPluginCommands(@NotNull Plugin plugin) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        this.plugin = plugin;
    }
}

