/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.format;

import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.examination.ExaminableProperty;
import net.kyori.examination.string.StringExaminer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class StyleImpl
implements Style {
    static final StyleImpl EMPTY = new StyleImpl(null, null, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, null, null, null);
    private static final TextDecoration[] DECORATIONS = TextDecoration.values();
    private final @Nullable Key font;
    private final @Nullable TextColor color;
    private final TextDecoration.State obfuscated;
    private final TextDecoration.State bold;
    private final TextDecoration.State strikethrough;
    private final TextDecoration.State underlined;
    private final TextDecoration.State italic;
    private final @Nullable ClickEvent clickEvent;
    private final @Nullable HoverEvent<?> hoverEvent;
    private final @Nullable String insertion;

    static void decorate(Style.Builder builder, TextDecoration[] decorations) {
        for (TextDecoration decoration : decorations) {
            builder.decoration(decoration, true);
        }
    }

    StyleImpl(@Nullable Key font, @Nullable TextColor color, TextDecoration.State obfuscated, TextDecoration.State bold, TextDecoration.State strikethrough, TextDecoration.State underlined, TextDecoration.State italic, @Nullable ClickEvent clickEvent, @Nullable HoverEvent<?> hoverEvent, @Nullable String insertion) {
        this.font = font;
        this.color = color;
        this.obfuscated = obfuscated;
        this.bold = bold;
        this.strikethrough = strikethrough;
        this.underlined = underlined;
        this.italic = italic;
        this.clickEvent = clickEvent;
        this.hoverEvent = hoverEvent;
        this.insertion = insertion;
    }

    @Override
    public @Nullable Key font() {
        return this.font;
    }

    @Override
    public @NonNull Style font(@Nullable Key font) {
        if (Objects.equals(this.font, font)) {
            return this;
        }
        return new StyleImpl(font, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion);
    }

    @Override
    public @Nullable TextColor color() {
        return this.color;
    }

    @Override
    public @NonNull Style color(@Nullable TextColor color) {
        if (Objects.equals(this.color, color)) {
            return this;
        }
        return new StyleImpl(this.font, color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion);
    }

    @Override
    public @NonNull Style colorIfAbsent(@Nullable TextColor color) {
        if (this.color == null) {
            return this.color(color);
        }
        return this;
    }

    @Override
    public @NonNull TextDecoration.State decoration(@NonNull TextDecoration decoration) {
        if (decoration == TextDecoration.BOLD) {
            return this.bold;
        }
        if (decoration == TextDecoration.ITALIC) {
            return this.italic;
        }
        if (decoration == TextDecoration.UNDERLINED) {
            return this.underlined;
        }
        if (decoration == TextDecoration.STRIKETHROUGH) {
            return this.strikethrough;
        }
        if (decoration == TextDecoration.OBFUSCATED) {
            return this.obfuscated;
        }
        throw new IllegalArgumentException(String.format("unknown decoration '%s'", decoration));
    }

    @Override
    public @NonNull Style decoration(@NonNull TextDecoration decoration, @NonNull TextDecoration.State state) {
        Objects.requireNonNull(state, "state");
        if (decoration == TextDecoration.BOLD) {
            return new StyleImpl(this.font, this.color, this.obfuscated, state, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion);
        }
        if (decoration == TextDecoration.ITALIC) {
            return new StyleImpl(this.font, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, state, this.clickEvent, this.hoverEvent, this.insertion);
        }
        if (decoration == TextDecoration.UNDERLINED) {
            return new StyleImpl(this.font, this.color, this.obfuscated, this.bold, this.strikethrough, state, this.italic, this.clickEvent, this.hoverEvent, this.insertion);
        }
        if (decoration == TextDecoration.STRIKETHROUGH) {
            return new StyleImpl(this.font, this.color, this.obfuscated, this.bold, state, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion);
        }
        if (decoration == TextDecoration.OBFUSCATED) {
            return new StyleImpl(this.font, this.color, state, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion);
        }
        throw new IllegalArgumentException(String.format("unknown decoration '%s'", decoration));
    }

    @Override
    public @NonNull Map<TextDecoration, TextDecoration.State> decorations() {
        EnumMap<TextDecoration, TextDecoration.State> decorations = new EnumMap<TextDecoration, TextDecoration.State>(TextDecoration.class);
        for (TextDecoration decoration : DECORATIONS) {
            TextDecoration.State value = this.decoration(decoration);
            decorations.put(decoration, value);
        }
        return decorations;
    }

    @Override
    public @NonNull Style decorations(@NonNull Map<TextDecoration, TextDecoration.State> decorations) {
        TextDecoration.State obfuscated = decorations.getOrDefault(TextDecoration.OBFUSCATED, this.obfuscated);
        TextDecoration.State bold = decorations.getOrDefault(TextDecoration.BOLD, this.bold);
        TextDecoration.State strikethrough = decorations.getOrDefault(TextDecoration.STRIKETHROUGH, this.strikethrough);
        TextDecoration.State underlined = decorations.getOrDefault(TextDecoration.UNDERLINED, this.underlined);
        TextDecoration.State italic = decorations.getOrDefault(TextDecoration.ITALIC, this.italic);
        return new StyleImpl(this.font, this.color, obfuscated, bold, strikethrough, underlined, italic, this.clickEvent, this.hoverEvent, this.insertion);
    }

    @Override
    public @Nullable ClickEvent clickEvent() {
        return this.clickEvent;
    }

    @Override
    public @NonNull Style clickEvent(@Nullable ClickEvent event) {
        return new StyleImpl(this.font, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, event, this.hoverEvent, this.insertion);
    }

    @Override
    public @Nullable HoverEvent<?> hoverEvent() {
        return this.hoverEvent;
    }

    @Override
    public @NonNull Style hoverEvent(@Nullable HoverEventSource<?> source) {
        return new StyleImpl(this.font, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, HoverEventSource.unbox(source), this.insertion);
    }

    @Override
    public @Nullable String insertion() {
        return this.insertion;
    }

    @Override
    public @NonNull Style insertion(@Nullable String insertion) {
        if (Objects.equals(this.insertion, insertion)) {
            return this;
        }
        return new StyleImpl(this.font, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, insertion);
    }

    @Override
    public @NonNull Style merge(@NonNull Style that, @NonNull Style.Merge.Strategy strategy, @NonNull Set<Style.Merge> merges) {
        if (that.isEmpty() || strategy == Style.Merge.Strategy.NEVER || merges.isEmpty()) {
            return this;
        }
        if (this.isEmpty() && Style.Merge.hasAll(merges)) {
            return that;
        }
        Style.Builder builder = this.toBuilder();
        builder.merge(that, strategy, merges);
        return builder.build();
    }

    @Override
    public boolean isEmpty() {
        return this == EMPTY;
    }

    @Override
    public @NonNull Style.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    @Override
    public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("color", this.color), ExaminableProperty.of("obfuscated", (Object)this.obfuscated), ExaminableProperty.of("bold", (Object)this.bold), ExaminableProperty.of("strikethrough", (Object)this.strikethrough), ExaminableProperty.of("underlined", (Object)this.underlined), ExaminableProperty.of("italic", (Object)this.italic), ExaminableProperty.of("clickEvent", this.clickEvent), ExaminableProperty.of("hoverEvent", this.hoverEvent), ExaminableProperty.of("insertion", this.insertion), ExaminableProperty.of("font", this.font));
    }

    public @NonNull String toString() {
        return this.examine(StringExaminer.simpleEscaping());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StyleImpl)) {
            return false;
        }
        StyleImpl that = (StyleImpl)other;
        return Objects.equals(this.color, that.color) && this.obfuscated == that.obfuscated && this.bold == that.bold && this.strikethrough == that.strikethrough && this.underlined == that.underlined && this.italic == that.italic && Objects.equals(this.clickEvent, that.clickEvent) && Objects.equals(this.hoverEvent, that.hoverEvent) && Objects.equals(this.insertion, that.insertion) && Objects.equals(this.font, that.font);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.color);
        result = 31 * result + this.obfuscated.hashCode();
        result = 31 * result + this.bold.hashCode();
        result = 31 * result + this.strikethrough.hashCode();
        result = 31 * result + this.underlined.hashCode();
        result = 31 * result + this.italic.hashCode();
        result = 31 * result + Objects.hashCode(this.clickEvent);
        result = 31 * result + Objects.hashCode(this.hoverEvent);
        result = 31 * result + Objects.hashCode(this.insertion);
        result = 31 * result + Objects.hashCode(this.font);
        return result;
    }

    static final class BuilderImpl
    implements Style.Builder {
        @Nullable Key font;
        @Nullable TextColor color;
        TextDecoration.State obfuscated = TextDecoration.State.NOT_SET;
        TextDecoration.State bold = TextDecoration.State.NOT_SET;
        TextDecoration.State strikethrough = TextDecoration.State.NOT_SET;
        TextDecoration.State underlined = TextDecoration.State.NOT_SET;
        TextDecoration.State italic = TextDecoration.State.NOT_SET;
        @Nullable ClickEvent clickEvent;
        @Nullable HoverEvent<?> hoverEvent;
        @Nullable String insertion;

        BuilderImpl() {
        }

        BuilderImpl(@NonNull StyleImpl style) {
            this.color = style.color;
            this.obfuscated = style.obfuscated;
            this.bold = style.bold;
            this.strikethrough = style.strikethrough;
            this.underlined = style.underlined;
            this.italic = style.italic;
            this.clickEvent = style.clickEvent;
            this.hoverEvent = style.hoverEvent;
            this.insertion = style.insertion;
            this.font = style.font;
        }

        @Override
        public @NonNull Style.Builder font(@Nullable Key font) {
            this.font = font;
            return this;
        }

        @Override
        public @NonNull Style.Builder color(@Nullable TextColor color) {
            this.color = color;
            return this;
        }

        @Override
        public @NonNull Style.Builder colorIfAbsent(@Nullable TextColor color) {
            if (this.color == null) {
                this.color = color;
            }
            return this;
        }

        @Override
        public @NonNull Style.Builder decorate(@NonNull TextDecoration decoration) {
            return this.decoration(decoration, TextDecoration.State.TRUE);
        }

        @Override
        public @NonNull Style.Builder decorate(TextDecoration ... decorations) {
            int length = decorations.length;
            for (int i = 0; i < length; ++i) {
                this.decorate(decorations[i]);
            }
            return this;
        }

        @Override
        public @NonNull Style.Builder decoration(@NonNull TextDecoration decoration, @NonNull TextDecoration.State state) {
            Objects.requireNonNull(state, "state");
            if (decoration == TextDecoration.BOLD) {
                this.bold = state;
                return this;
            }
            if (decoration == TextDecoration.ITALIC) {
                this.italic = state;
                return this;
            }
            if (decoration == TextDecoration.UNDERLINED) {
                this.underlined = state;
                return this;
            }
            if (decoration == TextDecoration.STRIKETHROUGH) {
                this.strikethrough = state;
                return this;
            }
            if (decoration == TextDecoration.OBFUSCATED) {
                this.obfuscated = state;
                return this;
            }
            throw new IllegalArgumentException(String.format("unknown decoration '%s'", decoration));
        }

        @Override
        public @NonNull Style.Builder clickEvent(@Nullable ClickEvent event) {
            this.clickEvent = event;
            return this;
        }

        @Override
        public @NonNull Style.Builder hoverEvent(@Nullable HoverEventSource<?> source) {
            this.hoverEvent = HoverEventSource.unbox(source);
            return this;
        }

        @Override
        public @NonNull Style.Builder insertion(@Nullable String insertion) {
            this.insertion = insertion;
            return this;
        }

        @Override
        public @NonNull Style.Builder merge(@NonNull Style that, @NonNull Style.Merge.Strategy strategy, @NonNull Set<Style.Merge> merges) {
            Key font;
            String insertion;
            TextColor color;
            if (that.isEmpty() || strategy == Style.Merge.Strategy.NEVER || merges.isEmpty()) {
                return this;
            }
            MergeLogic logic = BuilderImpl.mergeLogic(strategy);
            if (merges.contains((Object)Style.Merge.COLOR) && (color = that.color()) != null && logic.mergeColor(this, color)) {
                this.color(color);
            }
            if (merges.contains((Object)Style.Merge.DECORATIONS)) {
                int length = DECORATIONS.length;
                for (int i = 0; i < length; ++i) {
                    TextDecoration decoration = DECORATIONS[i];
                    TextDecoration.State state = that.decoration(decoration);
                    if (state == TextDecoration.State.NOT_SET || !logic.mergeDecoration(this, decoration)) continue;
                    this.decoration(decoration, state);
                }
            }
            if (merges.contains((Object)Style.Merge.EVENTS)) {
                HoverEvent<?> hoverEvent;
                ClickEvent clickEvent = that.clickEvent();
                if (clickEvent != null && logic.mergeClickEvent(this, clickEvent)) {
                    this.clickEvent(clickEvent);
                }
                if ((hoverEvent = that.hoverEvent()) != null && logic.mergeHoverEvent(this, hoverEvent)) {
                    this.hoverEvent(hoverEvent);
                }
            }
            if (merges.contains((Object)Style.Merge.INSERTION) && (insertion = that.insertion()) != null && logic.mergeInsertion(this, insertion)) {
                this.insertion(insertion);
            }
            if (merges.contains((Object)Style.Merge.FONT) && (font = that.font()) != null && logic.mergeFont(this, font)) {
                this.font(font);
            }
            return this;
        }

        private static MergeLogic mergeLogic(Style.Merge.Strategy strategy) {
            if (strategy == Style.Merge.Strategy.ALWAYS) {
                return MergeLogic.Constant.TRUE;
            }
            if (strategy == Style.Merge.Strategy.NEVER) {
                return MergeLogic.Constant.FALSE;
            }
            if (strategy == Style.Merge.Strategy.IF_ABSENT_ON_TARGET) {
                return MergeLogic.IfAbsentOnTarget.INSTANCE;
            }
            throw new IllegalArgumentException(strategy.name());
        }

        @Override
        public @NonNull StyleImpl build() {
            if (this.isEmpty()) {
                return EMPTY;
            }
            return new StyleImpl(this.font, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion);
        }

        private boolean isEmpty() {
            return this.color == null && this.obfuscated == TextDecoration.State.NOT_SET && this.bold == TextDecoration.State.NOT_SET && this.strikethrough == TextDecoration.State.NOT_SET && this.underlined == TextDecoration.State.NOT_SET && this.italic == TextDecoration.State.NOT_SET && this.clickEvent == null && this.hoverEvent == null && this.insertion == null && this.font == null;
        }
    }

    static abstract class MergeLogic {
        MergeLogic() {
        }

        abstract boolean mergeColor(BuilderImpl var1, @Nullable TextColor var2);

        abstract boolean mergeDecoration(BuilderImpl var1, @NonNull TextDecoration var2);

        abstract boolean mergeClickEvent(BuilderImpl var1, @Nullable ClickEvent var2);

        abstract boolean mergeHoverEvent(BuilderImpl var1, @Nullable HoverEvent<?> var2);

        abstract boolean mergeInsertion(BuilderImpl var1, @Nullable String var2);

        abstract boolean mergeFont(BuilderImpl var1, @Nullable Key var2);

        static final class IfAbsentOnTarget
        extends MergeLogic {
            static final IfAbsentOnTarget INSTANCE = new IfAbsentOnTarget();

            private IfAbsentOnTarget() {
            }

            @Override
            boolean mergeColor(BuilderImpl target, @Nullable TextColor color) {
                return target.color == null;
            }

            @Override
            boolean mergeDecoration(BuilderImpl target, @NonNull TextDecoration decoration) {
                if (decoration == TextDecoration.OBFUSCATED) {
                    return target.obfuscated == TextDecoration.State.NOT_SET;
                }
                if (decoration == TextDecoration.BOLD) {
                    return target.bold == TextDecoration.State.NOT_SET;
                }
                if (decoration == TextDecoration.STRIKETHROUGH) {
                    return target.strikethrough == TextDecoration.State.NOT_SET;
                }
                if (decoration == TextDecoration.UNDERLINED) {
                    return target.underlined == TextDecoration.State.NOT_SET;
                }
                if (decoration == TextDecoration.ITALIC) {
                    return target.italic == TextDecoration.State.NOT_SET;
                }
                throw new IllegalArgumentException();
            }

            @Override
            boolean mergeClickEvent(BuilderImpl target, @Nullable ClickEvent event) {
                return target.clickEvent == null;
            }

            @Override
            boolean mergeHoverEvent(BuilderImpl target, @Nullable HoverEvent<?> event) {
                return target.hoverEvent == null;
            }

            @Override
            boolean mergeInsertion(BuilderImpl target, @Nullable String insertion) {
                return target.insertion == null;
            }

            @Override
            boolean mergeFont(BuilderImpl target, @Nullable Key font) {
                return target.font == null;
            }
        }

        static final class Constant
        extends MergeLogic {
            static final Constant FALSE = new Constant(false);
            static final Constant TRUE = new Constant(true);
            private final boolean value;

            private Constant(boolean value) {
                this.value = value;
            }

            @Override
            boolean mergeColor(BuilderImpl target, @Nullable TextColor color) {
                return this.value;
            }

            @Override
            boolean mergeDecoration(BuilderImpl target, @NonNull TextDecoration decoration) {
                return this.value;
            }

            @Override
            boolean mergeClickEvent(BuilderImpl target, @Nullable ClickEvent event) {
                return this.value;
            }

            @Override
            boolean mergeHoverEvent(BuilderImpl target, @Nullable HoverEvent<?> event) {
                return this.value;
            }

            @Override
            boolean mergeInsertion(BuilderImpl target, @Nullable String insertion) {
                return this.value;
            }

            @Override
            boolean mergeFont(BuilderImpl target, @Nullable Key font) {
                return this.value;
            }
        }
    }
}

