/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReflectionUtils {
    public static final String VERSION = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
    public static final String CRAFT_BUKKIT = "org.bukkit.craftbukkit." + VERSION + ".";
    public static final String NMS = "net.minecraft.server." + VERSION + ".";
    private static final MethodHandle GET_HANDLE;
    private static final MethodHandle PLAYER_CONNECTION;
    private static final MethodHandle SEND_PACKET;

    private ReflectionUtils() {
    }

    @Nullable
    public static Class<?> getCraftClass(@NotNull String name) {
        try {
            return Class.forName(CRAFT_BUKKIT + name);
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static Class<?> getNMSClass(@NotNull String name) {
        try {
            return Class.forName(NMS + name);
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @NotNull
    public static CompletableFuture<Void> sendPacket(@NotNull Player player, Object ... packets) {
        return CompletableFuture.runAsync(() -> ReflectionUtils.sendPacketSync(player, packets)).exceptionally(ex -> {
            ex.printStackTrace();
            return null;
        });
    }

    public static void sendPacketSync(@NotNull Player player, Object ... packets) {
        try {
            Object handle = GET_HANDLE.invoke(player);
            Object connection = PLAYER_CONNECTION.invoke(handle);
            if (connection != null) {
                for (Object packet : packets) {
                    SEND_PACKET.invoke(connection, packet);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    static {
        Class<?> entityPlayer = ReflectionUtils.getNMSClass("EntityPlayer");
        Class<?> craftPlayer = ReflectionUtils.getCraftClass("entity.CraftPlayer");
        Class<?> playerConnection = ReflectionUtils.getNMSClass("PlayerConnection");
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodHandle sendPacket = null;
        MethodHandle getHandle = null;
        MethodHandle connection = null;
        try {
            connection = lookup.findGetter(entityPlayer, "playerConnection", playerConnection);
            getHandle = lookup.findVirtual(craftPlayer, "getHandle", MethodType.methodType(entityPlayer));
            sendPacket = lookup.findVirtual(playerConnection, "sendPacket", MethodType.methodType(Void.TYPE, ReflectionUtils.getNMSClass("Packet")));
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        PLAYER_CONNECTION = connection;
        SEND_PACKET = sendPacket;
        GET_HANDLE = getHandle;
    }
}

