/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory.event;

import io.github.portlek.smartinventory.InventoryContents;
import io.github.portlek.smartinventory.event.abs.OpenEvent;
import org.bukkit.Bukkit;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class PgOpenEvent
implements OpenEvent {
    @NotNull
    private final InventoryContents contents;
    @NotNull
    private final InventoryOpenEvent event;
    @NotNull
    private final Plugin plugin;

    @Override
    public void cancel() {
        this.event.setCancelled(true);
    }

    @Override
    public void close() {
        Bukkit.getScheduler().runTask(this.plugin, () -> this.contents.page().close(this.contents.player()));
    }

    @Override
    @NotNull
    public InventoryContents contents() {
        return this.contents;
    }

    @Override
    @NotNull
    public InventoryOpenEvent getEvent() {
        return this.event;
    }

    public PgOpenEvent(@NotNull InventoryContents contents, @NotNull InventoryOpenEvent event, @NotNull Plugin plugin) {
        if (contents == null) {
            throw new NullPointerException("contents is marked non-null but is null");
        }
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        this.contents = contents;
        this.event = event;
        this.plugin = plugin;
    }
}

