/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory.event;

import io.github.portlek.smartinventory.Icon;
import io.github.portlek.smartinventory.InventoryContents;
import io.github.portlek.smartinventory.event.abs.ClickEvent;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class IcClickEvent
implements ClickEvent {
    @NotNull
    private final InventoryContents contents;
    @NotNull
    private final InventoryClickEvent event;
    @NotNull
    private final Icon icon;
    @NotNull
    private final Plugin plugin;

    @Override
    @NotNull
    public InventoryAction action() {
        return this.event.getAction();
    }

    @Override
    @NotNull
    public ClickType click() {
        return this.event.getClick();
    }

    @Override
    public int column() {
        return this.event.getSlot() % 9;
    }

    @Override
    @NotNull
    public Optional<ItemStack> current() {
        return Optional.ofNullable(this.event.getCurrentItem());
    }

    @Override
    @NotNull
    public Optional<ItemStack> cursor() {
        return Optional.ofNullable(this.event.getCursor());
    }

    @Override
    @NotNull
    public InventoryClickEvent getEvent() {
        return this.event;
    }

    @Override
    public int row() {
        return this.event.getSlot() / 9;
    }

    @Override
    @NotNull
    public InventoryType.SlotType slot() {
        return this.event.getSlotType();
    }

    @Override
    public void cancel() {
        this.event.setCancelled(true);
    }

    @Override
    public void close() {
        Bukkit.getScheduler().runTask(this.plugin, () -> this.contents.page().close(this.contents.player()));
    }

    @Override
    @NotNull
    public InventoryContents contents() {
        return this.contents;
    }

    @Override
    @NotNull
    public Icon icon() {
        return this.icon;
    }

    public IcClickEvent(@NotNull InventoryContents contents, @NotNull InventoryClickEvent event, @NotNull Icon icon, @NotNull Plugin plugin) {
        if (contents == null) {
            throw new NullPointerException("contents is marked non-null but is null");
        }
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (icon == null) {
            throw new NullPointerException("icon is marked non-null but is null");
        }
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        this.contents = contents;
        this.event = event;
        this.icon = icon;
        this.plugin = plugin;
    }
}

