/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.replaceable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public abstract class RpBase<S extends RpBase<S, X>, X> {
    @NotNull
    private final Collection<UnaryOperator<X>> maps = new ArrayList<UnaryOperator<X>>();
    @NotNull
    private final Collection<String> regex = new ArrayList<String>();
    @NotNull
    private final Map<String, Supplier<String>> replaces = new HashMap<String, Supplier<String>>();
    @NotNull
    private final X value;

    @SafeVarargs
    @NotNull
    public final X build(Map.Entry<String, Supplier<String>> ... entries) {
        return this.build(Arrays.asList(entries));
    }

    @NotNull
    public final X build(@NotNull Collection<Map.Entry<String, Supplier<String>>> entries) {
        return this.build(entries.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    @NotNull
    public final X build(@NotNull Map.Entry<String, Supplier<String>> entry) {
        return this.build(Collections.singletonList(entry));
    }

    @NotNull
    public final X build(@NotNull String regex, @NotNull Supplier<String> replace) {
        return this.build(Map.entry(regex, replace));
    }

    @NotNull
    public final X build(@NotNull Map<String, Supplier<String>> replaces) {
        AtomicReference value = new AtomicReference(this.value);
        this.maps.stream().map((? super T operator) -> operator.apply(value.get())).forEach(value::set);
        this.replaces.forEach((regex, supplier) -> value.set(this.replace((X)value.get(), (CharSequence)regex, (CharSequence)supplier.get())));
        this.regex.stream().filter(replaces::containsKey).forEach(regex -> value.set(this.replace((X)value.get(), (CharSequence)regex, (CharSequence)((Supplier)replaces.get(regex)).get())));
        return value.get();
    }

    @NotNull
    public final <Y> Y buildMap(@NotNull Function<X, Y> function, @NotNull Map<String, Supplier<String>> replaces) {
        return function.apply(this.build(replaces));
    }

    @SafeVarargs
    @NotNull
    public final <Y> Y buildMap(@NotNull Function<X, Y> function, Map.Entry<String, Supplier<String>> ... replaces) {
        return function.apply(this.build(replaces));
    }

    @NotNull
    public final <Y> Y buildMap(@NotNull Function<X, Y> function) {
        return function.apply(this.build(new Map.Entry[0]));
    }

    @NotNull
    public final S map(@NotNull Collection<UnaryOperator<X>> map) {
        this.maps.addAll(map);
        return this.self();
    }

    @SafeVarargs
    @NotNull
    public final S map(UnaryOperator<X> ... maps) {
        return this.map(List.of(maps));
    }

    @NotNull
    public final S regex(@NotNull Collection<String> regex) {
        this.regex.addAll(regex);
        return this.self();
    }

    @NotNull
    public final S regex(String ... regex) {
        return this.regex(Arrays.asList(regex));
    }

    @NotNull
    public final S replace(@NotNull Map<String, Supplier<String>> replaces) {
        this.replaces.putAll(replaces);
        return this.self();
    }

    @SafeVarargs
    @NotNull
    public final S replace(Map.Entry<String, Supplier<String>> ... replaces) {
        Arrays.stream(replaces).forEach(entry -> this.replaces.put((String)entry.getKey(), (Supplier)entry.getValue()));
        return this.self();
    }

    @NotNull
    public final S replace(@NotNull String regex, @NotNull Supplier<String> replace) {
        return this.replace(Collections.singletonMap(regex, replace));
    }

    @NotNull
    public final S value(@NotNull X value) {
        return ((RpBase)((RpBase)((RpBase)this.newSelf(value).get()).regex(this.getRegex())).replace(this.getReplaces())).map(this.getMaps());
    }

    @NotNull
    protected abstract Supplier<S> newSelf(@NotNull X var1);

    @NotNull
    protected abstract X replace(@NotNull X var1, @NotNull CharSequence var2, @NotNull CharSequence var3);

    protected abstract S self();

    public String toString() {
        return "RpBase(maps=" + this.getMaps() + ", regex=" + this.getRegex() + ", replaces=" + this.getReplaces() + ", value=" + this.getValue() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RpBase)) {
            return false;
        }
        RpBase other = (RpBase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Collection<UnaryOperator<X>> this$maps = this.getMaps();
        Collection<UnaryOperator<X>> other$maps = other.getMaps();
        if (this$maps == null ? other$maps != null : !((Object)this$maps).equals(other$maps)) {
            return false;
        }
        Collection<String> this$regex = this.getRegex();
        Collection<String> other$regex = other.getRegex();
        if (this$regex == null ? other$regex != null : !((Object)this$regex).equals(other$regex)) {
            return false;
        }
        Map<String, Supplier<String>> this$replaces = this.getReplaces();
        Map<String, Supplier<String>> other$replaces = other.getReplaces();
        if (this$replaces == null ? other$replaces != null : !((Object)this$replaces).equals(other$replaces)) {
            return false;
        }
        X this$value = this.getValue();
        X other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RpBase;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Collection<UnaryOperator<X>> $maps = this.getMaps();
        result = result * 59 + ($maps == null ? 43 : ((Object)$maps).hashCode());
        Collection<String> $regex = this.getRegex();
        result = result * 59 + ($regex == null ? 43 : ((Object)$regex).hashCode());
        Map<String, Supplier<String>> $replaces = this.getReplaces();
        result = result * 59 + ($replaces == null ? 43 : ((Object)$replaces).hashCode());
        X $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public RpBase(@NotNull X value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.value = value;
    }

    @NotNull
    public Collection<UnaryOperator<X>> getMaps() {
        return this.maps;
    }

    @NotNull
    public Collection<String> getRegex() {
        return this.regex;
    }

    @NotNull
    public Map<String, Supplier<String>> getReplaces() {
        return this.replaces;
    }

    @NotNull
    public X getValue() {
        return this.value;
    }
}

