/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.CommandPermission;
import dev.jorel.commandapi.CustomCommandExecutor;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.IGreedyArgument;
import dev.jorel.commandapi.arguments.MultiLiteralArgument;
import dev.jorel.commandapi.exceptions.GreedyArgumentException;
import dev.jorel.commandapi.exceptions.InvalidCommandNameException;
import dev.jorel.commandapi.executors.CommandBlockCommandExecutor;
import dev.jorel.commandapi.executors.CommandBlockResultingCommandExecutor;
import dev.jorel.commandapi.executors.CommandExecutor;
import dev.jorel.commandapi.executors.ConsoleCommandExecutor;
import dev.jorel.commandapi.executors.ConsoleResultingCommandExecutor;
import dev.jorel.commandapi.executors.EntityCommandExecutor;
import dev.jorel.commandapi.executors.EntityResultingCommandExecutor;
import dev.jorel.commandapi.executors.NativeCommandExecutor;
import dev.jorel.commandapi.executors.NativeResultingCommandExecutor;
import dev.jorel.commandapi.executors.PlayerCommandExecutor;
import dev.jorel.commandapi.executors.PlayerResultingCommandExecutor;
import dev.jorel.commandapi.executors.ProxyCommandExecutor;
import dev.jorel.commandapi.executors.ProxyResultingCommandExecutor;
import dev.jorel.commandapi.executors.ResultingCommandExecutor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.bukkit.command.CommandSender;

public class CommandAPICommand {
    private final String commandName;
    private CommandPermission permission = CommandPermission.NONE;
    private String[] aliases = new String[0];
    private Predicate<CommandSender> requirements = s2 -> true;
    private List<Argument> args = new ArrayList<Argument>();
    private List<CommandAPICommand> subcommands = new ArrayList<CommandAPICommand>();
    private CustomCommandExecutor executor = new CustomCommandExecutor();
    private boolean isConverted;

    public CommandAPICommand(String commandName) {
        this.commandName = commandName;
        this.isConverted = false;
    }

    public CommandAPICommand withPermission(CommandPermission permission) {
        this.permission = permission;
        return this;
    }

    public CommandAPICommand withPermission(String permission) {
        this.permission = CommandPermission.fromString(permission);
        return this;
    }

    public CommandAPICommand withoutPermission(CommandPermission permission) {
        this.permission = permission.negate();
        return this;
    }

    public CommandAPICommand withoutPermission(String permission) {
        this.permission = CommandPermission.fromString(permission).negate();
        return this;
    }

    public CommandAPICommand withRequirement(Predicate<CommandSender> requirement) {
        this.requirements = this.requirements.and(requirement);
        return this;
    }

    public CommandAPICommand withAliases(String ... aliases) {
        this.aliases = aliases;
        return this;
    }

    public CommandAPICommand withArguments(List<Argument> args) {
        this.args.addAll(args);
        return this;
    }

    public CommandAPICommand withArguments(Argument ... args) {
        this.args.addAll(Arrays.asList(args));
        return this;
    }

    public CommandAPICommand withSubcommand(CommandAPICommand subcommand) {
        this.subcommands.add(subcommand);
        return this;
    }

    public CommandAPICommand executes(CommandExecutor executor) {
        this.executor.addNormalExecutor(executor);
        return this;
    }

    public CommandAPICommand executes(ResultingCommandExecutor executor) {
        this.executor.addResultingExecutor(executor);
        return this;
    }

    public CommandAPICommand executesPlayer(PlayerCommandExecutor executor) {
        this.executor.addNormalExecutor(executor);
        return this;
    }

    public CommandAPICommand executesPlayer(PlayerResultingCommandExecutor executor) {
        this.executor.addResultingExecutor(executor);
        return this;
    }

    public CommandAPICommand executesEntity(EntityCommandExecutor executor) {
        this.executor.addNormalExecutor(executor);
        return this;
    }

    public CommandAPICommand executesEntity(EntityResultingCommandExecutor executor) {
        this.executor.addResultingExecutor(executor);
        return this;
    }

    public CommandAPICommand executesProxy(ProxyCommandExecutor executor) {
        this.executor.addNormalExecutor(executor);
        return this;
    }

    public CommandAPICommand executesProxy(ProxyResultingCommandExecutor executor) {
        this.executor.addResultingExecutor(executor);
        return this;
    }

    public CommandAPICommand executesCommandBlock(CommandBlockCommandExecutor executor) {
        this.executor.addNormalExecutor(executor);
        return this;
    }

    public CommandAPICommand executesCommandBlock(CommandBlockResultingCommandExecutor executor) {
        this.executor.addResultingExecutor(executor);
        return this;
    }

    public CommandAPICommand executesConsole(ConsoleCommandExecutor executor) {
        this.executor.addNormalExecutor(executor);
        return this;
    }

    public CommandAPICommand executesConsole(ConsoleResultingCommandExecutor executor) {
        this.executor.addResultingExecutor(executor);
        return this;
    }

    public CommandAPICommand executesNative(NativeCommandExecutor executor) {
        this.executor.addNormalExecutor(executor);
        return this;
    }

    public CommandAPICommand executesNative(NativeResultingCommandExecutor executor) {
        this.executor.addResultingExecutor(executor);
        return this;
    }

    public String getName() {
        return this.commandName;
    }

    public CommandPermission getPermission() {
        return this.permission;
    }

    public void setPermission(CommandPermission permission) {
        this.permission = permission;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public void setAliases(String[] aliases) {
        this.aliases = aliases;
    }

    public Predicate<CommandSender> getRequirements() {
        return this.requirements;
    }

    public void setRequirements(Predicate<CommandSender> requirements) {
        this.requirements = requirements;
    }

    public List<Argument> getArguments() {
        return this.args;
    }

    public void setArguments(List<Argument> args) {
        this.args = args;
    }

    public List<CommandAPICommand> getSubcommands() {
        return this.subcommands;
    }

    public void setSubcommands(List<CommandAPICommand> subcommands) {
        this.subcommands = subcommands;
    }

    public CustomCommandExecutor getExecutor() {
        return this.executor;
    }

    public void setExecutor(CustomCommandExecutor executor) {
        this.executor = executor;
    }

    public boolean isConverted() {
        return this.isConverted;
    }

    void setConverted(boolean isConverted) {
        this.isConverted = isConverted;
    }

    private void flatten(CommandAPICommand rootCommand, List<Argument> prevArguments, CommandAPICommand subcommand) {
        String[] literals = new String[subcommand.aliases.length + 1];
        literals[0] = subcommand.commandName;
        System.arraycopy(subcommand.aliases, 0, literals, 1, subcommand.aliases.length);
        MultiLiteralArgument literal = (MultiLiteralArgument)new MultiLiteralArgument(literals).withPermission(subcommand.permission).withRequirement(subcommand.requirements).setListed(false);
        prevArguments.add(literal);
        if (!subcommand.executor.isEmpty()) {
            rootCommand.args = prevArguments;
            rootCommand.withArguments(subcommand.args);
            rootCommand.executor = subcommand.executor;
            rootCommand.subcommands = new ArrayList<CommandAPICommand>();
            rootCommand.register();
        }
        for (CommandAPICommand subsubcommand : new ArrayList<CommandAPICommand>(subcommand.subcommands)) {
            this.flatten(rootCommand, new ArrayList<Argument>(prevArguments), subsubcommand);
        }
    }

    public void register() {
        if (!CommandAPI.canRegister()) {
            CommandAPI.getLog().severe("Cannot register command /" + this.commandName + ", because the server has finished loading!");
            return;
        }
        try {
            if (this.commandName == null || this.commandName.length() == 0) {
                throw new InvalidCommandNameException(this.commandName);
            }
            ArrayList<Argument> copyOfArgs = this.args == null ? new ArrayList<Argument>() : new ArrayList<Argument>(this.args);
            long numGreedyArgs = copyOfArgs.stream().filter(arg -> arg instanceof IGreedyArgument).count();
            if (numGreedyArgs >= 1L) {
                if (!(copyOfArgs.toArray()[copyOfArgs.size() - 1] instanceof IGreedyArgument)) {
                    throw new GreedyArgumentException();
                }
                if (numGreedyArgs > 1L) {
                    throw new GreedyArgumentException();
                }
            }
            for (Argument argument : copyOfArgs) {
                if (argument.getArgumentPermission() != null) continue;
                argument.withPermission(this.permission);
            }
            if (!this.executor.isEmpty()) {
                CommandAPIHandler.getInstance().register(this.commandName, this.permission, this.aliases, this.requirements, copyOfArgs, this.executor, this.isConverted);
            }
            if (this.subcommands.size() > 0) {
                for (CommandAPICommand subcommand : this.subcommands) {
                    this.flatten(this, new ArrayList<Argument>(), subcommand);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

