/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.RedirectModifier;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.RootCommandNode;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.LiteralArgument;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import org.bukkit.command.CommandSender;

public abstract class Brigadier {
    public static CommandDispatcher getCommandDispatcher() {
        return CommandAPIHandler.getInstance().DISPATCHER;
    }

    public static RootCommandNode getRootNode() {
        return CommandAPIHandler.getInstance().DISPATCHER.getRoot();
    }

    public static LiteralArgumentBuilder fromLiteralArgument(LiteralArgument literalArgument) {
        return CommandAPIHandler.getInstance().getLiteralArgumentBuilderArgument(literalArgument.getLiteral(), literalArgument.getArgumentPermission(), literalArgument.getRequirements());
    }

    public static RedirectModifier fromPredicate(BiPredicate<CommandSender, Object[]> predicate, List<Argument> args) {
        return cmdCtx -> {
            if (predicate.test(CommandAPIHandler.getInstance().NMS.getSenderForCommand(cmdCtx, false), CommandAPIHandler.getInstance().argsToObjectArr(cmdCtx, args))) {
                return Collections.singleton(cmdCtx.getSource());
            }
            return Collections.emptyList();
        };
    }

    public static Command fromCommand(CommandAPICommand command) {
        try {
            return CommandAPIHandler.getInstance().generateCommand(command.getArguments(), command.getExecutor(), command.isConverted());
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static RequiredArgumentBuilder fromArgument(List<Argument> args, String nodeName) {
        return CommandAPIHandler.getInstance().getRequiredArgumentBuilderDynamic(args, CommandAPIHandler.getArgument(args, nodeName));
    }

    public static RequiredArgumentBuilder fromArgument(Argument argument) {
        ArrayList<Argument> arguments = new ArrayList<Argument>();
        arguments.add(argument);
        return CommandAPIHandler.getInstance().getRequiredArgumentBuilderDynamic(arguments, argument);
    }

    public static SuggestionProvider toSuggestions(String nodeName, List<Argument> args) {
        return CommandAPIHandler.getInstance().toSuggestions(nodeName, args);
    }
}

