/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.kubernetes;

import com.google.common.base.Preconditions;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.api.kubernetes.DiscoveredService;

public final class PodMapper {
    private static final Logger log = LogManager.getLogger(PodMapper.class);
    public static final String BASE_ANNOTATION = SystemUtils.getEnvironmentVariable((String)"MC_GAMEPLAY_LABEL", (String)"minecraft.infumia.net/enabled");
    public static final String DEFAULT_ANNOTATION = SystemUtils.getEnvironmentVariable((String)"MC_DEFAULT_LABEL", (String)"minecraft.infumia.net/default");

    @NotNull
    public static Set<DiscoveredService> backendServicesFromPodList(@NotNull PodList podList) {
        return podList.getItems().stream().filter(PodMapper::isReady).map(PodMapper::tryGetPodAsDiscoveredService).flatMap(Optional::stream).collect(Collectors.toSet());
    }

    private static int applicableBackendPortFromContainerPort(@NotNull ContainerPort port) {
        return port.getName() == null ? 0 : port.getContainerPort();
    }

    private static int backendPortFromPod(@NotNull Pod pod) {
        List ports = pod.getSpec().getContainers().stream().flatMap(c -> c.getPorts().stream()).map(PodMapper::applicableBackendPortFromContainerPort).filter(p -> p != 0).collect(Collectors.toList());
        Preconditions.checkState((ports.size() == 1 ? 1 : 0) != 0, (String)"Could not find applicable container ports for pod %s in namespace %s. Make sure the pod has either a port named 'minecraft', or a container port on 25565.", (Object)pod.getMetadata().getName(), (Object)pod.getMetadata().getNamespace());
        return (Integer)ports.get(0);
    }

    private static boolean isReady(@NotNull Pod pod) {
        return pod.getStatus().getConditions().stream().filter(condition -> !condition.getType().equalsIgnoreCase("ready")).allMatch(condition -> condition.getStatus().equalsIgnoreCase("true"));
    }

    @NotNull
    private static DiscoveredService podAsDiscoveredService(@NotNull Pod pod) {
        ObjectMeta metadata = pod.getMetadata();
        return new DiscoveredService(metadata.getName(), pod.getStatus().getPodIP(), PodMapper.backendPortFromPod(pod), metadata.getLabels() != null && metadata.getLabels().containsKey(DEFAULT_ANNOTATION));
    }

    @NotNull
    private static Optional<DiscoveredService> tryGetPodAsDiscoveredService(@NotNull Pod pod) {
        try {
            return Optional.of(PodMapper.podAsDiscoveredService(pod));
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return Optional.empty();
        }
    }
}

