/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.api.scoreboard;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.api.scoreboard.BoardType;
import tr.com.infumia.infumialib.api.scoreboard.ScoreboardSender;
import tr.com.infumia.infumialib.api.scoreboard.line.Line;

public final class Board<O>
implements Closeable {
    private static final Map<String, Board<?>> BOARDS = new ConcurrentHashMap();
    @NotNull
    private final ScheduledExecutorService asyncScheduler;
    @NotNull
    private final Collection<Supplier<Collection<? extends O>>> dynamicObserverList;
    @NotNull
    private final Collection<Supplier<? extends O>> dynamicObservers;
    @NotNull
    private final Collection<Predicate<O>> filters;
    @Nullable
    private final String id;
    @NotNull
    private final List<Line<O>> lines;
    private final ThreadLocal<MutableBoard<O>> mutableBoard = ThreadLocal.withInitial(() -> new MutableBoard(this));
    @NotNull
    private final Class<O> observerClass;
    @NotNull
    private final Collection<Predicate<O>> removeIf;
    @NotNull
    private final Collection<Consumer<O>> runAfter;
    @NotNull
    private final Collection<Consumer<O>> runBefore;
    @NotNull
    private final ScoreboardSender<O> scoreboardSender;
    private final long startDelay;
    @NotNull
    private final Collection<O> staticObservers;
    private final long tick;
    @NotNull
    private final Line<O> titleLine;
    @NotNull
    private final BoardType type;

    @NotNull
    public static Optional<Board<?>> getBoardById(@NotNull String id) {
        return Optional.ofNullable(BOARDS.get(id));
    }

    @NotNull
    public static <O> Optional<Board<O>> getBoardById(@NotNull Class<O> observerClass, @NotNull String id) {
        return Board.getBoardById(id).filter(board -> observerClass.isAssignableFrom(board.getObserverClass())).map(board -> board);
    }

    @NotNull
    public static <O> Builder<O> newBuilder(@NotNull Class<O> observerClass) {
        return new Builder<O>(observerClass);
    }

    @Override
    public void close() {
        this.asyncScheduler.shutdown();
        this.scoreboardSender.close();
        this.lines.forEach(Line::close);
    }

    public void reset() {
        this.mutableBoard.set(new MutableBoard(this));
    }

    public void send() {
        this.send(false);
    }

    public void send(boolean reset) {
        if (reset) {
            this.reset();
        }
        this.mutableBoard.get().send();
    }

    public void start() {
        this.reset();
        this.asyncScheduler.scheduleAtFixedRate(this::send, this.startDelay, this.tick, TimeUnit.MILLISECONDS);
    }

    @NotNull
    public ScheduledExecutorService getAsyncScheduler() {
        return this.asyncScheduler;
    }

    @NotNull
    public Collection<Supplier<Collection<? extends O>>> getDynamicObserverList() {
        return this.dynamicObserverList;
    }

    @NotNull
    public Collection<Supplier<? extends O>> getDynamicObservers() {
        return this.dynamicObservers;
    }

    @NotNull
    public Collection<Predicate<O>> getFilters() {
        return this.filters;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    @NotNull
    public List<Line<O>> getLines() {
        return this.lines;
    }

    public ThreadLocal<MutableBoard<O>> getMutableBoard() {
        return this.mutableBoard;
    }

    @NotNull
    public Class<O> getObserverClass() {
        return this.observerClass;
    }

    @NotNull
    public Collection<Predicate<O>> getRemoveIf() {
        return this.removeIf;
    }

    @NotNull
    public Collection<Consumer<O>> getRunAfter() {
        return this.runAfter;
    }

    @NotNull
    public Collection<Consumer<O>> getRunBefore() {
        return this.runBefore;
    }

    @NotNull
    public ScoreboardSender<O> getScoreboardSender() {
        return this.scoreboardSender;
    }

    public long getStartDelay() {
        return this.startDelay;
    }

    @NotNull
    public Collection<O> getStaticObservers() {
        return this.staticObservers;
    }

    public long getTick() {
        return this.tick;
    }

    @NotNull
    public Line<O> getTitleLine() {
        return this.titleLine;
    }

    @NotNull
    public BoardType getType() {
        return this.type;
    }

    public String toString() {
        return "Board(asyncScheduler=" + this.getAsyncScheduler() + ", dynamicObserverList=" + this.getDynamicObserverList() + ", dynamicObservers=" + this.getDynamicObservers() + ", filters=" + this.getFilters() + ", id=" + this.getId() + ", lines=" + this.getLines() + ", mutableBoard=" + this.getMutableBoard() + ", observerClass=" + this.getObserverClass() + ", removeIf=" + this.getRemoveIf() + ", runAfter=" + this.getRunAfter() + ", runBefore=" + this.getRunBefore() + ", scoreboardSender=" + this.getScoreboardSender() + ", startDelay=" + this.getStartDelay() + ", staticObservers=" + this.getStaticObservers() + ", tick=" + this.getTick() + ", titleLine=" + this.getTitleLine() + ", type=" + this.getType() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Board)) {
            return false;
        }
        Board other = (Board)o;
        if (this.getStartDelay() != other.getStartDelay()) {
            return false;
        }
        if (this.getTick() != other.getTick()) {
            return false;
        }
        ScheduledExecutorService this$asyncScheduler = this.getAsyncScheduler();
        ScheduledExecutorService other$asyncScheduler = other.getAsyncScheduler();
        if (this$asyncScheduler == null ? other$asyncScheduler != null : !this$asyncScheduler.equals(other$asyncScheduler)) {
            return false;
        }
        Collection<Supplier<Collection<O>>> this$dynamicObserverList = this.getDynamicObserverList();
        Collection<Supplier<Collection<O>>> other$dynamicObserverList = other.getDynamicObserverList();
        if (this$dynamicObserverList == null ? other$dynamicObserverList != null : !((Object)this$dynamicObserverList).equals(other$dynamicObserverList)) {
            return false;
        }
        Collection<Supplier<O>> this$dynamicObservers = this.getDynamicObservers();
        Collection<Supplier<O>> other$dynamicObservers = other.getDynamicObservers();
        if (this$dynamicObservers == null ? other$dynamicObservers != null : !((Object)this$dynamicObservers).equals(other$dynamicObservers)) {
            return false;
        }
        Collection<Predicate<O>> this$filters = this.getFilters();
        Collection<Predicate<O>> other$filters = other.getFilters();
        if (this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        List<Line<O>> this$lines = this.getLines();
        List<Line<O>> other$lines = other.getLines();
        if (this$lines == null ? other$lines != null : !((Object)this$lines).equals(other$lines)) {
            return false;
        }
        ThreadLocal<MutableBoard<O>> this$mutableBoard = this.getMutableBoard();
        ThreadLocal<MutableBoard<O>> other$mutableBoard = other.getMutableBoard();
        if (this$mutableBoard == null ? other$mutableBoard != null : !this$mutableBoard.equals(other$mutableBoard)) {
            return false;
        }
        Class<O> this$observerClass = this.getObserverClass();
        Class<O> other$observerClass = other.getObserverClass();
        if (this$observerClass == null ? other$observerClass != null : !this$observerClass.equals(other$observerClass)) {
            return false;
        }
        Collection<Predicate<O>> this$removeIf = this.getRemoveIf();
        Collection<Predicate<O>> other$removeIf = other.getRemoveIf();
        if (this$removeIf == null ? other$removeIf != null : !((Object)this$removeIf).equals(other$removeIf)) {
            return false;
        }
        Collection<Consumer<O>> this$runAfter = this.getRunAfter();
        Collection<Consumer<O>> other$runAfter = other.getRunAfter();
        if (this$runAfter == null ? other$runAfter != null : !((Object)this$runAfter).equals(other$runAfter)) {
            return false;
        }
        Collection<Consumer<O>> this$runBefore = this.getRunBefore();
        Collection<Consumer<O>> other$runBefore = other.getRunBefore();
        if (this$runBefore == null ? other$runBefore != null : !((Object)this$runBefore).equals(other$runBefore)) {
            return false;
        }
        ScoreboardSender<O> this$scoreboardSender = this.getScoreboardSender();
        ScoreboardSender<O> other$scoreboardSender = other.getScoreboardSender();
        if (this$scoreboardSender == null ? other$scoreboardSender != null : !this$scoreboardSender.equals(other$scoreboardSender)) {
            return false;
        }
        Collection<O> this$staticObservers = this.getStaticObservers();
        Collection<O> other$staticObservers = other.getStaticObservers();
        if (this$staticObservers == null ? other$staticObservers != null : !((Object)this$staticObservers).equals(other$staticObservers)) {
            return false;
        }
        Line<O> this$titleLine = this.getTitleLine();
        Line<O> other$titleLine = other.getTitleLine();
        if (this$titleLine == null ? other$titleLine != null : !this$titleLine.equals(other$titleLine)) {
            return false;
        }
        BoardType this$type = this.getType();
        BoardType other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startDelay = this.getStartDelay();
        result = result * 59 + (int)($startDelay >>> 32 ^ $startDelay);
        long $tick = this.getTick();
        result = result * 59 + (int)($tick >>> 32 ^ $tick);
        ScheduledExecutorService $asyncScheduler = this.getAsyncScheduler();
        result = result * 59 + ($asyncScheduler == null ? 43 : $asyncScheduler.hashCode());
        Collection<Supplier<Collection<O>>> $dynamicObserverList = this.getDynamicObserverList();
        result = result * 59 + ($dynamicObserverList == null ? 43 : ((Object)$dynamicObserverList).hashCode());
        Collection<Supplier<O>> $dynamicObservers = this.getDynamicObservers();
        result = result * 59 + ($dynamicObservers == null ? 43 : ((Object)$dynamicObservers).hashCode());
        Collection<Predicate<O>> $filters = this.getFilters();
        result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        List<Line<O>> $lines = this.getLines();
        result = result * 59 + ($lines == null ? 43 : ((Object)$lines).hashCode());
        ThreadLocal<MutableBoard<O>> $mutableBoard = this.getMutableBoard();
        result = result * 59 + ($mutableBoard == null ? 43 : $mutableBoard.hashCode());
        Class<O> $observerClass = this.getObserverClass();
        result = result * 59 + ($observerClass == null ? 43 : $observerClass.hashCode());
        Collection<Predicate<O>> $removeIf = this.getRemoveIf();
        result = result * 59 + ($removeIf == null ? 43 : ((Object)$removeIf).hashCode());
        Collection<Consumer<O>> $runAfter = this.getRunAfter();
        result = result * 59 + ($runAfter == null ? 43 : ((Object)$runAfter).hashCode());
        Collection<Consumer<O>> $runBefore = this.getRunBefore();
        result = result * 59 + ($runBefore == null ? 43 : ((Object)$runBefore).hashCode());
        ScoreboardSender<O> $scoreboardSender = this.getScoreboardSender();
        result = result * 59 + ($scoreboardSender == null ? 43 : $scoreboardSender.hashCode());
        Collection<O> $staticObservers = this.getStaticObservers();
        result = result * 59 + ($staticObservers == null ? 43 : ((Object)$staticObservers).hashCode());
        Line<O> $titleLine = this.getTitleLine();
        result = result * 59 + ($titleLine == null ? 43 : $titleLine.hashCode());
        BoardType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    private Board(@NotNull ScheduledExecutorService asyncScheduler, @NotNull Collection<Supplier<Collection<? extends O>>> dynamicObserverList, @NotNull Collection<Supplier<? extends O>> dynamicObservers, @NotNull Collection<Predicate<O>> filters, @Nullable String id, @NotNull List<Line<O>> lines, @NotNull Class<O> observerClass, @NotNull Collection<Predicate<O>> removeIf, @NotNull Collection<Consumer<O>> runAfter, @NotNull Collection<Consumer<O>> runBefore, @NotNull ScoreboardSender<O> scoreboardSender, long startDelay, @NotNull Collection<O> staticObservers, long tick, @NotNull Line<O> titleLine, @NotNull BoardType type) {
        if (asyncScheduler == null) {
            throw new NullPointerException("asyncScheduler is marked non-null but is null");
        }
        if (dynamicObserverList == null) {
            throw new NullPointerException("dynamicObserverList is marked non-null but is null");
        }
        if (dynamicObservers == null) {
            throw new NullPointerException("dynamicObservers is marked non-null but is null");
        }
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        if (lines == null) {
            throw new NullPointerException("lines is marked non-null but is null");
        }
        if (observerClass == null) {
            throw new NullPointerException("observerClass is marked non-null but is null");
        }
        if (removeIf == null) {
            throw new NullPointerException("removeIf is marked non-null but is null");
        }
        if (runAfter == null) {
            throw new NullPointerException("runAfter is marked non-null but is null");
        }
        if (runBefore == null) {
            throw new NullPointerException("runBefore is marked non-null but is null");
        }
        if (scoreboardSender == null) {
            throw new NullPointerException("scoreboardSender is marked non-null but is null");
        }
        if (staticObservers == null) {
            throw new NullPointerException("staticObservers is marked non-null but is null");
        }
        if (titleLine == null) {
            throw new NullPointerException("titleLine is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.asyncScheduler = asyncScheduler;
        this.dynamicObserverList = dynamicObserverList;
        this.dynamicObservers = dynamicObservers;
        this.filters = filters;
        this.id = id;
        this.lines = lines;
        this.observerClass = observerClass;
        this.removeIf = removeIf;
        this.runAfter = runAfter;
        this.runBefore = runBefore;
        this.scoreboardSender = scoreboardSender;
        this.startDelay = startDelay;
        this.staticObservers = staticObservers;
        this.tick = tick;
        this.titleLine = titleLine;
        this.type = type;
    }

    public static final class Builder<O> {
        @NotNull
        private final Class<O> observerClass;
        @NotNull
        private ScheduledExecutorService asyncScheduler = Executors.newScheduledThreadPool(2);
        @NotNull
        private Collection<Supplier<Collection<? extends O>>> dynamicObserverList = new HashSet<Supplier<Collection<? extends O>>>();
        @NotNull
        private Collection<Supplier<? extends O>> dynamicObservers = new HashSet<Supplier<? extends O>>();
        @NotNull
        private Collection<Predicate<O>> filters = new HashSet<Predicate<O>>();
        @Nullable
        private String id;
        @NotNull
        private List<Line<O>> lines = new ArrayList<Line<O>>();
        @NotNull
        private Collection<Predicate<O>> removeIf = new HashSet<Predicate<O>>();
        @NotNull
        private Collection<Consumer<O>> runAfter = new HashSet<Consumer<O>>();
        @NotNull
        private Collection<Consumer<O>> runBefore = new HashSet<Consumer<O>>();
        @NotNull
        private ScoreboardSender<O> scoreboardSender = new ScoreboardSender.Empty();
        private long startDelay = 1000L;
        @NotNull
        private Collection<O> staticObservers = new HashSet<O>();
        private long tick = 1000L;
        @NotNull
        private Line<O> titleLine = Line.immutable("");
        @NotNull
        private BoardType type = BoardType.MODERN;

        @SafeVarargs
        @NotNull
        public final Builder<O> addDynamicObserverList(Supplier<Collection<? extends O>> ... dynamicObserverList) {
            Collections.addAll(this.dynamicObserverList, dynamicObserverList);
            return this;
        }

        @SafeVarargs
        @NotNull
        public final Builder<O> addDynamicObservers(Supplier<O> ... dynamicObservers) {
            Collections.addAll(this.dynamicObservers, dynamicObservers);
            return this;
        }

        @SafeVarargs
        @NotNull
        public final Builder<O> addFilters(Predicate<O> ... filters) {
            Collections.addAll(this.filters, filters);
            return this;
        }

        @SafeVarargs
        @NotNull
        public final Builder<O> addLines(Line<O> ... lines) {
            Collections.addAll(this.lines, lines);
            return this;
        }

        @SafeVarargs
        @NotNull
        public final Builder<O> addRemoveIf(Predicate<O> ... removeIf) {
            Collections.addAll(this.removeIf, removeIf);
            return this;
        }

        @SafeVarargs
        @NotNull
        public final Builder<O> addRunAfter(Consumer<O> ... runAfter) {
            Collections.addAll(this.runAfter, runAfter);
            return this;
        }

        @SafeVarargs
        @NotNull
        public final Builder<O> addRunBefore(Consumer<O> ... runBefore) {
            Collections.addAll(this.runBefore, runBefore);
            return this;
        }

        @SafeVarargs
        @NotNull
        public final Builder<O> addStaticObservers(O ... observers) {
            Collections.addAll(this.staticObservers, observers);
            return this;
        }

        @SafeVarargs
        @NotNull
        public final Builder<O> setDynamicObserverList(Supplier<Collection<? extends O>> ... dynamicObserverList) {
            return this.setDynamicObserverList(Set.of(dynamicObserverList));
        }

        @SafeVarargs
        @NotNull
        public final Builder<O> setDynamicObservers(Supplier<O> ... dynamicObservers) {
            return this.setDynamicObservers(Set.of(dynamicObservers));
        }

        @SafeVarargs
        @NotNull
        public final Builder<O> setStaticObservers(O ... staticObservers) {
            return this.setStaticObservers((Collection<O>)Set.of(staticObservers));
        }

        @NotNull
        public Builder<O> addLine(int lineNumber, @NotNull Line<O> line) {
            this.lines.set(lineNumber, line);
            return this;
        }

        @NotNull
        public Builder<O> addLine(int lineNumber, @NotNull @NotNull Function<@NotNull O, @NotNull String> line) {
            return this.addLine(lineNumber, Line.dynamic(line));
        }

        @NotNull
        public Board<O> build() {
            if (this.id != null && BOARDS.containsKey(this.id)) {
                throw new IllegalArgumentException(String.format("Id called %s is already exist in the boards map.", this.id));
            }
            Board<? extends O> board = new Board<O>(this.asyncScheduler, this.dynamicObserverList, this.dynamicObservers, this.filters, this.id, this.lines, this.observerClass, this.removeIf, this.runAfter, this.runBefore, this.scoreboardSender, this.startDelay, this.staticObservers, this.tick, this.titleLine, this.type);
            if (this.id != null) {
                BOARDS.put(this.id, board);
            }
            return board;
        }

        @NotNull
        public Builder<O> setAsyncScheduler(@NotNull ScheduledExecutorService asyncScheduler) {
            this.asyncScheduler = asyncScheduler;
            return this;
        }

        @NotNull
        public Builder<O> setDynamicObserverList(@NotNull Collection<Supplier<Collection<? extends O>>> dynamicObserverList) {
            this.dynamicObserverList = dynamicObserverList;
            return this;
        }

        @NotNull
        public Builder<O> setDynamicObservers(@NotNull Collection<Supplier<? extends O>> dynamicObservers) {
            this.dynamicObservers = dynamicObservers;
            return this;
        }

        @NotNull
        public Builder<O> setFilters(@NotNull Collection<Predicate<O>> filters) {
            this.filters = filters;
            return this;
        }

        @NotNull
        public Builder<O> setId(String id) {
            this.id = id;
            return this;
        }

        @NotNull
        public Builder<O> setLines(@NotNull List<Line<O>> lines) {
            this.lines = lines;
            return this;
        }

        @NotNull
        public Builder<O> setRemoveIf(@NotNull Collection<Predicate<O>> removeIf) {
            this.removeIf = removeIf;
            return this;
        }

        @NotNull
        public Builder<O> setRunAfter(@NotNull Collection<Consumer<O>> runAfter) {
            this.runAfter = runAfter;
            return this;
        }

        @NotNull
        public Builder<O> setRunBefore(@NotNull Collection<Consumer<O>> runBefore) {
            this.runBefore = runBefore;
            return this;
        }

        @NotNull
        public Builder<O> setScoreboardSender(@NotNull ScoreboardSender<O> scoreboardSender) {
            this.scoreboardSender = scoreboardSender;
            return this;
        }

        @NotNull
        public Builder<O> setStartDelay(long startDelay) {
            if (startDelay < 0L) {
                throw new IllegalArgumentException("Start delay shouldn't less than 0.");
            }
            this.startDelay = startDelay;
            return this;
        }

        @NotNull
        public Builder<O> setStaticObservers(@NotNull Collection<O> staticObservers) {
            this.staticObservers = staticObservers;
            return this;
        }

        @NotNull
        public Builder<O> setTick(long tick) {
            if (tick <= 0L) {
                throw new IllegalArgumentException("Tick shouldn't equal or less than 0.");
            }
            this.tick = tick;
            return this;
        }

        @NotNull
        public Builder<O> setTitleLine(Line<O> titleLine) {
            this.titleLine = titleLine;
            return this;
        }

        @NotNull
        public Builder<O> setType(@NotNull BoardType type) {
            this.type = type;
            return this;
        }

        @NotNull
        public Class<O> getObserverClass() {
            return this.observerClass;
        }

        @NotNull
        public ScheduledExecutorService getAsyncScheduler() {
            return this.asyncScheduler;
        }

        @NotNull
        public Collection<Supplier<Collection<? extends O>>> getDynamicObserverList() {
            return this.dynamicObserverList;
        }

        @NotNull
        public Collection<Supplier<? extends O>> getDynamicObservers() {
            return this.dynamicObservers;
        }

        @NotNull
        public Collection<Predicate<O>> getFilters() {
            return this.filters;
        }

        @Nullable
        public String getId() {
            return this.id;
        }

        @NotNull
        public List<Line<O>> getLines() {
            return this.lines;
        }

        @NotNull
        public Collection<Predicate<O>> getRemoveIf() {
            return this.removeIf;
        }

        @NotNull
        public Collection<Consumer<O>> getRunAfter() {
            return this.runAfter;
        }

        @NotNull
        public Collection<Consumer<O>> getRunBefore() {
            return this.runBefore;
        }

        @NotNull
        public ScoreboardSender<O> getScoreboardSender() {
            return this.scoreboardSender;
        }

        public long getStartDelay() {
            return this.startDelay;
        }

        @NotNull
        public Collection<O> getStaticObservers() {
            return this.staticObservers;
        }

        public long getTick() {
            return this.tick;
        }

        @NotNull
        public Line<O> getTitleLine() {
            return this.titleLine;
        }

        @NotNull
        public BoardType getType() {
            return this.type;
        }

        private Builder(@NotNull Class<O> observerClass) {
            if (observerClass == null) {
                throw new NullPointerException("observerClass is marked non-null but is null");
            }
            this.observerClass = observerClass;
        }
    }

    private static final class MutableBoard<O> {
        @NotNull
        private final Board<O> board;
        @NotNull
        private final Collection<O> staticObservers;

        private MutableBoard(@NotNull Board<O> board) {
            this.board = board;
            this.staticObservers = new HashSet<O>(board.getStaticObservers());
        }

        public void send() {
            this.staticObserversRemoveIf();
            Collection<O> observers = this.getObservers();
            if (observers.isEmpty()) {
                return;
            }
            this.board.getRunBefore().forEach(observers::forEach);
            this.board.getScoreboardSender().send(this.board, observers, this.board.getLines());
            this.board.getRunAfter().forEach(observers::forEach);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        private Collection<O> getObservers() {
            Collection<O> collection = this.staticObservers;
            synchronized (collection) {
                HashSet<Object> observers = new HashSet<Object>();
                for (O o : this.staticObservers) {
                    boolean b = true;
                    for (Predicate<O> predicate : this.board.getFilters()) {
                        if (predicate.test(o)) continue;
                        b = false;
                        break;
                    }
                    if (!b) continue;
                    observers.add(o);
                }
                for (Supplier supplier : this.board.getDynamicObservers()) {
                    Object o = supplier.get();
                    boolean b = true;
                    for (Predicate predicate : this.board.getFilters()) {
                        if (predicate.test(o)) continue;
                        b = false;
                        break;
                    }
                    if (!b) continue;
                    observers.add(o);
                }
                for (Supplier supplier : this.board.getDynamicObserverList()) {
                    for (Object observer : (Collection)supplier.get()) {
                        boolean b = true;
                        for (Predicate<O> predicate : this.board.getFilters()) {
                            if (predicate.test(observer)) continue;
                            b = false;
                            break;
                        }
                        if (!b) continue;
                        observers.add(observer);
                    }
                }
                return observers;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void staticObserversRemoveIf() {
            Collection<O> collection = this.staticObservers;
            synchronized (collection) {
                this.staticObservers.removeIf(observer -> {
                    for (Predicate<O> predicate : this.board.getRemoveIf()) {
                        if (!predicate.test(observer)) continue;
                        return true;
                    }
                    return false;
                });
            }
        }
    }
}

