/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.app.builder;

import io.github.slimjar.app.Application;
import io.github.slimjar.app.builder.InjectingApplicationBuilder;
import io.github.slimjar.app.builder.IsolatedApplicationBuilder;
import io.github.slimjar.app.builder.IsolationConfiguration;
import io.github.slimjar.downloader.DependencyDownloaderFactory;
import io.github.slimjar.downloader.URLDependencyDownloaderFactory;
import io.github.slimjar.downloader.output.DependencyOutputWriterFactory;
import io.github.slimjar.downloader.strategy.ChecksumFilePathStrategy;
import io.github.slimjar.downloader.strategy.FilePathStrategy;
import io.github.slimjar.downloader.verify.ChecksumDependencyVerifierFactory;
import io.github.slimjar.downloader.verify.DependencyVerifierFactory;
import io.github.slimjar.downloader.verify.FileChecksumCalculator;
import io.github.slimjar.downloader.verify.PassthroughDependencyVerifierFactory;
import io.github.slimjar.injector.DependencyInjector;
import io.github.slimjar.injector.DependencyInjectorFactory;
import io.github.slimjar.injector.SimpleDependencyInjectorFactory;
import io.github.slimjar.injector.helper.InjectionHelperFactory;
import io.github.slimjar.injector.loader.Injectable;
import io.github.slimjar.logging.LogDispatcher;
import io.github.slimjar.logging.MediatingProcessLogger;
import io.github.slimjar.logging.ProcessLogger;
import io.github.slimjar.relocation.JarFileRelocatorFactory;
import io.github.slimjar.relocation.RelocatorFactory;
import io.github.slimjar.relocation.facade.JarRelocatorFacadeFactory;
import io.github.slimjar.relocation.facade.ReflectiveJarRelocatorFacadeFactory;
import io.github.slimjar.relocation.helper.RelocationHelperFactory;
import io.github.slimjar.relocation.helper.VerifyingRelocationHelperFactory;
import io.github.slimjar.relocation.meta.FlatFileMetaMediatorFactory;
import io.github.slimjar.relocation.meta.MetaMediatorFactory;
import io.github.slimjar.resolver.CachingDependencyResolverFactory;
import io.github.slimjar.resolver.DependencyResolverFactory;
import io.github.slimjar.resolver.data.Repository;
import io.github.slimjar.resolver.enquirer.PingingRepositoryEnquirerFactory;
import io.github.slimjar.resolver.enquirer.RepositoryEnquirerFactory;
import io.github.slimjar.resolver.mirrors.MirrorSelector;
import io.github.slimjar.resolver.mirrors.SimpleMirrorSelector;
import io.github.slimjar.resolver.pinger.HttpURLPinger;
import io.github.slimjar.resolver.reader.dependency.DependencyDataProviderFactory;
import io.github.slimjar.resolver.reader.dependency.ExternalDependencyDataProviderFactory;
import io.github.slimjar.resolver.reader.dependency.GsonDependencyDataProviderFactory;
import io.github.slimjar.resolver.reader.facade.GsonFacadeFactory;
import io.github.slimjar.resolver.reader.facade.ReflectiveGsonFacadeFactory;
import io.github.slimjar.resolver.reader.resolution.GsonPreResolutionDataProviderFactory;
import io.github.slimjar.resolver.reader.resolution.PreResolutionDataProviderFactory;
import io.github.slimjar.resolver.strategy.MavenChecksumPathResolutionStrategy;
import io.github.slimjar.resolver.strategy.MavenPathResolutionStrategy;
import io.github.slimjar.resolver.strategy.MavenPomPathResolutionStrategy;
import io.github.slimjar.resolver.strategy.MavenSnapshotPathResolutionStrategy;
import io.github.slimjar.resolver.strategy.MediatingPathResolutionStrategy;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public abstract class ApplicationBuilder {
    private static final Path DEFAULT_DOWNLOAD_DIRECTORY;
    private final String applicationName;
    private URL dependencyFileUrl;
    private URL preResolutionFileUrl;
    private Path downloadDirectoryPath;
    private RelocatorFactory relocatorFactory;
    private DependencyDataProviderFactory moduleDataProviderFactory;
    private DependencyDataProviderFactory dataProviderFactory;
    private PreResolutionDataProviderFactory preResolutionDataProviderFactory;
    private RelocationHelperFactory relocationHelperFactory;
    private DependencyInjectorFactory injectorFactory;
    private DependencyResolverFactory resolverFactory;
    private RepositoryEnquirerFactory enquirerFactory;
    private DependencyDownloaderFactory downloaderFactory;
    private DependencyVerifierFactory verifierFactory;
    private MirrorSelector mirrorSelector;
    private Collection<Repository> internalRepositories;
    private ProcessLogger logger;

    protected ApplicationBuilder(String applicationName) {
        this.applicationName = Objects.requireNonNull(applicationName, "Requires non-null application name!");
    }

    public static ApplicationBuilder isolated(String name, IsolationConfiguration config, Object[] args) {
        return new IsolatedApplicationBuilder(name, config, args);
    }

    public static ApplicationBuilder appending(String name) throws URISyntaxException, ReflectiveOperationException, NoSuchAlgorithmException, IOException {
        return InjectingApplicationBuilder.createAppending(name);
    }

    public static ApplicationBuilder injecting(String name, Injectable injectable) {
        return new InjectingApplicationBuilder(name, injectable);
    }

    public final ApplicationBuilder dependencyFileUrl(URL dependencyFileUrl) {
        this.dependencyFileUrl = dependencyFileUrl;
        return this;
    }

    public final ApplicationBuilder preResolutionFileUrl(URL preResolutionFileUrl) {
        this.preResolutionFileUrl = preResolutionFileUrl;
        return this;
    }

    public final ApplicationBuilder downloadDirectoryPath(Path downloadDirectoryPath) {
        this.downloadDirectoryPath = downloadDirectoryPath;
        return this;
    }

    public final ApplicationBuilder relocatorFactory(RelocatorFactory relocatorFactory) {
        this.relocatorFactory = relocatorFactory;
        return this;
    }

    public final ApplicationBuilder moduleDataProviderFactory(DependencyDataProviderFactory moduleDataProviderFactory) {
        this.moduleDataProviderFactory = moduleDataProviderFactory;
        return this;
    }

    public final ApplicationBuilder dataProviderFactory(DependencyDataProviderFactory dataProviderFactory) {
        this.dataProviderFactory = dataProviderFactory;
        return this;
    }

    public final ApplicationBuilder preResolutionDataProviderFactory(PreResolutionDataProviderFactory preResolutionDataProviderFactory) {
        this.preResolutionDataProviderFactory = preResolutionDataProviderFactory;
        return this;
    }

    public final ApplicationBuilder relocationHelperFactory(RelocationHelperFactory relocationHelperFactory) {
        this.relocationHelperFactory = relocationHelperFactory;
        return this;
    }

    public final ApplicationBuilder injectorFactory(DependencyInjectorFactory injectorFactory) {
        this.injectorFactory = injectorFactory;
        return this;
    }

    public final ApplicationBuilder resolverFactory(DependencyResolverFactory resolverFactory) {
        this.resolverFactory = resolverFactory;
        return this;
    }

    public final ApplicationBuilder enquirerFactory(RepositoryEnquirerFactory enquirerFactory) {
        this.enquirerFactory = enquirerFactory;
        return this;
    }

    public final ApplicationBuilder downloaderFactory(DependencyDownloaderFactory downloaderFactory) {
        this.downloaderFactory = downloaderFactory;
        return this;
    }

    public final ApplicationBuilder verifierFactory(DependencyVerifierFactory verifierFactory) {
        this.verifierFactory = verifierFactory;
        return this;
    }

    public final ApplicationBuilder mirrorSelector(MirrorSelector mirrorSelector) {
        this.mirrorSelector = mirrorSelector;
        return this;
    }

    public final ApplicationBuilder internalRepositories(Collection<Repository> repositories) {
        this.internalRepositories = repositories;
        return this;
    }

    public final ApplicationBuilder logger(ProcessLogger logger) {
        this.logger = logger;
        return this;
    }

    protected final String getApplicationName() {
        return this.applicationName;
    }

    protected final URL getDependencyFileUrl() {
        if (this.dependencyFileUrl == null) {
            this.dependencyFileUrl = this.getClass().getClassLoader().getResource("slimjar.json");
        }
        return this.dependencyFileUrl;
    }

    protected final URL getPreResolutionFileUrl() {
        if (this.preResolutionFileUrl == null) {
            this.preResolutionFileUrl = this.getClass().getClassLoader().getResource("slimjar-resolutions.json");
        }
        return this.preResolutionFileUrl;
    }

    protected final Path getDownloadDirectoryPath() {
        if (this.downloadDirectoryPath == null) {
            this.downloadDirectoryPath = DEFAULT_DOWNLOAD_DIRECTORY;
        }
        return this.downloadDirectoryPath;
    }

    protected final RelocatorFactory getRelocatorFactory() throws ReflectiveOperationException, NoSuchAlgorithmException, IOException, URISyntaxException {
        if (this.relocatorFactory == null) {
            JarRelocatorFacadeFactory jarRelocatorFacadeFactory = ReflectiveJarRelocatorFacadeFactory.create(this.getDownloadDirectoryPath(), this.getInternalRepositories());
            this.relocatorFactory = new JarFileRelocatorFactory(jarRelocatorFacadeFactory);
        }
        return this.relocatorFactory;
    }

    protected final DependencyDataProviderFactory getModuleDataProviderFactory() throws URISyntaxException, ReflectiveOperationException, NoSuchAlgorithmException, IOException {
        if (this.moduleDataProviderFactory == null) {
            GsonFacadeFactory gsonFacadeFactory = ReflectiveGsonFacadeFactory.create(this.getDownloadDirectoryPath(), this.getInternalRepositories());
            this.moduleDataProviderFactory = new ExternalDependencyDataProviderFactory(gsonFacadeFactory);
        }
        return this.moduleDataProviderFactory;
    }

    protected final DependencyDataProviderFactory getDataProviderFactory() throws URISyntaxException, ReflectiveOperationException, NoSuchAlgorithmException, IOException {
        if (this.dataProviderFactory == null) {
            GsonFacadeFactory gsonFacadeFactory = ReflectiveGsonFacadeFactory.create(this.getDownloadDirectoryPath(), this.getInternalRepositories());
            this.dataProviderFactory = new GsonDependencyDataProviderFactory(gsonFacadeFactory);
        }
        return this.dataProviderFactory;
    }

    protected final PreResolutionDataProviderFactory getPreResolutionDataProviderFactory() throws URISyntaxException, ReflectiveOperationException, NoSuchAlgorithmException, IOException {
        if (this.preResolutionDataProviderFactory == null) {
            GsonFacadeFactory gsonFacadeFactory = ReflectiveGsonFacadeFactory.create(this.getDownloadDirectoryPath(), this.getInternalRepositories());
            this.preResolutionDataProviderFactory = new GsonPreResolutionDataProviderFactory(gsonFacadeFactory);
        }
        return this.preResolutionDataProviderFactory;
    }

    protected final RelocationHelperFactory getRelocationHelperFactory() throws NoSuchAlgorithmException, IOException, URISyntaxException {
        if (this.relocationHelperFactory == null) {
            FileChecksumCalculator checksumCalculator = new FileChecksumCalculator("SHA-256");
            FilePathStrategy pathStrategy = FilePathStrategy.createRelocationStrategy(this.getDownloadDirectoryPath().toFile(), this.getApplicationName());
            FlatFileMetaMediatorFactory mediatorFactory = new FlatFileMetaMediatorFactory();
            this.relocationHelperFactory = new VerifyingRelocationHelperFactory(checksumCalculator, pathStrategy, (MetaMediatorFactory)mediatorFactory);
        }
        return this.relocationHelperFactory;
    }

    protected final DependencyInjectorFactory getInjectorFactory() {
        if (this.injectorFactory == null) {
            this.injectorFactory = new SimpleDependencyInjectorFactory();
        }
        return this.injectorFactory;
    }

    protected final DependencyResolverFactory getResolverFactory() {
        if (this.resolverFactory == null) {
            HttpURLPinger pinger = new HttpURLPinger();
            this.resolverFactory = new CachingDependencyResolverFactory(pinger);
        }
        return this.resolverFactory;
    }

    protected final RepositoryEnquirerFactory getEnquirerFactory() {
        if (this.enquirerFactory == null) {
            MavenPathResolutionStrategy releaseStrategy = new MavenPathResolutionStrategy();
            MavenSnapshotPathResolutionStrategy snapshotStrategy = new MavenSnapshotPathResolutionStrategy();
            MediatingPathResolutionStrategy resolutionStrategy = new MediatingPathResolutionStrategy(releaseStrategy, snapshotStrategy);
            MavenPomPathResolutionStrategy pomURLCreationStrategy = new MavenPomPathResolutionStrategy();
            MavenChecksumPathResolutionStrategy checksumResolutionStrategy = new MavenChecksumPathResolutionStrategy("SHA-1", resolutionStrategy);
            HttpURLPinger urlPinger = new HttpURLPinger();
            this.enquirerFactory = new PingingRepositoryEnquirerFactory(resolutionStrategy, checksumResolutionStrategy, pomURLCreationStrategy, urlPinger);
        }
        return this.enquirerFactory;
    }

    protected final DependencyDownloaderFactory getDownloaderFactory() {
        if (this.downloaderFactory == null) {
            this.downloaderFactory = new URLDependencyDownloaderFactory();
        }
        return this.downloaderFactory;
    }

    protected final DependencyVerifierFactory getVerifierFactory() throws NoSuchAlgorithmException {
        if (this.verifierFactory == null) {
            FilePathStrategy filePathStrategy = ChecksumFilePathStrategy.createStrategy(this.getDownloadDirectoryPath().toFile(), "SHA-1");
            DependencyOutputWriterFactory checksumOutputFactory = new DependencyOutputWriterFactory(filePathStrategy);
            PassthroughDependencyVerifierFactory fallback = new PassthroughDependencyVerifierFactory();
            FileChecksumCalculator checksumCalculator = new FileChecksumCalculator("SHA-1");
            this.verifierFactory = new ChecksumDependencyVerifierFactory(checksumOutputFactory, fallback, checksumCalculator);
        }
        return this.verifierFactory;
    }

    protected final MirrorSelector getMirrorSelector() throws MalformedURLException {
        if (this.mirrorSelector == null) {
            this.mirrorSelector = new SimpleMirrorSelector(this.getInternalRepositories());
        }
        return this.mirrorSelector;
    }

    protected final Collection<Repository> getInternalRepositories() throws MalformedURLException {
        if (this.internalRepositories == null) {
            this.internalRepositories = Collections.singleton(new Repository(new URL("https://repo.vshnv.tech/")));
        }
        return this.internalRepositories;
    }

    protected final ProcessLogger getLogger() {
        if (this.logger == null) {
            this.logger = (msg, args) -> {};
        }
        return this.logger;
    }

    protected final DependencyInjector createInjector() throws IOException, URISyntaxException, NoSuchAlgorithmException, ReflectiveOperationException {
        InjectionHelperFactory injectionHelperFactory = new InjectionHelperFactory(this.getDownloadDirectoryPath(), this.getRelocatorFactory(), this.getDataProviderFactory(), this.getRelocationHelperFactory(), this.getInjectorFactory(), this.getResolverFactory(), this.getEnquirerFactory(), this.getDownloaderFactory(), this.getVerifierFactory(), this.getMirrorSelector());
        return this.getInjectorFactory().create(injectionHelperFactory);
    }

    public final Application build() throws IOException, ReflectiveOperationException, URISyntaxException, NoSuchAlgorithmException {
        MediatingProcessLogger mediatingLogger = LogDispatcher.getMediatingLogger();
        ProcessLogger logger = this.getLogger();
        mediatingLogger.addLogger(logger);
        Application result = this.buildApplication();
        mediatingLogger.removeLogger(logger);
        return result;
    }

    protected abstract Application buildApplication() throws IOException, ReflectiveOperationException, URISyntaxException, NoSuchAlgorithmException;

    static {
        String userHome = System.getProperty("user.home");
        String defaultPath = String.format("%s/.slimjar", userHome);
        DEFAULT_DOWNLOAD_DIRECTORY = new File(defaultPath).toPath();
    }
}

