/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.misc;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.awt.Color;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public final class Jackson {
    public static final JsonMapper JSON_MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().addModule((Module)new SimpleModule().addDeserializer(Color.class, (JsonDeserializer)new ColorDeserializer()).addSerializer(Color.class, (JsonSerializer)new ColorSerializer()))).build();

    static {
        JSON_MAPPER.getFactory().setCharacterEscapes((CharacterEscapes)new CustomCharacterEscapes());
    }

    private static final class ColorDeserializer
    extends JsonDeserializer<Color> {
        public Color deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return new Color(Integer.parseUnsignedInt((String)p.getCodec().readValue(p, String.class), 16), true);
        }

        private ColorDeserializer() {
        }
    }

    private static final class ColorSerializer
    extends JsonSerializer<Color> {
        public void serialize(Color value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(Integer.toHexString(value.getRGB()));
        }

        private ColorSerializer() {
        }
    }

    private static final class CustomCharacterEscapes
    extends CharacterEscapes {
        private final int[] asciiEscapes = CharacterEscapes.standardAsciiEscapesForJSON();

        private CustomCharacterEscapes() {
            this.asciiEscapes[34] = 0;
        }

        public int[] getEscapeCodesForAscii() {
            return (int[])this.asciiEscapes.clone();
        }

        @Nullable
        public SerializableString getEscapeSequence(int ch) {
            return null;
        }
    }
}

