/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.misc;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class Version
implements Comparable<Version> {
    @NotNull
    private final List<String> buildMeta;
    private final int major;
    private final int minor;
    private final int patch;
    @NotNull
    private final List<String> preRelease;

    @NotNull
    public static Version of(int major, int minor, int patch, @NotNull List<String> buildMeta, @NotNull List<String> preRelease) {
        return new Version(buildMeta, major, minor, patch, preRelease);
    }

    @NotNull
    public static Version of(int major, int minor, int patch) {
        return Version.of(major, minor, patch, Collections.emptyList(), Collections.emptyList());
    }

    @NotNull
    public static Version of(int major, int minor) {
        return Version.of(major, minor, 0);
    }

    @NotNull
    public static Version of(int major) {
        return Version.of(major, 0);
    }

    @NotNull
    public static Version of() {
        return Version.of(0);
    }

    @NotNull
    public static Version of(@NotNull String versionString) throws ParseException {
        return new Parser(versionString).parse();
    }

    @Override
    public int compareTo(@NotNull Version o) {
        int result = this.major - o.major;
        if (result != 0) {
            return result;
        }
        result = this.minor - o.minor;
        if (result != 0) {
            return result;
        }
        result = this.patch - o.patch;
        if (result != 0) {
            return result;
        }
        int thisPreReleaseSize = this.preRelease.size();
        int oPreReleaseSize = o.preRelease.size();
        if (thisPreReleaseSize == 0 && oPreReleaseSize > 0) {
            result = 1;
        }
        if (oPreReleaseSize == 0 && thisPreReleaseSize > 0) {
            result = -1;
        }
        if (thisPreReleaseSize <= 0 || oPreReleaseSize <= 0) {
            return result;
        }
        int len = Math.min(thisPreReleaseSize, oPreReleaseSize);
        int count = 0;
        for (count = 0; count < len && (result = this.comparePreReleaseTag(count, o)) == 0; ++count) {
        }
        if (result == 0 && count == len) {
            result = thisPreReleaseSize - oPreReleaseSize;
        }
        return result;
    }

    public boolean hasBuildMeta(@NotNull String tag) {
        return this.buildMeta.contains(tag);
    }

    public boolean hasPreRelease(@NotNull String tag) {
        return this.preRelease.contains(tag);
    }

    public boolean isCompatibleUpdateFor(@NotNull Version version) {
        return this.isUpdateFor(version) && this.major == version.major && this.major != 0;
    }

    public boolean isStable() {
        return this.major > 0 && this.preRelease.size() == 0;
    }

    public boolean isUpdateFor(@NotNull Version version) {
        return this.compareTo(version) > 0;
    }

    @NotNull
    public String toString() {
        int buildMetaSize;
        StringBuilder builder = new StringBuilder().append(this.major).append('.').append(this.minor).append('.').append(this.patch);
        int preReleaseSize = this.preRelease.size();
        if (preReleaseSize > 0) {
            builder.append('-');
            for (int index = 0; index < preReleaseSize; ++index) {
                builder.append(this.preRelease.get(index));
                if (index >= preReleaseSize - 1) continue;
                builder.append('.');
            }
        }
        if ((buildMetaSize = this.buildMeta.size()) > 0) {
            builder.append('+');
            for (int index = 0; index < buildMetaSize; ++index) {
                builder.append(this.buildMeta.get(index));
                if (index >= buildMetaSize - 1) continue;
                builder.append('.');
            }
        }
        return builder.toString();
    }

    private int comparePreReleaseTag(int position, @NotNull Version comparing) {
        Integer here = null;
        Integer there = null;
        String thisPreRelease = this.preRelease.get(position);
        String comparingPreRelease = comparing.preRelease.get(position);
        try {
            here = Integer.parseInt(thisPreRelease, 10);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            there = Integer.parseInt(comparingPreRelease, 10);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (here != null && there == null) {
            return -1;
        }
        if (here == null && there != null) {
            return 1;
        }
        if (here == null) {
            return thisPreRelease.compareTo(comparingPreRelease);
        }
        return here.compareTo(there);
    }

    @NotNull
    public List<String> buildMeta() {
        return this.buildMeta;
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int patch() {
        return this.patch;
    }

    @NotNull
    public List<String> preRelease() {
        return this.preRelease;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version other = (Version)o;
        if (this.major() != other.major()) {
            return false;
        }
        if (this.minor() != other.minor()) {
            return false;
        }
        if (this.patch() != other.patch()) {
            return false;
        }
        List<String> this$buildMeta = this.buildMeta();
        List<String> other$buildMeta = other.buildMeta();
        if (this$buildMeta == null ? other$buildMeta != null : !((Object)this$buildMeta).equals(other$buildMeta)) {
            return false;
        }
        List<String> this$preRelease = this.preRelease();
        List<String> other$preRelease = other.preRelease();
        return !(this$preRelease == null ? other$preRelease != null : !((Object)this$preRelease).equals(other$preRelease));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.major();
        result = result * 59 + this.minor();
        result = result * 59 + this.patch();
        List<String> $buildMeta = this.buildMeta();
        result = result * 59 + ($buildMeta == null ? 43 : ((Object)$buildMeta).hashCode());
        List<String> $preRelease = this.preRelease();
        result = result * 59 + ($preRelease == null ? 43 : ((Object)$preRelease).hashCode());
        return result;
    }

    private Version(@NotNull List<String> buildMeta, int major, int minor, int patch, @NotNull List<String> preRelease) {
        if (buildMeta == null) {
            throw new NullPointerException("buildMeta is marked non-null but is null");
        }
        if (preRelease == null) {
            throw new NullPointerException("preRelease is marked non-null but is null");
        }
        this.buildMeta = buildMeta;
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.preRelease = preRelease;
    }

    private static final class Parser {
        private final char[] input;
        @NotNull
        private final List<String> metaParts;
        @NotNull
        private final List<String> preReleaseParts;
        private final int[] versionParts;
        @NotNull
        private final String versionString;
        private int errorPosition;

        private Parser(@NotNull String versionString) {
            this.versionString = versionString;
            this.input = this.versionString.toCharArray();
            this.metaParts = new ArrayList<String>(5);
            this.preReleaseParts = new ArrayList<String>(5);
            this.versionParts = new int[3];
        }

        @NotNull
        private Version parse() throws ParseException {
            if (!this.stateMajor()) {
                throw new ParseException(this.versionString, this.errorPosition);
            }
            return Version.of(this.versionParts[0], this.versionParts[1], this.versionParts[2], this.preReleaseParts, this.metaParts);
        }

        private boolean stateMajor() {
            int pos;
            for (pos = 0; pos < this.input.length && this.input[pos] >= '0' && this.input[pos] <= '9'; ++pos) {
            }
            if (pos == 0) {
                return false;
            }
            if (this.input[0] == '0' && pos > 1) {
                return false;
            }
            this.versionParts[0] = Integer.parseInt(new String(this.input, 0, pos), 10);
            if (this.input[pos] == '.') {
                return this.stateMinor(pos + 1);
            }
            return false;
        }

        private boolean stateMeta(int index) {
            int pos;
            for (pos = index; pos < this.input.length && (this.input[pos] >= '0' && this.input[pos] <= '9' || this.input[pos] >= 'a' && this.input[pos] <= 'z' || this.input[pos] >= 'A' && this.input[pos] <= 'Z' || this.input[pos] == '-'); ++pos) {
            }
            if (pos == index) {
                this.errorPosition = index;
                return false;
            }
            this.metaParts.add(new String(this.input, index, pos - index));
            if (pos == this.input.length) {
                return true;
            }
            if (this.input[pos] == '.') {
                return this.stateMeta(pos + 1);
            }
            this.errorPosition = pos;
            return false;
        }

        private boolean stateMinor(int index) {
            int pos;
            for (pos = index; pos < this.input.length && this.input[pos] >= '0' && this.input[pos] <= '9'; ++pos) {
            }
            if (pos == index) {
                this.errorPosition = index;
                return false;
            }
            if (this.input[0] == '0' && pos - index > 1) {
                this.errorPosition = index;
                return false;
            }
            this.versionParts[1] = Integer.parseInt(new String(this.input, index, pos - index), 10);
            if (this.input[pos] == '.') {
                return this.statePatch(pos + 1);
            }
            this.errorPosition = pos;
            return false;
        }

        private boolean statePatch(int index) {
            int pos;
            for (pos = index; pos < this.input.length && this.input[pos] >= '0' && this.input[pos] <= '9'; ++pos) {
            }
            if (pos == index) {
                this.errorPosition = index;
                return false;
            }
            if (this.input[0] == '0' && pos - index > 1) {
                this.errorPosition = index;
                return false;
            }
            this.versionParts[2] = Integer.parseInt(new String(this.input, index, pos - index), 10);
            if (pos == this.input.length) {
                return true;
            }
            if (this.input[pos] == '+') {
                return this.stateMeta(pos + 1);
            }
            if (this.input[pos] == '-') {
                return this.stateRelease(pos + 1);
            }
            this.errorPosition = pos;
            return false;
        }

        private boolean stateRelease(int index) {
            int pos;
            for (pos = index; pos < this.input.length && (this.input[pos] >= '0' && this.input[pos] <= '9' || this.input[pos] >= 'a' && this.input[pos] <= 'z' || this.input[pos] >= 'A' && this.input[pos] <= 'Z' || this.input[pos] == '-'); ++pos) {
            }
            if (pos == index) {
                this.errorPosition = index;
                return false;
            }
            this.preReleaseParts.add(new String(this.input, index, pos - index));
            if (pos == this.input.length) {
                return true;
            }
            if (this.input[pos] == '.') {
                return this.stateRelease(pos + 1);
            }
            if (this.input[pos] == '+') {
                return this.stateMeta(pos + 1);
            }
            this.errorPosition = pos;
            return false;
        }
    }
}

