/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.functions;

import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.functions.FailedConsumer;
import tr.com.infumia.infumialib.functions.FailedFunction;
import tr.com.infumia.infumialib.functions.FailedPredicate;
import tr.com.infumia.infumialib.functions.FailedRunnable;
import tr.com.infumia.infumialib.functions.FailedSupplier;
import tr.com.infumia.infumialib.functions.UncheckedMultiOptional;

public final class UncheckedOptional<X> {
    @NotNull
    private final FailedSupplier<X> supplier;

    @NotNull
    public static <X> UncheckedOptional<X> empty() {
        return UncheckedOptional.of(() -> null);
    }

    @NotNull
    public static <X> UncheckedOptional<X> of(@NotNull FailedSupplier<X> supplier) {
        return new UncheckedOptional<X>(supplier);
    }

    @NotNull
    public UncheckedOptional<X> empty(@NotNull FailedRunnable runnable) {
        try {
            X x = this.supplier.get();
            if (x == null) {
                runnable.run();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    @NotNull
    public UncheckedOptional<X> filter(@NotNull FailedPredicate<X> predicate) {
        try {
            X x = this.supplier.get();
            if (x != null && predicate.test(x)) {
                return this;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return UncheckedOptional.empty();
    }

    @NotNull
    public <Y> UncheckedOptional<Y> map(@NotNull FailedFunction<X, Y> function) {
        try {
            Object x = this.supplier.get();
            if (x != null) {
                return UncheckedOptional.of(() -> function.apply(x));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return UncheckedOptional.empty();
    }

    @NotNull
    public <Y> UncheckedMultiOptional<X, Y> multiMap(@NotNull FailedFunction<X, Y> function) {
        return UncheckedMultiOptional.of(this.supplier, function);
    }

    @NotNull
    public UncheckedOptional<X> present(@NotNull FailedConsumer<X> consumer) {
        try {
            X x = this.supplier.get();
            if (x != null) {
                consumer.accept(x);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    private UncheckedOptional(@NotNull FailedSupplier<X> supplier) {
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        this.supplier = supplier;
    }
}

