/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.redis;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.kubernetes.Kubernetes;

public final class Redis {
    public static final byte[] ANY_TOPIC = "*".getBytes(StandardCharsets.UTF_8);
    public static final byte[] GAMEPLAY_TOPIC = "gameplay".getBytes(StandardCharsets.UTF_8);
    public static final byte[] LOBBY_TOPIC = "lobby".getBytes(StandardCharsets.UTF_8);
    public static final byte[] PROXY_TOPIC = "proxy".getBytes(StandardCharsets.UTF_8);
    @Nullable
    private static RedisClient client;

    @NotNull
    public static RedisClient get() {
        return Objects.requireNonNull(client, "init redis first!");
    }

    public static void init(@NotNull String masterName, @NotNull String password) {
        ServiceSpec sentinelService = ((Service)((ServiceResource)((NonNamespaceOperation)Kubernetes.get().services().inNamespace("redis")).withName("sentinel")).get()).getSpec();
        Integer sentinelPort = ((ServicePort)sentinelService.getPorts().get(0)).getPort();
        client = RedisClient.create((RedisURI)RedisURI.Builder.sentinel((String)sentinelService.getClusterIP(), (int)sentinelPort, (String)masterName).withPassword(password.toCharArray()).build());
    }

    private Redis() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

