/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.misc;

import java.util.Locale;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public interface Times {
    public static final long ONE_YEAR = 31104000L;
    public static final long ONE_MONTH = 2592000L;
    public static final long ONE_DAY = 86400L;
    public static final long ONE_HOUR = 3600L;
    public static final long ONE_MINUTE = 60L;
    public static final long ONE_SECOND = 1L;
    public static final Pattern TIME_FORMAT = Pattern.compile("(?i)(\\s|,|and)");
    public static final Pattern TIME_FORMAT_2 = Pattern.compile("(?is)(-?\\d+|[a-z]+)");

    public static long parse(@NotNull String textTime) {
        String time = TIME_FORMAT_2.matcher(TIME_FORMAT.matcher(textTime).replaceAll("")).replaceAll("$1 ").trim();
        String[] values = time.split("\\s+");
        long seconds = 0L;
        try {
            for (int sum = 0; sum < values.length; sum += 2) {
                long num = Long.parseLong(values[sum]);
                if (values[sum + 1].toLowerCase(Locale.ROOT).startsWith("m")) {
                    num *= 60L;
                } else if (values[sum + 1].toLowerCase(Locale.ROOT).startsWith("h")) {
                    num *= 3600L;
                } else if (values[sum + 1].toLowerCase(Locale.ROOT).startsWith("d")) {
                    num *= 86400L;
                }
                seconds += num;
            }
        }
        catch (Exception ex) {
            return 0L;
        }
        return seconds;
    }

    public static long[] timeRemaining(long remaining) {
        long tempRemaining = remaining;
        long year = tempRemaining / 31104000L;
        long month = (tempRemaining %= 31104000L) / 2592000L;
        long day = (tempRemaining %= 2592000L) / 86400L;
        long hour = (tempRemaining %= 86400L) / 3600L;
        long minute = (tempRemaining %= 3600L) / 60L;
        long second = (tempRemaining %= 60L) / 1L;
        long[] result = new long[]{year, month, day, hour, minute, second};
        return result;
    }
}

