/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.misc;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentBuilder;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.NotNull;
import org.kohsuke.github.GitHub;
import org.slf4j.Logger;

public interface GitHubUpdateChecker {
    public static final String SNAPSHOT = "-SNAPSHOT";

    public static void checkForUpdate(@NotNull Audience sender, @NotNull Logger logger, @NotNull String pluginVersion, @NotNull String pluginName, @NotNull String organizationName, @NotNull String repositoryName) {
        if (pluginVersion.contains(SNAPSHOT)) {
            sender.sendMessage(((TextComponent)((TextComponent)Component.text((String)"You are using snapshot version of ").color((TextColor)NamedTextColor.YELLOW)).append((Component)Component.text((String)pluginName))).append(Component.text((String)". We don't check updates for snapshot versions!").color((TextColor)NamedTextColor.YELLOW)));
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                String version = GitHub.connectAnonymously().getOrganization(organizationName).getRepository(repositoryName).getLatestRelease().getTagName();
                if (!version.equals(pluginVersion)) {
                    sender.sendMessage((Component)GitHubUpdateChecker.createUpdateMessage0(pluginName, pluginVersion, version));
                    sender.sendMessage((Component)GitHubUpdateChecker.createUpdateMessage1(organizationName, repositoryName));
                }
            }
            catch (IOException e) {
                logger.warn("Something went wrong when connecting to GitHub.", (Throwable)e);
            }
        });
    }

    @NotNull
    private static TextComponent createUpdateMessage0(@NotNull String pluginName, @NotNull String oldVersion, @NotNull String newVersion) {
        return (TextComponent)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Component.text((String)"Update available for ").color((TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)pluginName))).append((Component)Component.text((String)"(v"))).append((Component)Component.text((String)oldVersion))).append((Component)Component.text((String)")"))).append(Component.text((String)" download the newest version(v").color((TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)newVersion))).append(Component.text((String)") here:").color((TextColor)NamedTextColor.YELLOW))).build();
    }

    @NotNull
    private static TextComponent createUpdateMessage1(@NotNull String organizationName, @NotNull String repositoryName) {
        return (TextComponent)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Component.text((String)"https://github.com/").color((TextColor)NamedTextColor.GOLD))).append(Component.text((String)organizationName).color((TextColor)NamedTextColor.GOLD))).append(Component.text((String)"/").color((TextColor)NamedTextColor.GOLD))).append(Component.text((String)repositoryName).color((TextColor)NamedTextColor.GOLD))).append(Component.text((String)"/releases/latest/").color((TextColor)NamedTextColor.GOLD))).append((ComponentBuilder)Component.text())).build();
    }
}

