/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.files;

import java.nio.file.Path;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Comment;
import org.spongepowered.configurate.objectmapping.meta.Setting;
import tr.com.infumia.infumialib.configurate.InfumiaCollection;

@ConfigSerializable
public final class InfumiaConfig {
    @NotNull
    private static InfumiaConfig INSTANCE = new InfumiaConfig();
    @Setting
    @Comment(value="Checks update for the Infumia library plugin.")
    private boolean checkForUpdate = true;
    @Setting
    @Comment(value="The http api's endpoint address.")
    private String endpoint = "api.infumia.net";
    @Setting
    @Comment(value="Whether enable multiple server support or not.")
    private boolean multiServer = false;
    @Setting
    @Comment(value="Redis configurations")
    private Redis redis = new Redis();
    @Setting
    @Comment(value="Server's group.")
    private String serverGroup = "base";
    @Setting
    @Comment(value="Server's name.")
    private String serverName = UUID.randomUUID().toString();

    public static void init(@NotNull Path directory) throws ConfigurateException {
        HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(directory.resolve("config.conf"))).defaultOptions(options -> options.implicitInitialization(false).serializers(builder -> builder.registerAll(InfumiaCollection.COLLECTION)))).build();
        CommentedConfigurationNode node = (CommentedConfigurationNode)loader.load();
        INSTANCE = (InfumiaConfig)node.get(InfumiaConfig.class, (Object)new InfumiaConfig());
        node.set(InfumiaConfig.class, (Object)INSTANCE);
        loader.save((ConfigurationNode)node);
    }

    @NotNull
    public static InfumiaConfig instance() {
        return INSTANCE;
    }

    public boolean checkForUpdate() {
        return this.checkForUpdate;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public boolean multiServer() {
        return this.multiServer;
    }

    public Redis redis() {
        return this.redis;
    }

    public String serverGroup() {
        return this.serverGroup;
    }

    public String serverName() {
        return this.serverName;
    }

    public InfumiaConfig checkForUpdate(boolean checkForUpdate) {
        this.checkForUpdate = checkForUpdate;
        return this;
    }

    public InfumiaConfig endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public InfumiaConfig multiServer(boolean multiServer) {
        this.multiServer = multiServer;
        return this;
    }

    public InfumiaConfig redis(Redis redis) {
        this.redis = redis;
        return this;
    }

    public InfumiaConfig serverGroup(String serverGroup) {
        this.serverGroup = serverGroup;
        return this;
    }

    public InfumiaConfig serverName(String serverName) {
        this.serverName = serverName;
        return this;
    }

    @ConfigSerializable
    public static final class Redis {
        @Setting
        @Comment(value="Master name of redis.")
        private String masterName = "mymaster";
        @Setting
        @Comment(value="Password of redis.")
        private String password = "password";

        public String masterName() {
            return this.masterName;
        }

        public String password() {
            return this.password;
        }

        public Redis masterName(String masterName) {
            this.masterName = masterName;
            return this;
        }

        public Redis password(String password) {
            this.password = password;
            return this;
        }
    }
}

