/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.slimjar.resolver.data;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import tr.com.infumia.infumialib.slimjar.resolver.data.Dependency;
import tr.com.infumia.infumialib.slimjar.resolver.data.Mirror;
import tr.com.infumia.infumialib.slimjar.resolver.data.Repository;

public final class DependencyData {
    private final Collection<Dependency> dependencies;
    private final Collection<Mirror> mirrors;
    private final Collection<Repository> repositories;

    public DependencyData(Collection<Mirror> mirrors, Collection<Repository> repositories, Collection<Dependency> dependencies) {
        this.mirrors = Collections.unmodifiableCollection(mirrors);
        this.repositories = Collections.unmodifiableCollection(repositories);
        this.dependencies = Collections.unmodifiableCollection(dependencies);
    }

    public Collection<Dependency> getDependencies() {
        return this.dependencies;
    }

    public Collection<Mirror> getMirrors() {
        return this.mirrors;
    }

    public Collection<Repository> getRepositories() {
        return this.repositories;
    }

    public int hashCode() {
        return Objects.hash(this.repositories, this.dependencies);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DependencyData that = (DependencyData)o;
        return this.isCollectionEqual(this.repositories, that.repositories) && this.isCollectionEqual(this.dependencies, that.dependencies);
    }

    public String toString() {
        return "DependencyData{mirrors=" + this.mirrors + ", repositories=" + this.repositories + ", dependencies=" + this.dependencies + "}";
    }

    private <T> boolean isCollectionEqual(Collection<T> a, Collection<T> b) {
        return a.containsAll(b) && b.containsAll(a);
    }
}

