/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.slimjar.injector.agent;

import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashSet;
import java.util.UUID;
import tr.com.infumia.infumialib.slimjar.app.builder.ApplicationBuilder;
import tr.com.infumia.infumialib.slimjar.app.module.ModuleExtractor;
import tr.com.infumia.infumialib.slimjar.app.module.TemporaryModuleExtractor;
import tr.com.infumia.infumialib.slimjar.injector.agent.InstrumentationFactory;
import tr.com.infumia.infumialib.slimjar.injector.loader.InstrumentationInjectable;
import tr.com.infumia.infumialib.slimjar.injector.loader.IsolatedInjectableClassLoader;
import tr.com.infumia.infumialib.slimjar.injector.loader.manifest.JarManifestGenerator;
import tr.com.infumia.infumialib.slimjar.relocation.JarFileRelocator;
import tr.com.infumia.infumialib.slimjar.relocation.PassthroughRelocator;
import tr.com.infumia.infumialib.slimjar.relocation.RelocationRule;
import tr.com.infumia.infumialib.slimjar.relocation.facade.JarRelocatorFacadeFactory;
import tr.com.infumia.infumialib.slimjar.resolver.data.Dependency;
import tr.com.infumia.infumialib.slimjar.resolver.data.DependencyData;
import tr.com.infumia.infumialib.slimjar.resolver.data.Repository;
import tr.com.infumia.infumialib.slimjar.util.Packages;

public final class ByteBuddyInstrumentationFactory
implements InstrumentationFactory {
    public static final String AGENT_JAR = "loader-agent.isolated-jar";
    private static final String AGENT_CLASS = "ClassLoaderAgent";
    private static final String AGENT_PACKAGE = "io#github#slimjar#injector#agent";
    private static final String BYTE_BUDDY_AGENT_CLASS = "net#bytebuddy#agent#ByteBuddyAgent";
    private final URL agentJarUrl;
    private final ModuleExtractor extractor;
    private final JarRelocatorFacadeFactory relocatorFacadeFactory;

    public ByteBuddyInstrumentationFactory(JarRelocatorFacadeFactory relocatorFacadeFactory) throws ReflectiveOperationException, NoSuchAlgorithmException, IOException, URISyntaxException {
        this.relocatorFacadeFactory = relocatorFacadeFactory;
        this.agentJarUrl = InstrumentationInjectable.class.getClassLoader().getResource(AGENT_JAR);
        this.extractor = new TemporaryModuleExtractor();
    }

    public ByteBuddyInstrumentationFactory(URL agentJarUrl, ModuleExtractor extractor, JarRelocatorFacadeFactory relocatorFacadeFactory) {
        this.agentJarUrl = agentJarUrl;
        this.extractor = extractor;
        this.relocatorFacadeFactory = relocatorFacadeFactory;
    }

    private static String generatePattern() {
        return String.format("slimjar.%s", UUID.randomUUID());
    }

    private static DependencyData getDependency() throws MalformedURLException {
        Dependency byteBuddy = new Dependency("net.bytebuddy", "byte-buddy-agent", "1.11.0", null, new HashSet<Dependency>());
        Repository centralRepository = new Repository(new URL("https://repo.maven.apache.org/maven2/"));
        return new DependencyData(Collections.emptySet(), Collections.singleton(centralRepository), Collections.singleton(byteBuddy));
    }

    @Override
    public Instrumentation create() throws IOException, ReflectiveOperationException, URISyntaxException, NoSuchAlgorithmException {
        URL extractedURL = this.extractor.extractModule(this.agentJarUrl, "loader-agent");
        String pattern = ByteBuddyInstrumentationFactory.generatePattern();
        String relocatedAgentClass = String.format("%s.%s", pattern, AGENT_CLASS);
        RelocationRule relocationRule = new RelocationRule(Packages.fix(AGENT_PACKAGE), pattern, Collections.emptySet(), Collections.emptySet());
        JarFileRelocator relocator = new JarFileRelocator(Collections.singleton(relocationRule), this.relocatorFacadeFactory);
        File inputFile = new File(extractedURL.toURI());
        File relocatedFile = File.createTempFile("slimjar-agent", ".jar");
        IsolatedInjectableClassLoader classLoader = new IsolatedInjectableClassLoader();
        relocator.relocate(inputFile, relocatedFile);
        JarManifestGenerator.with(relocatedFile.toURI()).attribute("Manifest-Version", "1.0").attribute("Agent-Class", relocatedAgentClass).generate();
        ApplicationBuilder.injecting("SlimJar-Agent", classLoader).dataProviderFactory(dataUrl -> ByteBuddyInstrumentationFactory::getDependency).relocatorFactory(rules -> new PassthroughRelocator()).relocationHelperFactory(rel -> (dependency, file) -> file).build();
        Class<?> byteBuddyAgentClass = Class.forName(Packages.fix(BYTE_BUDDY_AGENT_CLASS), true, classLoader);
        Method attachMethod = byteBuddyAgentClass.getMethod("attach", File.class, String.class, String.class);
        Class<?> processHandle = Class.forName("java.lang.ProcessHandle");
        Method currentMethod = processHandle.getMethod("current", new Class[0]);
        Method pidMethod = processHandle.getMethod("pid", new Class[0]);
        Object currentProcess = currentMethod.invoke(processHandle, new Object[0]);
        Long processId = (Long)pidMethod.invoke(currentProcess, new Object[0]);
        attachMethod.invoke(null, relocatedFile, String.valueOf(processId), "");
        Class<?> agentClass = Class.forName(relocatedAgentClass, true, ClassLoader.getSystemClassLoader());
        Method instrMethod = agentClass.getMethod("getInstrumentation", new Class[0]);
        return (Instrumentation)instrMethod.invoke(null, new Object[0]);
    }
}

