/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.misc;

import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.account.AccountStore;

public interface Definitions {

    public static interface WildcardClassType {
        @NotNull
        public Class<?> classType();
    }

    public static interface UniqueIdText {
        @NotNull
        default public UUID parsedUniqueId() {
            return UUID.fromString(this.uniqueId());
        }

        @NotNull
        public String uniqueId();
    }

    public static interface UniqueId {
        @NotNull
        public UUID uniqueId();

        @NotNull
        default public String uniqueIdAsString() {
            return this.uniqueId().toString();
        }
    }

    public static interface Type {
        @NotNull
        public String type();
    }

    public static interface Serializer<R, F> {
        @NotNull
        public Optional<F> deserialize(@NotNull R var1);

        @NotNull
        default public Optional<F> deserialize(@NotNull R data, @Nullable F template) {
            return this.deserialize(data);
        }

        @NotNull
        public Optional<R> serialize(@NotNull F var1);
    }

    public static interface Self<S extends Self<S>> {
        @NotNull
        public S self();
    }

    public static interface Name {
        @NotNull
        public String name();

        @NotNull
        default public String nameAsLowerCase() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @NotNull
        default public String nameAsUpperCase() {
            return this.name().toUpperCase(Locale.ROOT);
        }
    }

    public static interface LongKey {
        public long key();
    }

    public static interface Key<K> {
        @NotNull
        public K key();
    }

    public static interface IntKey {
        public int key();
    }

    public static interface Id {
        @NotNull
        public String id();
    }

    public static interface Encoded {
        @NotNull
        public String encoded();
    }

    public static interface ClassType<T> {
        @NotNull
        public Class<T> classType();
    }

    public static interface BytesSerializer<T>
    extends Serializer<byte[], T> {
    }

    public static interface Address {
        @NotNull
        public String address();
    }

    public static interface AccountStoreHolder {
        @NotNull
        public AccountStore accountStore();
    }
}

