/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.log;

import com.google.common.collect.Queues;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.proto.Log;
import tr.com.infumia.infumialib.proto.LogType;

public final class LogService {
    private final Queue<Log> logs = Queues.newArrayDeque();
    @NotNull
    private final String serverName;

    public void log(@NotNull LogType type, @NotNull String by, @NotNull String message) {
        this.logs.add(Log.newBuilder().setServer(this.serverName).setBy(by).setType(type).setMessage(message).setTime(System.currentTimeMillis()).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push() {
        Queue<Log> queue = this.logs;
        synchronized (queue) {
        }
    }

    public LogService(@NotNull String serverName) {
        if (serverName == null) {
            throw new NullPointerException("serverName is marked non-null but is null");
        }
        this.serverName = serverName;
    }
}

