/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.account;

import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.misc.Definitions;
import tr.com.infumia.infumialib.misc.LoginChain;

public interface Account
extends Definitions.Name,
Definitions.UniqueIdText,
Definitions.Key<String> {
    @NotNull
    public static Account create(@NotNull LoginChain chain) {
        return Account.create(chain.name(), chain.uniqueId());
    }

    @NotNull
    public static Account create(@NotNull String name, @NotNull String uniqueId) {
        return new Impl(name, uniqueId);
    }

    @Override
    @NotNull
    default public String key() {
        return this.uniqueId();
    }

    public static final class Impl
    implements Account {
        @NotNull
        private final String name;
        @NotNull
        private final String uniqueId;

        private Impl(@NotNull String name, @NotNull String uniqueId) {
            this.name = name;
            this.uniqueId = uniqueId;
        }

        @Override
        @NotNull
        public String name() {
            return this.name;
        }

        @Override
        @NotNull
        public String uniqueId() {
            return this.uniqueId;
        }
    }
}

