/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.log;

import java.util.ArrayDeque;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.messaging.NoopObserver;
import tr.com.infumia.infumialib.proto.Definition;
import tr.com.infumia.infumialib.proto.LoggerGrpc;

public final class LogService {
    private final Queue<Definition.Log> logs = new ArrayDeque<Definition.Log>();
    @NotNull
    private final String serverName;
    @NotNull
    private final LoggerGrpc.LoggerStub stub;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(@NotNull Definition.LogType type, @NotNull String by, @NotNull String message) {
        Queue<Definition.Log> queue = this.logs;
        synchronized (queue) {
            this.logs.add(Definition.Log.newBuilder().setServer(this.serverName).setBy(by).setType(type).setMessage(message).setTime(System.currentTimeMillis()).build());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push() {
        Queue<Definition.Log> queue = this.logs;
        synchronized (queue) {
            Definition.Log next;
            while ((next = this.logs.poll()) != null) {
                this.stub.log(next, NoopObserver.EMPTY);
            }
        }
    }

    public LogService(@NotNull String serverName, @NotNull LoggerGrpc.LoggerStub stub) {
        if (serverName == null) {
            throw new NullPointerException("serverName is marked non-null but is null");
        }
        if (stub == null) {
            throw new NullPointerException("stub is marked non-null but is null");
        }
        this.serverName = serverName;
        this.stub = stub;
    }
}

