/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.utils;

import java.util.HashMap;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;

public final class InventoryUtilities {
    public static boolean isInventoryFull(@NotNull Player player, @NotNull ItemStack item) {
        if (item.getType() == Material.AIR) {
            return false;
        }
        int itemAmount = item.getAmount();
        if (itemAmount > 5000) {
            return true;
        }
        PlayerInventory inventory = player.getInventory();
        int maxStackSize = item.getMaxStackSize();
        if (inventory.firstEmpty() >= 0 && itemAmount <= maxStackSize) {
            return false;
        }
        if (itemAmount > maxStackSize) {
            ItemStack clone = item.clone();
            clone.setAmount(maxStackSize);
            if (InventoryUtilities.isInventoryFull(player, clone)) {
                return true;
            }
            clone.setAmount(itemAmount - maxStackSize);
            return InventoryUtilities.isInventoryFull(player, clone);
        }
        HashMap all = inventory.all(item);
        int amount = itemAmount;
        for (ItemStack element : all.values()) {
            amount -= element.getMaxStackSize() - element.getAmount();
        }
        return amount > 0;
    }

    public static boolean isInventoryNotFull(@NotNull Player player, @NotNull ItemStack item) {
        return !InventoryUtilities.isInventoryFull(player, item);
    }

    private InventoryUtilities() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

