/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.itemstack;

import com.cryptomorin.xseries.XPotion;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.Color;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import tr.com.infumia.bukkitversion.BukkitVersion;
import tr.com.infumia.infumialib.platform.paper.itemstack.ItemStackBuilder;

public final class PotionItemBuilder
extends ItemStackBuilder<PotionMeta, PotionItemBuilder> {
    private PotionItemBuilder(@NotNull PotionMeta itemMeta, @NotNull ItemStack itemStack) {
        super(itemMeta, itemStack);
    }

    @NotNull
    public static PotionItemBuilder from(@NotNull PotionMeta itemMeta, @NotNull ItemStack itemStack) {
        return new PotionItemBuilder(itemMeta, itemStack);
    }

    @NotNull
    public PotionItemBuilder addCustomEffect(@NotNull PotionEffect effect, boolean overwrite) {
        if (BukkitVersion.MAJOR >= 9) {
            ((PotionMeta)this.itemMeta()).addCustomEffect(effect, overwrite);
        }
        return this.self();
    }

    @NotNull
    public PotionItemBuilder addCustomEffects(@NotNull Collection<String> effects, boolean overwrite) {
        if (BukkitVersion.MAJOR >= 9) {
            effects.stream().map(XPotion::parseEffect).filter(Objects::nonNull).forEach(effect -> this.addCustomEffect(effect.getEffect(), overwrite));
        }
        return this.self();
    }

    @NotNull
    public PotionItemBuilder basePotionData(@NotNull PotionData data) {
        if (BukkitVersion.MAJOR >= 9) {
            ((PotionMeta)this.itemMeta()).setBasePotionData(data);
        }
        return this.self();
    }

    @NotNull
    public PotionItemBuilder basePotionData(@NotNull String data) {
        PotionType type;
        if (BukkitVersion.MAJOR < 9) {
            return this.self();
        }
        if (data.isEmpty()) {
            return this.self();
        }
        String[] split = data.split(",");
        try {
            type = PotionType.valueOf((String)split[0].trim().toUpperCase(Locale.ROOT));
        }
        catch (Exception e) {
            type = PotionType.UNCRAFTABLE;
        }
        boolean extended = split.length != 1 && Boolean.parseBoolean(split[1].trim());
        boolean upgraded = split.length > 2 && Boolean.parseBoolean(split[2].trim());
        PotionData potionData = new PotionData(type, extended, upgraded);
        return this.basePotionData(potionData);
    }

    @NotNull
    public PotionItemBuilder basePotionData(@NotNull String data, int level) {
        PotionType type;
        if (BukkitVersion.MAJOR >= 9) {
            return this.basePotionData(data);
        }
        if (data.isEmpty()) {
            return this.self();
        }
        String[] split = data.split(",");
        try {
            type = PotionType.valueOf((String)split[0].trim().toUpperCase(Locale.ROOT));
        }
        catch (Exception e) {
            type = PotionType.SLOWNESS;
        }
        boolean extended = split.length != 1 && Boolean.parseBoolean(split[1].trim());
        boolean splash = split.length > 2 && Boolean.parseBoolean(split[2].trim());
        return (PotionItemBuilder)this.itemStack(new Potion(type, level, splash, extended).toItemStack(1));
    }

    @NotNull
    public PotionItemBuilder clearCustomEffects() {
        ((PotionMeta)this.itemMeta()).clearCustomEffects();
        return this.self();
    }

    @NotNull
    public PotionItemBuilder color(@Nullable Color color) {
        if (BukkitVersion.MAJOR >= 11) {
            ((PotionMeta)this.itemMeta()).setColor(color);
        }
        return this.self();
    }

    @NotNull
    public PotionItemBuilder color(int color) {
        return this.color(Color.fromRGB((int)color));
    }

    @Override
    public void deserialize(@NotNull ConfigurationNode node) throws SerializationException {
        super.deserialize(node);
        Optional.ofNullable(node.node(new Object[]{"base-effect"}).getString()).ifPresent(s -> this.basePotionData((String)s, node.node(new Object[]{"level"}).getInt(1)));
        if (node.hasChild(new Object[]{"color"})) {
            this.color(node.node(new Object[]{"color"}).getInt());
        }
        this.addCustomEffects(node.node(new Object[]{"custom-effects"}).getList(String.class, Collections.emptyList()), true);
    }

    @Override
    public void serialize(@NotNull ConfigurationNode node) throws SerializationException {
        super.serialize(node);
        ItemStack itemStack = this.itemStack(false);
        PotionMeta itemMeta = (PotionMeta)this.itemMeta();
        if (BukkitVersion.MAJOR >= 9) {
            List customEffects = itemMeta.getCustomEffects();
            List<String> effects = customEffects.stream().map(effect -> String.format("%s,%d,%d", effect.getType().getName(), effect.getDuration(), effect.getAmplifier())).toList();
            node.node(new Object[]{"custom-effects"}).setList(String.class, effects);
            PotionData potionData = itemMeta.getBasePotionData();
            node.node(new Object[]{"base-effect"}).set((Object)String.format("%s, %s, %s", potionData.getType().name(), potionData.isExtended(), potionData.isUpgraded()));
            if (BukkitVersion.MAJOR >= 11) {
                Color color = itemMeta.getColor();
                if (itemMeta.hasColor() && color != null) {
                    node.node(new Object[]{"color"}).set((Object)color.asRGB());
                }
            }
        } else if (itemStack.getDurability() != 0) {
            Potion potion = Potion.fromItemStack((ItemStack)itemStack);
            node.node(new Object[]{"level"}).set((Object)potion.getLevel());
            node.node(new Object[]{"base-effect"}).set((Object)String.format("%s, %s, %s", potion.getType().name(), potion.hasExtendedDuration(), potion.isSplash()));
        }
    }

    @Deprecated
    @NotNull
    public PotionItemBuilder mainEffect(@NotNull PotionEffectType type) {
        ((PotionMeta)this.itemMeta()).setMainEffect(type);
        return this.self();
    }

    @NotNull
    public PotionItemBuilder removeCustomEffect(@NotNull PotionEffectType type) {
        ((PotionMeta)this.itemMeta()).removeCustomEffect(type);
        return this.self();
    }

    @NotNull
    public PotionItemBuilder self() {
        return this;
    }
}

