/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.itemstack;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.DyeColor;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import tr.com.infumia.infumialib.platform.paper.itemstack.ItemStackBuilder;

public final class BannerItemBuilder
extends ItemStackBuilder<BannerMeta, BannerItemBuilder> {
    private BannerItemBuilder(@NotNull BannerMeta meta, @NotNull ItemStack itemStack) {
        super(meta, itemStack);
    }

    @NotNull
    public static BannerItemBuilder simple(@NotNull BannerMeta itemMeta, @NotNull ItemStack itemStack) {
        return new BannerItemBuilder(itemMeta, itemStack);
    }

    @NotNull
    public BannerItemBuilder addPatterns(Pattern ... patterns) {
        BannerMeta meta = (BannerMeta)this.itemMeta();
        Arrays.stream(patterns).forEach(arg_0 -> ((BannerMeta)meta).addPattern(arg_0));
        return this.self();
    }

    @Deprecated
    @NotNull
    public BannerItemBuilder baseColor(@NotNull DyeColor color) {
        ((BannerMeta)this.itemMeta()).setBaseColor(color);
        return this.self();
    }

    @Override
    public void deserialize(@NotNull ConfigurationNode node) throws SerializationException {
        super.deserialize(node);
        ConfigurationNode patternsNode = node.node(new Object[]{"patterns"});
        for (Map.Entry entry : patternsNode.childrenMap().entrySet()) {
            DyeColor color;
            String key = entry.getKey().toString();
            String value = ((ConfigurationNode)entry.getValue()).getString();
            if (value == null) continue;
            PatternType type = PatternType.getByIdentifier((String)key);
            if (type == null) {
                try {
                    type = PatternType.valueOf((String)key.toUpperCase(Locale.ENGLISH));
                }
                catch (Exception e) {
                    type = PatternType.BASE;
                }
            }
            try {
                color = DyeColor.valueOf((String)value.toUpperCase(Locale.ENGLISH));
            }
            catch (Exception e) {
                color = DyeColor.WHITE;
            }
            this.addPatterns(new Pattern(color, type));
        }
    }

    @Override
    public void serialize(@NotNull ConfigurationNode node) throws SerializationException {
        super.serialize(node);
        ConfigurationNode patternsNode = node.node(new Object[]{"patterns"});
        for (Pattern pattern : ((BannerMeta)this.itemMeta()).getPatterns()) {
            patternsNode.node(new Object[]{pattern.getPattern().name()}).set((Object)pattern.getColor().name());
        }
    }

    @NotNull
    public BannerItemBuilder pattern(int index, @NotNull Pattern pattern) {
        ((BannerMeta)this.itemMeta()).setPattern(index, pattern);
        return this.self();
    }

    @NotNull
    public BannerItemBuilder patterns(Pattern ... patterns) {
        return this.patterns(List.of(patterns));
    }

    @NotNull
    public BannerItemBuilder patterns(@NotNull List<Pattern> patterns) {
        ((BannerMeta)this.itemMeta()).setPatterns(patterns);
        return this.self();
    }

    @NotNull
    public BannerItemBuilder removePatterns(int ... index) {
        BannerMeta meta = (BannerMeta)this.itemMeta();
        Arrays.stream(index).forEach(arg_0 -> ((BannerMeta)meta).removePattern(arg_0));
        return this.self();
    }

    @NotNull
    public BannerItemBuilder self() {
        return this;
    }
}

