/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.color;

import java.awt.Color;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.bukkitversion.BukkitVersion;

public final class XColor {
    public static final XColor AQUA;
    public static final XColor BLACK;
    public static final XColor BLUE;
    public static final XColor BOLD;
    public static final XColor DARK_AQUA;
    public static final XColor DARK_BLUE;
    public static final XColor DARK_GRAY;
    public static final XColor DARK_GREEN;
    public static final XColor DARK_PURPLE;
    public static final XColor DARK_RED;
    public static final XColor GOLD;
    public static final XColor GRAY;
    public static final XColor GREEN;
    public static final XColor HEX;
    public static final XColor ITALIC;
    public static final XColor LIGHT_PURPLE;
    public static final XColor OBFUSCATED;
    public static final XColor RED;
    public static final XColor RESET;
    public static final XColor STRIKETHROUGH;
    public static final XColor UNDERLINE;
    public static final XColor WHITE;
    public static final XColor YELLOW;
    private static final Map<Character, XColor> BY_CHAR;
    private static final Map<String, XColor> BY_NAME;
    private static final Map<String, XColor> CUSTOM_BY_HEX;
    private static final Map<String, XColor> CUSTOM_BY_NAME;
    private static final TreeMap<String, XColor> CUSTOM_BY_RGB;
    private static final Pattern FORMAT;
    private static final Pattern GRADIENT;
    private static final Pattern HEX_COLOR_NAME;
    private static final Pattern HEX_COLOR_NAME_LAST;
    private static final Pattern HEX_COLOR_REGEX;
    private static final Pattern HEX_COLOR_REGEX_LAST;
    private static final Pattern HEX_DE_COLORIZE_NAME;
    private static final Random RANDOM;
    private static final AtomicBoolean kyoriEnabled;
    private final int blue;
    private final char ch;
    private final boolean color;
    private final int green;
    @Nullable
    private final String hexCode;
    @Nullable
    private final String name;
    @Nullable
    private final Pattern pattern;
    private final int red;
    private final boolean reset;

    public XColor(@Nullable String name, @NotNull String hexCode) {
        this.color = true;
        this.reset = false;
        this.name = name;
        this.pattern = null;
        this.ch = '\u0000';
        String tmpHexCode = hexCode.startsWith("#") ? hexCode.substring(1) : hexCode;
        int tempRed = -1;
        int tempGreen = -1;
        int tempBlue = -1;
        try {
            tempRed = Integer.valueOf(tmpHexCode.substring(0, 2), 16);
            tempGreen = Integer.valueOf(tmpHexCode.substring(2, 4), 16);
            tempBlue = Integer.parseInt(tmpHexCode.substring(4, 6), 16);
        }
        catch (Throwable e) {
            tmpHexCode = null;
        }
        this.hexCode = tmpHexCode;
        this.red = tempRed;
        this.green = tempGreen;
        this.blue = tempBlue;
    }

    public XColor(@NotNull String name, char ch, boolean color, boolean reset, int red, int green, int blue) {
        this.name = name;
        this.ch = ch;
        this.color = color;
        this.reset = reset;
        this.pattern = Pattern.compile("(?i)(&[" + ch + "])");
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.hexCode = null;
        if (BukkitVersion.MAJOR >= 16 || !name.equalsIgnoreCase("Hex")) {
            BY_CHAR.put(Character.valueOf(ch), this);
            BY_NAME.put(this.name.toLowerCase(Locale.ROOT).replace("_", ""), this);
        }
    }

    public XColor(@NotNull String hexCode) {
        this(null, hexCode);
    }

    public XColor(@NotNull String name, char ch, int red, int green, int blue) {
        this(name, ch, true, false, red, green, blue);
    }

    public XColor(@NotNull String name, char ch, boolean color) {
        this(name, ch, color, false);
    }

    public XColor(@NotNull String name, char ch, boolean color, boolean reset) {
        this(name, ch, color, reset, -1, -1, -1);
    }

    public static void addCustomColor(@NotNull String name, @NotNull String hexCode, @NotNull XColor color) {
        CUSTOM_BY_HEX.put(hexCode, color);
        CUSTOM_BY_NAME.put(name, color);
    }

    @NotNull
    public static List<String> colorize(@NotNull Collection<String> list) {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : list) {
            result.add(XColor.colorize(s));
        }
        return result;
    }

    @NotNull
    public static String colorize(@NotNull String text) {
        String replaced = XColor.gradient(text);
        if (!replaced.contains("{#")) {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)replaced);
        }
        Matcher match = HEX_COLOR_REGEX.matcher(replaced);
        while (match.find()) {
            char[] charArray;
            String string = match.group();
            StringBuilder builder = new StringBuilder("\u00a7x");
            for (char ch : charArray = string.substring(2, string.length() - 1).toCharArray()) {
                builder.append("\u00a7").append(ch);
                if (string.substring(2, string.length() - 1).length() != 3) continue;
                builder.append("\u00a7").append(ch);
            }
            replaced = replaced.replace(string, builder.toString());
        }
        match = HEX_COLOR_NAME.matcher(replaced);
        while (match.find()) {
            char[] charArray;
            String hexCode;
            String string2 = match.group(2);
            Optional<XColor> color = XColor.getByCustomName(string2.toLowerCase().replace("_", ""));
            if (color.isEmpty() || (hexCode = color.get().getHexCode()) == null) continue;
            StringBuilder builder = new StringBuilder("\u00a7x");
            for (char ch : charArray = hexCode.toCharArray()) {
                builder.append("\u00a7").append(ch);
            }
            replaced = replaced.replace(match.group(), builder.toString());
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)replaced);
    }

    @NotNull
    public static List<String> deColorize(@NotNull Collection<String> list) {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : list) {
            result.add(XColor.deColorize(s));
        }
        return result;
    }

    @NotNull
    public static String deColorize(@NotNull String text) {
        return XColor.deColorize(text, true);
    }

    @NotNull
    public static String deColorize(@NotNull String text, boolean colorizeBefore) {
        String replaced = text;
        if (colorizeBefore) {
            replaced = XColor.colorize(replaced);
        }
        if (!(replaced = replaced.replace("\u00a7", "&")).contains("&x")) {
            return replaced;
        }
        Matcher match = HEX_DE_COLORIZE_NAME.matcher(replaced);
        while (match.find()) {
            String reg = match.group(3).replace("&", "");
            XColor custom = CUSTOM_BY_HEX.get(reg.toLowerCase());
            if (custom != null && custom.getName() != null) {
                replaced = replaced.replace(match.group(), "{#" + custom.getName().toLowerCase(Locale.ROOT).replace("_", "") + "}");
                continue;
            }
            replaced = replaced.replace(match.group(), "{#" + reg + "}");
        }
        return replaced;
    }

    @NotNull
    public static String flatten(@NotNull String text) {
        return XColor.deColorize(text, true).replace("&", "\uff06").replace("{#", "{\uff06#");
    }

    @NotNull
    public static Optional<XColor> getByCustomName(@NotNull String name) {
        if (!name.equalsIgnoreCase("random")) {
            return Optional.ofNullable(CUSTOM_BY_NAME.get(name.toLowerCase().replace("_", "")));
        }
        ArrayList<XColor> valuesList = new ArrayList<XColor>(CUSTOM_BY_NAME.values());
        int randomIndex = RANDOM.nextInt(valuesList.size());
        return Optional.ofNullable(valuesList.get(randomIndex));
    }

    @NotNull
    public static Optional<XColor> getByHex(@NotNull String hexCode) {
        String replaced = hexCode;
        if (replaced.startsWith("{#")) {
            replaced = replaced.substring("{#".length());
        }
        if (replaced.endsWith("}")) {
            replaced = replaced.substring(0, replaced.length() - "}".length());
        }
        return Optional.ofNullable(CUSTOM_BY_HEX.get(replaced.toLowerCase().replace("_", "")));
    }

    @Nullable
    public static XColor getClosest(@NotNull String hexCode) {
        Color color1;
        XColor closest;
        String replaced = hexCode;
        if (replaced.startsWith("#")) {
            replaced = replaced.substring(1);
        }
        if ((closest = CUSTOM_BY_RGB.get(replaced)) != null) {
            return closest;
        }
        try {
            color1 = new Color(Integer.valueOf(replaced.substring(0, 2), 16), Integer.valueOf(replaced.substring(2, 4), 16), Integer.valueOf(replaced.substring(4, 6), 16));
        }
        catch (Throwable e) {
            return null;
        }
        double distance = Double.MAX_VALUE;
        for (Map.Entry<String, XColor> entry : CUSTOM_BY_HEX.entrySet()) {
            int blue;
            int green;
            int red;
            int red1;
            Color color2;
            int red2;
            int remaining;
            double dist;
            XColor value = entry.getValue();
            String colorHexCode = value.getHexCode();
            if (colorHexCode == null || !((dist = Math.sqrt(((512 + (remaining = (red2 = (color2 = new Color(Integer.valueOf(colorHexCode.substring(0, 2), 16), Integer.valueOf(colorHexCode.substring(2, 4), 16), Integer.valueOf(colorHexCode.substring(4, 6), 16))).getRed()) + (red1 = color1.getRed()) >> 1)) * (red = red2 - red1) * red >> 8) + 4 * (green = color2.getGreen() - color1.getGreen()) * green + ((767 - remaining) * (blue = color2.getBlue() - color1.getBlue()) * blue >> 8))) < distance)) continue;
            closest = value;
            distance = dist;
        }
        if (closest != null) {
            CUSTOM_BY_RGB.put(replaced, closest);
            return closest;
        }
        CUSTOM_BY_RGB.put(replaced, null);
        return null;
    }

    @NotNull
    public static Optional<XColor> getColor(@NotNull String text) {
        String replaced;
        Optional<XColor> color;
        String deColorized = XColor.deColorize(text);
        if (deColorized.contains("{#")) {
            Matcher match = HEX_COLOR_REGEX_LAST.matcher(deColorized);
            if (match.find()) {
                return Optional.of(new XColor(match.group(2)));
            }
            match = HEX_COLOR_NAME_LAST.matcher(deColorized);
            if (match.find()) {
                return Optional.of(new XColor(match.group(2)));
            }
        }
        if ((color = XColor.getXColor(replaced = XColor.deColorize(text).replace("&", ""))).isPresent()) {
            return color;
        }
        int length = deColorized.length();
        if (length <= 1 || !String.valueOf(deColorized.charAt(length - 2)).equalsIgnoreCase("&")) {
            return Optional.empty();
        }
        replaced = replaced.substring(replaced.length() - 1);
        for (Map.Entry<Character, XColor> one : BY_CHAR.entrySet()) {
            if (!String.valueOf(one.getKey()).equalsIgnoreCase(replaced)) continue;
            return Optional.ofNullable(one.getValue());
        }
        return Optional.empty();
    }

    @NotNull
    public static Optional<XColor> getFormat(@NotNull String text) {
        String replaced = text;
        String deColorized = XColor.deColorize(replaced);
        Optional<XColor> color = XColor.getXColor(replaced = replaced.replace("\u00a7", "&"));
        if (color.isEmpty()) {
            return color;
        }
        if (deColorized.length() <= 1 || !String.valueOf(deColorized.charAt(deColorized.length() - 2)).equalsIgnoreCase("&")) {
            return Optional.empty();
        }
        replaced = replaced.substring(replaced.length() - 1);
        for (Map.Entry<Character, XColor> entry : BY_CHAR.entrySet()) {
            if (!String.valueOf(entry.getKey()).equalsIgnoreCase(replaced)) continue;
            return entry.getValue().isFormat() ? Optional.of(entry.getValue()) : Optional.empty();
        }
        return Optional.empty();
    }

    @NotNull
    public static Collection<XColor> getFormats(@NotNull String text) {
        String replaced = text.replace("\u00a7", "&");
        HashSet<XColor> formats = new HashSet<XColor>();
        Matcher match = FORMAT.matcher(replaced);
        while (match.find()) {
            XColor.getFormat(match.group()).filter(XColor::isFormat).ifPresent(formats::add);
        }
        return formats;
    }

    @NotNull
    public static String getLastColors(@NotNull String text) {
        String replaced = XColor.deColorize(text);
        Matcher match = HEX_COLOR_REGEX_LAST.matcher(replaced);
        if (match.find()) {
            String colorByHex = match.group(0);
            if (replaced.endsWith(colorByHex)) {
                return colorByHex;
            }
            String[] split = replaced.split(XColor.escape(colorByHex), 2);
            String last = XColor.getLastColors(split[1]);
            return last.isEmpty() ? colorByHex : last;
        }
        match = HEX_COLOR_NAME_LAST.matcher(replaced);
        if (match.find()) {
            String colorByName = match.group();
            if (replaced.endsWith(colorByName)) {
                return colorByName;
            }
            String[] split = replaced.split(XColor.escape(colorByName), 2);
            String last = XColor.getLastColors(split[1]);
            return last.isEmpty() ? colorByName : last;
        }
        return ChatColor.getLastColors((String)XColor.colorize(replaced));
    }

    @NotNull
    public static XColor getRandomColor() {
        ArrayList<XColor> colors = new ArrayList<XColor>();
        for (XColor xColor : BY_NAME.values()) {
            if (!xColor.isColor()) continue;
            colors.add(xColor);
        }
        Collections.shuffle(colors);
        return (XColor)colors.get(0);
    }

    @NotNull
    public static String gradient(@NotNull String text) {
        String replaced = text;
        Matcher matcher = GRADIENT.matcher(replaced);
        while (matcher.find()) {
            String match = matcher.group();
            Optional<XColor> color1Optional = XColor.getColor("{#" + matcher.group(2).replace("#", "") + "}");
            Optional<XColor> color2Optional = XColor.getColor("{#" + matcher.group(5).replace("#", "") + "}");
            if (color1Optional.isEmpty() || color2Optional.isEmpty()) continue;
            XColor color1 = color1Optional.get();
            XColor color2 = color2Optional.get();
            String gradientText = matcher.group(3);
            boolean continuous = !matcher.group(6).isEmpty();
            StringBuilder builder = new StringBuilder();
            Collection<XColor> formats = XColor.getFormats(gradientText);
            gradientText = XColor.stripColor(gradientText);
            for (int i = 0; i < gradientText.length(); ++i) {
                char ch = gradientText.charAt(i);
                int length = gradientText.length();
                length = Math.max(length, 2);
                double percent = (double)i * 100.0 / (double)(length - 1);
                XColor mixedColor = color1.mixColors(color2, percent);
                builder.append("{#").append(mixedColor.getHexCode()).append("}");
                if (!formats.isEmpty()) {
                    for (XColor format : formats) {
                        builder.append("&").append(format.getChar());
                    }
                }
                builder.append(ch);
            }
            if (continuous) {
                builder.append("{#").append(matcher.group(5).replace("#", "")).append(">").append("}");
            }
            replaced = replaced.replace(match, builder.toString());
            if (!continuous) continue;
            replaced = XColor.gradient(replaced);
        }
        return replaced;
    }

    public static boolean isKyoriEnabled() {
        return kyoriEnabled.get();
    }

    public static void setKyoriEnabled(boolean status) {
        kyoriEnabled.set(status);
    }

    @NotNull
    public static XColor mixColors(@NotNull XColor color1, @NotNull XColor color2, double percent) {
        double finalPercent = percent / 100.0;
        double inversePercent = 1.0 - finalPercent;
        int redPart = (int)((double)color2.getRed() * finalPercent + (double)color1.getRed() * inversePercent);
        int greenPart = (int)((double)color2.getGreen() * finalPercent + (double)color1.getGreen() * inversePercent);
        int bluePart = (int)((double)color2.getBlue() * finalPercent + (double)color1.getBlue() * inversePercent);
        return new XColor(String.format("#%02x%02x%02x", redPart, greenPart, bluePart));
    }

    @NotNull
    public static String stripColor(@NotNull String text) {
        return ChatColor.stripColor((String)XColor.colorize(text));
    }

    @NotNull
    private static String escape(@NotNull String text) {
        return text.replace("#", "\\#").replace("{", "\\{").replace("}", "\\}");
    }

    @NotNull
    private static Optional<XColor> getXColor(@NotNull String text) {
        if (text.length() <= 1) {
            return Optional.empty();
        }
        String formatted = text.toLowerCase(Locale.ROOT).replace("_", "");
        XColor color = BY_NAME.get(formatted);
        if (color != null) {
            return Optional.of(color);
        }
        color = CUSTOM_BY_NAME.get(formatted);
        if (color != null) {
            return Optional.of(color);
        }
        return Optional.empty();
    }

    @NotNull
    public String getBukkitColorCode() {
        if (this.hexCode != null) {
            return XColor.colorize("{#" + this.hexCode + "}");
        }
        return "\u00a7" + this.getChar();
    }

    public char getChar() {
        return this.ch;
    }

    @Nullable
    public String getCleanName() {
        if (this.name == null) {
            return null;
        }
        return this.name.replace("_", "");
    }

    @Nullable
    public ChatColor getColor() {
        return ChatColor.getByChar((char)this.getChar());
    }

    @NotNull
    public String getColorCode() {
        if (this.hexCode != null) {
            return "{#" + this.hexCode + "}";
        }
        return "&" + this.ch;
    }

    @NotNull
    public String getFormattedHex() {
        return this.getFormattedHex("");
    }

    @NotNull
    public String getFormattedHex(@NotNull String suffix) {
        return "{#" + this.hexCode + suffix + "}";
    }

    @Nullable
    public org.bukkit.Color getRGBColor() {
        if (this.blue < 0) {
            return null;
        }
        return org.bukkit.Color.fromRGB((int)this.getRed(), (int)this.getGreen(), (int)this.getBlue());
    }

    public boolean isColor() {
        return this.color;
    }

    public boolean isFormat() {
        return !this.color && !this.reset;
    }

    @NotNull
    public XColor mixColors(@NotNull XColor color, double percent) {
        return XColor.mixColors(this, color, percent);
    }

    @NotNull
    public String toString() {
        return this.getBukkitColorCode();
    }

    public int getBlue() {
        return this.blue;
    }

    public int getGreen() {
        return this.green;
    }

    @Nullable
    public String getHexCode() {
        return this.hexCode;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public int getRed() {
        return this.red;
    }

    static {
        FORMAT = Pattern.compile("(&[klmnorKLMNOR])");
        GRADIENT = Pattern.compile("(\\{(#[^{]*?)>})(.*?)(\\{(#.*?)<(>?)})");
        HEX_COLOR_NAME = Pattern.compile("(\\{#)([a-zA-Z_]{3,})(})");
        HEX_COLOR_NAME_LAST = Pattern.compile("(\\{#)([a-zA-Z_]{3,})(})(?!.*\\{#)");
        HEX_COLOR_REGEX = Pattern.compile("(\\{#)([0-9A-Fa-f]{6}|[0-9A-Fa-f]{3})(})");
        HEX_COLOR_REGEX_LAST = Pattern.compile("(\\{#)([0-9A-Fa-f]{6}|[0-9A-Fa-f]{3})(})(?!.*\\{#)");
        HEX_DE_COLORIZE_NAME = Pattern.compile("(([&\u00a7])x)((([&\u00a7])[0-9A-Fa-f]){6})");
        RANDOM = new SecureRandom();
        kyoriEnabled = new AtomicBoolean(true);
        BY_CHAR = new HashMap<Character, XColor>();
        BY_NAME = new HashMap<String, XColor>();
        CUSTOM_BY_HEX = new LinkedHashMap<String, XColor>();
        CUSTOM_BY_NAME = new HashMap<String, XColor>();
        CUSTOM_BY_RGB = new TreeMap();
        AQUA = new XColor("Aqua", 'b', 85, 255, 255);
        BLACK = new XColor("Black", '0', 0, 0, 0);
        BLUE = new XColor("Blue", '9', 85, 85, 255);
        BOLD = new XColor("Bold", 'l', false);
        DARK_AQUA = new XColor("Dark_Aqua", '3', 0, 170, 170);
        DARK_BLUE = new XColor("Dark_Blue", '1', 0, 0, 170);
        DARK_GRAY = new XColor("Dark_Gray", '8', 85, 85, 85);
        DARK_GREEN = new XColor("Dark_Green", '2', 0, 170, 0);
        DARK_PURPLE = new XColor("Dark_Purple", '5', 170, 0, 170);
        DARK_RED = new XColor("Dark_Red", '4', 170, 0, 0);
        GOLD = new XColor("Gold", '6', 255, 170, 0);
        GRAY = new XColor("Gray", '7', 170, 170, 170);
        GREEN = new XColor("Green", 'a', 85, 255, 85);
        HEX = new XColor("Hex", 'x', false, false);
        ITALIC = new XColor("Italic", 'o', false);
        LIGHT_PURPLE = new XColor("Light_Purple", 'd', 255, 85, 255);
        OBFUSCATED = new XColor("Obfuscated", 'k', false);
        RED = new XColor("Red", 'c', 255, 85, 85);
        RESET = new XColor("Reset", 'r', false, true);
        STRIKETHROUGH = new XColor("Strikethrough", 'm', false);
        UNDERLINE = new XColor("Underline", 'n', false);
        WHITE = new XColor("White", 'f', 255, 255, 255);
        YELLOW = new XColor("Yellow", 'e', 255, 255, 85);
        for (float x = 0.0f; x <= 1.0f; x += 0.1f) {
            for (float z = 0.1f; z <= 1.0f; z += 0.1f) {
                for (float y = 0.0f; y <= 1.0f; y += 0.03f) {
                    Color color = Color.getHSBColor(y, x, z);
                    StringBuilder builder = new StringBuilder().append(Integer.toHexString((color.getRed() << 16) + (color.getGreen() << 8) + color.getBlue() & 0xFFFFFF));
                    while (builder.length() < 6) {
                        builder.append("0").append((CharSequence)builder);
                    }
                    XColor.getClosest(builder.toString());
                }
            }
        }
    }
}

