/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.hooks.hooks;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.node.types.ChatMetaNode;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.hooks.Wrapped;
import tr.com.infumia.infumialib.platform.paper.hooks.Groups;

public record LuckPermsWrapper(@NotNull LuckPerms luckPerms) implements Wrapped
{
    public long getEffectiveLimitedPermission(@NotNull String permission, @NotNull Player player, long defaultValue) {
        return this.getEffectiveLimitedPermission(permission, player.getUniqueId(), defaultValue);
    }

    public long getEffectiveLimitedPermission(@NotNull String permission, @NotNull UUID uniqueId, long defaultValue) {
        AtomicLong calculatedLimit = new AtomicLong(defaultValue);
        User user = this.luckPerms.getUserManager().getUser(uniqueId);
        if (user == null) {
            return calculatedLimit.get();
        }
        Map permissionMap = user.getCachedData().getPermissionData().getPermissionMap();
        List<String> permissions = permissionMap.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).toList();
        if (permissions.isEmpty()) {
            return calculatedLimit.get();
        }
        Groups.calculatePermissionLimit(permission, permissions, calculatedLimit);
        return calculatedLimit.get();
    }

    @NotNull
    public Optional<List<String>> getGroupPrefixes(@NotNull String group) {
        return Optional.ofNullable(this.luckPerms.getGroupManager().getGroup(group)).map(gr -> new ArrayList(gr.getNodes(NodeType.PREFIX))).map(nodes -> nodes.stream().map(ChatMetaNode::getMetaValue).toList());
    }

    @NotNull
    public Optional<List<String>> getGroupSuffixes(@NotNull String group) {
        return Optional.ofNullable(this.luckPerms.getGroupManager().getGroup(group)).map(gr -> new ArrayList(gr.getNodes(NodeType.SUFFIX))).map(nodes -> nodes.stream().map(ChatMetaNode::getMetaValue).toList());
    }

    @NotNull
    public Optional<String> getGroups(@NotNull Player player) {
        return Optional.ofNullable(this.luckPerms.getUserManager().getUser(player.getUniqueId())).map(User::getPrimaryGroup);
    }

    @NotNull
    public Optional<List<String>> getUserPrefixes(@NotNull Player player) {
        return Optional.ofNullable(this.luckPerms.getUserManager().getUser(player.getUniqueId())).map(gr -> new ArrayList(gr.getNodes(NodeType.PREFIX))).map(nodes -> nodes.stream().map(ChatMetaNode::getMetaValue).toList());
    }

    @NotNull
    public Optional<List<String>> getUserSuffixes(@NotNull Player player) {
        return Optional.ofNullable(this.luckPerms.getUserManager().getUser(player.getUniqueId())).map(gr -> new ArrayList(gr.getNodes(NodeType.SUFFIX))).map(nodes -> nodes.stream().map(ChatMetaNode::getMetaValue).toList());
    }
}

