/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.itemstack;

import com.cryptomorin.xseries.XEnchantment;
import com.cryptomorin.xseries.XMaterial;
import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import io.github.bananapuncher714.nbteditor.NBTEditor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.CrossbowMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.meta.SpawnEggMeta;
import org.bukkit.material.MaterialData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import tr.com.infumia.bukkitversion.BukkitVersion;
import tr.com.infumia.infumialib.misc.Definitions;
import tr.com.infumia.infumialib.platform.paper.color.XColor;
import tr.com.infumia.infumialib.platform.paper.itemstack.BannerItemBuilder;
import tr.com.infumia.infumialib.platform.paper.itemstack.BookItemBuilder;
import tr.com.infumia.infumialib.platform.paper.itemstack.CrossbowItemBuilder;
import tr.com.infumia.infumialib.platform.paper.itemstack.FireworkItemBuilder;
import tr.com.infumia.infumialib.platform.paper.itemstack.LeatherArmorItemBuilder;
import tr.com.infumia.infumialib.platform.paper.itemstack.MapItemBuilder;
import tr.com.infumia.infumialib.platform.paper.itemstack.PotionItemBuilder;
import tr.com.infumia.infumialib.platform.paper.itemstack.SkullItemBuilder;
import tr.com.infumia.infumialib.platform.paper.itemstack.SpawnEggItemBuilder;

public abstract class ItemStackBuilder<M extends ItemMeta, S extends ItemStackBuilder<M, S>>
implements Definitions.Self<S> {
    @NotNull
    private M itemMeta;
    @NotNull
    private ItemStack itemStack;

    @NotNull
    public static Impl simple(@NotNull ItemStack itemStack) {
        ItemMeta meta = Objects.requireNonNull(itemStack.getItemMeta(), "Item stack's item meta is not found!");
        return new Impl(meta, itemStack);
    }

    @NotNull
    public static Impl simple(@NotNull Material material) {
        return ItemStackBuilder.simple(new ItemStack(material));
    }

    @NotNull
    public static Impl simple(@NotNull XMaterial material) {
        return ItemStackBuilder.simple(Optional.ofNullable(material.parseMaterial()).orElseThrow(() -> new IllegalStateException("Material %s not found!".formatted(material))));
    }

    @NotNull
    public final S addAttributeModifier(@NotNull Attribute attribute, @NotNull AttributeModifier modifier) {
        if (BukkitVersion.MAJOR >= 14) {
            this.itemMeta.addAttributeModifier(attribute, modifier);
        }
        return (S)((ItemStackBuilder)this.self());
    }

    @NotNull
    public final S addAttributeModifier(@NotNull Multimap<Attribute, AttributeModifier> map) {
        if (BukkitVersion.MAJOR >= 14) {
            this.itemMeta.setAttributeModifiers(map);
        }
        return (S)((ItemStackBuilder)this.self());
    }

    @NotNull
    public final S addCustomData(@NotNull Object value, Object ... keys) {
        NBTEditor.NBTCompound compound = NBTEditor.getNBTCompound((Object)this.itemStack, (Object[])new Object[0]);
        compound.set(value, new Object[]{"tag", keys});
        return this.itemStack(NBTEditor.getItemFromTag((NBTEditor.NBTCompound)compound));
    }

    @NotNull
    public final S addEnchantments(String ... enchantments) {
        for (String enchantmentString : enchantments) {
            String enchantment;
            String[] split = enchantmentString.split(":");
            AtomicInteger level = new AtomicInteger();
            if (split.length == 1) {
                enchantment = split[0];
                level.set(1);
            } else {
                enchantment = split[0];
                try {
                    level.set(Integer.parseInt(split[1]));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            XEnchantment.matchXEnchantment((String)enchantment).ifPresent(xEnchantment -> this.addEnchantments((XEnchantment)xEnchantment, level.get()));
        }
        return (S)((ItemStackBuilder)this.self());
    }

    @NotNull
    public final S addEnchantments(@NotNull XEnchantment enchantment, int level) {
        return (S)Optional.ofNullable(enchantment.getEnchant()).map(value -> this.addEnchantments((Enchantment)value, level)).orElse((ItemStackBuilder)this.self());
    }

    @NotNull
    public final S addEnchantments(@NotNull Enchantment enchantment, int level) {
        return this.addEnchantments(Map.of(enchantment, level));
    }

    @NotNull
    public final S addEnchantments(@NotNull Map<Enchantment, Integer> enchantments) {
        enchantments.forEach((enchantment, level) -> this.itemMeta.addEnchant(enchantment, level.intValue(), true));
        return (S)((ItemStackBuilder)this.self());
    }

    @NotNull
    public final S addFlag(ItemFlag ... flags) {
        this.itemMeta.addItemFlags(flags);
        return (S)((ItemStackBuilder)this.self());
    }

    @NotNull
    public final S addFlags(@NotNull Collection<String> flags) {
        flags.stream().map(ItemFlag::valueOf).forEach(xva$0 -> this.addFlag((ItemFlag)xva$0));
        return (S)((ItemStackBuilder)this.self());
    }

    @NotNull
    public final S addGlowEffect(@NotNull Enchantment enchantment, int level) {
        this.addFlag(ItemFlag.HIDE_ENCHANTS);
        return this.addEnchantments(enchantment, level);
    }

    @NotNull
    public final S addGlowEffect(@NotNull Enchantment enchantment) {
        return this.addGlowEffect(enchantment, 1);
    }

    @NotNull
    public final S addGlowEffect() {
        return (S)Optional.ofNullable(XMaterial.BOW.parseMaterial()).map(material -> this.addGlowEffect(this.itemStack.getType() != material ? Enchantment.ARROW_INFINITE : Enchantment.LUCK)).orElse((ItemStackBuilder)this.self());
    }

    @NotNull
    public final S addLore(String ... lore) {
        return this.addLore(true, lore);
    }

    @NotNull
    public final S addLore(boolean colored, String ... lore) {
        return this.addLore(List.of(lore), colored);
    }

    @NotNull
    public final S addLore(@NotNull List<String> lore) {
        return this.addLore(lore, true);
    }

    @NotNull
    public final S addLore(@NotNull List<String> lore, boolean colored) {
        List join = Optional.ofNullable(this.itemMeta.getLore()).orElse(new ArrayList());
        join.addAll(colored ? XColor.colorize(lore) : lore);
        this.itemMeta.setLore(join);
        return (S)((ItemStackBuilder)this.self());
    }

    @NotNull
    public final S addLoreAsComponent(Component ... lore) {
        return this.addLoreAsComponent(List.of(lore));
    }

    @NotNull
    public final S addLoreAsComponent(@NotNull List<Component> lore) {
        List join = Optional.ofNullable(this.itemMeta.lore()).orElse(new ArrayList());
        join.addAll(lore);
        this.itemMeta.lore(join);
        return (S)((ItemStackBuilder)this.self());
    }

    @NotNull
    public final S addSerializedEnchantments(@NotNull Map<String, Integer> enchantments) {
        enchantments.forEach((enchantmentString, level) -> XEnchantment.matchXEnchantment((String)String.valueOf(enchantmentString)).flatMap(enchant -> Optional.ofNullable(enchant.getEnchant())).ifPresent(enchantment -> this.addEnchantments((Enchantment)enchantment, (int)level)));
        return (S)((ItemStackBuilder)this.self());
    }

    @NotNull
    public final S amount(int amount) {
        this.itemStack.setAmount(amount);
        return (S)((ItemStackBuilder)this.self());
    }

    @NotNull
    public final BannerItemBuilder asBanner() {
        return BannerItemBuilder.simple(this.validateMeta(BannerMeta.class), this.itemStack);
    }

    @NotNull
    public final BookItemBuilder asBook() {
        return BookItemBuilder.from(this.validateMeta(BookMeta.class), this.itemStack);
    }

    @NotNull
    public final CrossbowItemBuilder asCrossbow() {
        Preconditions.checkState((BukkitVersion.MAJOR < 14 ? 1 : 0) != 0, (Object)"This method is for only 14 and newer versions!");
        return CrossbowItemBuilder.from(this.validateMeta(CrossbowMeta.class), this.itemStack);
    }

    @NotNull
    public final FireworkItemBuilder asFirework() {
        return FireworkItemBuilder.from(this.validateMeta(FireworkMeta.class), this.itemStack);
    }

    @NotNull
    public final LeatherArmorItemBuilder asLeatherArmor() {
        return LeatherArmorItemBuilder.from(this.validateMeta(LeatherArmorMeta.class), this.itemStack);
    }

    @NotNull
    public final MapItemBuilder asMap() {
        return MapItemBuilder.from(this.validateMeta(MapMeta.class), this.itemStack);
    }

    @NotNull
    public final PotionItemBuilder asPotion() {
        return PotionItemBuilder.from(this.validateMeta(PotionMeta.class), this.itemStack);
    }

    @NotNull
    public final SkullItemBuilder asSkull() {
        return SkullItemBuilder.from(this.validateMeta(SkullMeta.class), this.itemStack);
    }

    @NotNull
    public final SpawnEggItemBuilder asSpawnEgg() {
        Preconditions.checkState((BukkitVersion.MAJOR >= 11 ? 1 : 0) != 0, (Object)"This method is for only 11 and newer versions!");
        return SpawnEggItemBuilder.from(this.validateMeta(SpawnEggMeta.class), this.itemStack);
    }

    @NotNull
    public final S customModelData(@Nullable Integer data) {
        if (BukkitVersion.MAJOR >= 14) {
            this.itemMeta.setCustomModelData(data);
        }
        return (S)((ItemStackBuilder)this.self());
    }

    @NotNull
    public final S data(byte data) {
        return this.data(this.itemStack.getType().getNewData(data));
    }

    @NotNull
    public final S data(@NotNull MaterialData data) {
        this.itemStack.setData(data);
        return (S)((ItemStackBuilder)this.self());
    }

    @NotNull
    public final S durability(short durability) {
        this.itemStack.setDurability(durability);
        return (S)((ItemStackBuilder)this.self());
    }

    public final boolean isBanner() {
        return this.isMeta(BannerMeta.class);
    }

    public final boolean isBook() {
        return this.isMeta(BookMeta.class);
    }

    public final boolean isCrossbow() {
        return BukkitVersion.MAJOR >= 14 && this.isMeta(CrossbowMeta.class);
    }

    public final boolean isFirework() {
        return this.isMeta(FireworkMeta.class);
    }

    public final boolean isLeatherArmor() {
        return this.isMeta(LeatherArmorMeta.class);
    }

    public final boolean isMap() {
        return this.isMeta(MapMeta.class);
    }

    public final boolean isPotion() {
        return this.isMeta(PotionMeta.class);
    }

    public final boolean isSkull() {
        return this.isMeta(SkullMeta.class);
    }

    public final boolean isSpawnEgg() {
        return BukkitVersion.MAJOR >= 11 && this.isMeta(SpawnEggMeta.class);
    }

    @NotNull
    public final S itemMeta(@NotNull M itemMeta) {
        this.itemMeta = itemMeta;
        return (S)((ItemStackBuilder)this.self());
    }

    @NotNull
    public final M itemMeta() {
        return this.itemMeta;
    }

    @NotNull
    public final ItemStack itemStack() {
        return this.itemStack(true);
    }

    @NotNull
    public final ItemStack itemStack(boolean update) {
        if (update && !Objects.equals(this.itemMeta, this.itemStack.getItemMeta())) {
            this.itemStack.setItemMeta(this.itemMeta);
        }
        return this.itemStack;
    }

    @NotNull
    public final S itemStack(@NotNull ItemStack itemStack) {
        this.itemStack = itemStack;
        return (S)((ItemStackBuilder)this.self());
    }

    @NotNull
    public final S localizedName(@Nullable String name) {
        if (BukkitVersion.MAJOR >= 12) {
            this.itemMeta.setLocalizedName(name);
        }
        return (S)((ItemStackBuilder)this.self());
    }

    @NotNull
    public final S lore(String ... lore) {
        return this.lore(true, lore);
    }

    @NotNull
    public final S lore(boolean colored, String ... lore) {
        return this.lore(List.of(lore), colored);
    }

    @NotNull
    public final S lore(@NotNull List<String> lore) {
        return this.lore(lore, true);
    }

    @NotNull
    public final S lore(@NotNull List<String> lore, boolean colored) {
        this.itemMeta.setLore(colored ? XColor.colorize(lore) : lore);
        return (S)((ItemStackBuilder)this.self());
    }

    @NotNull
    public final S loreAsComponent(Component ... lore) {
        return this.loreAsComponent(List.of(lore));
    }

    @NotNull
    public final S loreAsComponent(@NotNull List<Component> lore) {
        this.itemMeta.lore(lore);
        return (S)((ItemStackBuilder)this.self());
    }

    @NotNull
    public final S material(@NotNull Material material) {
        return this.type(material);
    }

    @NotNull
    public final S name(@NotNull String name) {
        return this.name(name, true);
    }

    @NotNull
    public final S name(@NotNull String name, boolean colored) {
        this.itemMeta.setDisplayName(colored ? XColor.colorize(name) : name);
        return (S)((ItemStackBuilder)this.self());
    }

    @NotNull
    public final S nameAsComponent(@NotNull Component name) {
        this.itemMeta.displayName(name);
        return (S)((ItemStackBuilder)this.self());
    }

    @NotNull
    public final S removeAttributeModifier(@NotNull Attribute attribute) {
        if (BukkitVersion.MAJOR >= 14) {
            this.itemMeta.removeAttributeModifier(attribute);
        }
        return (S)((ItemStackBuilder)this.self());
    }

    @NotNull
    public final S removeAttributeModifier(@NotNull EquipmentSlot slot) {
        if (BukkitVersion.MAJOR >= 14) {
            this.itemMeta.removeAttributeModifier(slot);
        }
        return (S)((ItemStackBuilder)this.self());
    }

    @NotNull
    public final S removeAttributeModifier(@NotNull Attribute attribute, @NotNull AttributeModifier modifier) {
        if (BukkitVersion.MAJOR >= 14) {
            this.itemMeta.removeAttributeModifier(attribute, modifier);
        }
        return (S)((ItemStackBuilder)this.self());
    }

    @NotNull
    public final S removeFlag(ItemFlag ... flags) {
        this.itemMeta.removeItemFlags(flags);
        return (S)((ItemStackBuilder)this.self());
    }

    @NotNull
    public final S type(@NotNull Material material) {
        this.itemStack.setType(material);
        return (S)((ItemStackBuilder)this.self());
    }

    @NotNull
    public final S unbreakable(boolean unbreakable) {
        if (BukkitVersion.MAJOR < 11) {
            return this.itemStack((ItemStack)NBTEditor.set((Object)this.itemStack, (Object)(unbreakable ? (byte)1 : 0), (Object[])new Object[]{"Unbreakable"}));
        }
        this.itemMeta.setUnbreakable(unbreakable);
        return (S)((ItemStackBuilder)this.self());
    }

    @NotNull
    public final S version(int version) {
        if (BukkitVersion.MAJOR >= 14) {
            this.itemMeta.setVersion(version);
        }
        return (S)((ItemStackBuilder)this.self());
    }

    public void deserialize(@NotNull ConfigurationNode node) throws SerializationException {
        this.amount(node.node(new Object[]{"amount"}).getInt(1));
        Optional.ofNullable((Short)node.node(new Object[]{"damage"}).get(Short.TYPE)).ifPresent(this::durability);
        Optional.ofNullable((Byte)node.node(new Object[]{"data"}).get(Byte.TYPE)).ifPresent(this::data);
        MiniMessage miniMessage = MiniMessage.miniMessage();
        Optional.ofNullable(node.node(new Object[]{"name"}).getString()).ifPresent(name -> {
            if (XColor.isKyoriEnabled()) {
                try {
                    this.nameAsComponent(miniMessage.deserialize(name));
                }
                catch (Exception e) {
                    this.name(XColor.colorize(name));
                }
            } else {
                this.name(XColor.colorize(name));
            }
        });
        Optional.ofNullable(node.node(new Object[]{"lore"}).getList(String.class)).ifPresent(lore -> {
            if (XColor.isKyoriEnabled()) {
                try {
                    this.loreAsComponent(lore.stream().map(arg_0 -> ((MiniMessage)miniMessage).deserialize(arg_0)).toList());
                }
                catch (Exception e) {
                    this.lore(XColor.colorize(lore));
                }
            } else {
                this.lore(XColor.colorize(lore));
            }
        });
        HashMap<String, Integer> serializedEnchantments = new HashMap<String, Integer>();
        node.node(new Object[]{"enchants"}).childrenMap().forEach((key, child) -> serializedEnchantments.put(key.toString(), child.getInt()));
        this.addSerializedEnchantments(serializedEnchantments);
        Optional.ofNullable(node.node(new Object[]{"flags"}).getList(String.class)).ifPresent(this::addFlags);
        if (node.hasChild(new Object[]{"custom-model-data"})) {
            this.customModelData(node.node(new Object[]{"custom-model-data"}).getInt());
        }
    }

    public void serialize(@NotNull ConfigurationNode node) throws SerializationException {
        Set flags;
        block20: {
            Optional<MaterialData> optional;
            node.node(new Object[]{"material"}).set((Object)this.itemStack.getType().toString());
            if (this.itemStack.getAmount() != 1) {
                node.node(new Object[]{"amount"}).set((Object)this.itemStack.getAmount());
            }
            if (this.itemStack.getDurability() != 0) {
                node.node(new Object[]{"damage"}).set((Object)this.itemStack.getDurability());
            }
            if (BukkitVersion.MAJOR < 13 && (optional = Optional.ofNullable(this.itemStack.getData()).filter(materialData -> materialData.getData() != 0)).isPresent()) {
                node.node(new Object[]{"data"}).set((Object)optional.get().getData());
            }
            MiniMessage miniMessage = MiniMessage.miniMessage();
            if (this.itemMeta.hasDisplayName()) {
                if (XColor.isKyoriEnabled()) {
                    try {
                        Component component = this.itemMeta.displayName();
                        if (component != null) {
                            node.node(new Object[]{"name"}).set(miniMessage.serialize(component));
                        }
                    }
                    catch (Exception e) {
                        node.node(new Object[]{"name"}).set((Object)XColor.deColorize(this.itemMeta.getDisplayName()));
                    }
                } else {
                    node.node(new Object[]{"name"}).set((Object)XColor.deColorize(this.itemMeta.getDisplayName()));
                }
            }
            if (this.itemMeta.hasLore()) {
                if (XColor.isKyoriEnabled()) {
                    try {
                        List lore = this.itemMeta.lore();
                        if (lore != null) {
                            node.node(new Object[]{"lore"}).setList(String.class, lore.stream().map(arg_0 -> ((MiniMessage)miniMessage).serialize(arg_0)).toList());
                        }
                        break block20;
                    }
                    catch (Exception e) {
                        if (this.itemMeta.getLore() != null) {
                            node.node(new Object[]{"lore"}).setList(String.class, XColor.deColorize(this.itemMeta.getLore()));
                        }
                        break block20;
                    }
                }
                if (this.itemMeta.getLore() != null) {
                    node.node(new Object[]{"lore"}).setList(String.class, XColor.deColorize(this.itemMeta.getLore()));
                }
            }
        }
        if (!(flags = this.itemMeta.getItemFlags()).isEmpty()) {
            node.node(new Object[]{"flags"}).setList(String.class, flags.stream().map(Enum::name).toList());
        }
        if (BukkitVersion.MAJOR >= 14 && this.itemMeta.hasCustomModelData()) {
            node.node(new Object[]{"custom-model-data", this.itemMeta.getCustomModelData()});
        }
        ConfigurationNode enchantmentNode = node.node(new Object[]{"enchants"});
        for (Map.Entry entry : this.itemMeta.getEnchants().entrySet()) {
            enchantmentNode.node(new Object[]{((Enchantment)entry.getKey()).getName()}).set(entry.getValue());
        }
    }

    private <I extends ItemMeta> boolean isMeta(@NotNull Class<I> meta) {
        return meta.isAssignableFrom(this.itemMeta.getClass());
    }

    @NotNull
    private <I extends ItemMeta> I validateMeta(@NotNull Class<I> meta) {
        Preconditions.checkArgument((boolean)this.isMeta(meta), (String)"%s's meta is not a %s!", (Object)this.itemStack, (Object)meta.getSimpleName());
        return (I)this.itemMeta;
    }

    protected ItemStackBuilder(@NotNull M itemMeta, @NotNull ItemStack itemStack) {
        if (itemMeta == null) {
            throw new NullPointerException("itemMeta is marked non-null but is null");
        }
        if (itemStack == null) {
            throw new NullPointerException("itemStack is marked non-null but is null");
        }
        this.itemMeta = itemMeta;
        this.itemStack = itemStack;
    }

    public static final class Impl
    extends ItemStackBuilder<ItemMeta, Impl> {
        private Impl(@NotNull ItemMeta itemMeta, @NotNull ItemStack itemStack) {
            super(itemMeta, itemStack);
        }

        @NotNull
        public Impl self() {
            return this;
        }
    }
}

