/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.kubernetes;

import com.google.common.base.Preconditions;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.kubernetes.DiscoveredService;

final class PodMapper {
    private static final Logger log = LogManager.getLogger(PodMapper.class);
    static final String ACTIVE_ANNOTATION = SystemUtils.getEnvironmentVariable((String)"MC_ACTIVE_LABEL", (String)"minecraft.infumia.net/active");
    static final String BASE_ANNOTATION = SystemUtils.getEnvironmentVariable((String)"MC_BASE_LABEL", (String)"minecraft.infumia.net/enabled");
    static final String GAMEPLAY_ANNOTATION = SystemUtils.getEnvironmentVariable((String)"MC_GAMEPLAY_LABEL", (String)"minecraft.infumia.net/gameplay");
    static final String LOBBY_ANNOTATION = SystemUtils.getEnvironmentVariable((String)"MC_LOBBY_LABEL", (String)"minecraft.infumia.net/lobby");
    static final String PROXY_ANNOTATION = SystemUtils.getEnvironmentVariable((String)"MC_PROXY_LABEL", (String)"minecraft.infumia.net/proxy");
    private static final String MINECRAFT_CONTAINER_PORT_NAME = "minecraft";

    @NotNull
    static Map<String, DiscoveredService> backendServicesFromPodList(@NotNull PodList podList) {
        return podList.getItems().stream().filter(PodMapper::isReady).filter(pod -> pod.getMetadata() != null).filter(pod -> pod.getMetadata().getLabels() != null).filter(pod -> !pod.getMetadata().getLabels().isEmpty()).map(PodMapper::tryGetPodAsDiscoveredService).filter(Objects::nonNull).collect(Collectors.toMap(DiscoveredService::name, Function.identity()));
    }

    private static int applicableBackendPortFromContainerPort(@NotNull ContainerPort port) {
        String portName = port.getName();
        if (portName != null && portName.equalsIgnoreCase(MINECRAFT_CONTAINER_PORT_NAME)) {
            return port.getContainerPort();
        }
        return port.getContainerPort() == 25565 ? port.getContainerPort() : Integer.valueOf(0);
    }

    private static int backendPortFromPod(@NotNull Pod pod) {
        List<Integer> ports = pod.getSpec().getContainers().stream().flatMap(c -> c.getPorts().stream()).map(PodMapper::applicableBackendPortFromContainerPort).filter(p -> p != 0).toList();
        ObjectMeta metadata = pod.getMetadata();
        Preconditions.checkState((ports.size() == 1 ? 1 : 0) != 0, (String)"Could not find applicable container ports for pod %s in namespace %s.\nMake sure the pod has either a port named 'minecraft', or a container port on 25565.", (Object)metadata.getName(), (Object)metadata.getNamespace());
        return ports.get(0);
    }

    private static boolean isReady(@NotNull Pod pod) {
        return pod.getStatus().getConditions().stream().filter(condition -> !condition.getType().equalsIgnoreCase("ready")).allMatch(condition -> condition.getStatus().equalsIgnoreCase("true"));
    }

    @NotNull
    private static DiscoveredService podAsDiscoveredService(@NotNull Pod pod) {
        ObjectMeta metadata = pod.getMetadata();
        Map labels = metadata.getLabels();
        return new DiscoveredService(metadata.getName(), pod.getStatus().getPodIP(), PodMapper.backendPortFromPod(pod), labels == null ? new HashMap() : labels);
    }

    @Nullable
    private static DiscoveredService tryGetPodAsDiscoveredService(@NotNull Pod pod) {
        try {
            return PodMapper.podAsDiscoveredService(pod);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return null;
        }
    }

    private PodMapper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

