/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.kubernetes;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.kubernetes.PodMapper;

public record DiscoveredService(@NotNull String name, @NotNull String host, int port, @NotNull Map<String, String> labels) {
    public DiscoveredService(@NotNull String name, @NotNull String host, int port, @NotNull Map<String, String> labels) {
        this.name = name = name.isEmpty() ? "%s:%d".formatted(host, port) : name;
        this.host = host;
        this.port = port;
        this.labels = labels;
    }

    public boolean isActive() {
        return this.labels.getOrDefault(PodMapper.ACTIVE_ANNOTATION, "false").equalsIgnoreCase("true");
    }

    public boolean isGameplay() {
        return this.labels.getOrDefault(PodMapper.GAMEPLAY_ANNOTATION, "false").equalsIgnoreCase("true");
    }

    public boolean isLobby() {
        return this.labels.getOrDefault(PodMapper.LOBBY_ANNOTATION, "false").equalsIgnoreCase("true");
    }

    public boolean isProxy() {
        return this.labels.getOrDefault(PodMapper.PROXY_ANNOTATION, "false").equalsIgnoreCase("true");
    }
}

