/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.kubernetes;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.kubernetes.DiscoveredService;

public final class ServerRegistry {
    private static final Set<DiscoveredService> REGISTERED_DEFAULT_SERVERS = new HashSet<DiscoveredService>();
    private static final Set<DiscoveredService> REGISTERED_SERVERS = new HashSet<DiscoveredService>();

    public static void register(@NotNull DiscoveredService server) {
        REGISTERED_SERVERS.add(server);
        if (server.isDefault()) {
            REGISTERED_DEFAULT_SERVERS.add(server);
        }
    }

    @NotNull
    public static Set<DiscoveredService> registeredDefaultServices() {
        return Collections.unmodifiableSet(REGISTERED_DEFAULT_SERVERS);
    }

    @NotNull
    public static Set<DiscoveredService> registeredServices() {
        return Collections.unmodifiableSet(REGISTERED_SERVERS);
    }

    public static void unregister(@NotNull DiscoveredService server) {
        REGISTERED_SERVERS.remove(server);
        REGISTERED_DEFAULT_SERVERS.remove(server);
    }

    private ServerRegistry() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

