/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.resolver.data;

import java.util.Collection;
import java.util.Objects;

public final class Dependency {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String snapshotId;
    private final Collection<Dependency> transitive;

    public Dependency(String groupId, String artifactId, String version, String snapshotId, Collection<Dependency> transitive) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.snapshotId = snapshotId;
        this.transitive = transitive;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public Collection<Dependency> getTransitive() {
        return this.transitive;
    }

    public String toString() {
        String snapshotId = this.getSnapshotId();
        String suffix = snapshotId != null && snapshotId.length() > 0 ? ":" + snapshotId : "";
        return this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getVersion() + suffix;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dependency that = (Dependency)o;
        return this.groupId.equals(that.groupId) && this.artifactId.equals(that.artifactId) && this.version.equals(that.version);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.version);
    }
}

