/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.relocation;

import io.github.slimjar.relocation.RelocationRule;
import io.github.slimjar.relocation.Relocator;
import io.github.slimjar.relocation.facade.JarRelocatorFacade;
import io.github.slimjar.relocation.facade.JarRelocatorFacadeFactory;
import java.io.File;
import java.io.IOException;
import java.util.Collection;

public final class JarFileRelocator
implements Relocator {
    private final Collection<RelocationRule> relocations;
    private final JarRelocatorFacadeFactory relocatorFacadeFactory;

    public JarFileRelocator(Collection<RelocationRule> relocations, JarRelocatorFacadeFactory relocatorFacadeFactory) {
        this.relocations = relocations;
        this.relocatorFacadeFactory = relocatorFacadeFactory;
    }

    @Override
    public void relocate(File input, File output) throws IOException, ReflectiveOperationException {
        output.getParentFile().mkdirs();
        output.createNewFile();
        JarRelocatorFacade jarRelocator = this.relocatorFacadeFactory.createFacade(input, output, this.relocations);
        jarRelocator.run();
    }
}

