/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.account;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.account.Account;
import tr.com.infumia.infumialib.account.AccountHandler;
import tr.com.infumia.infumialib.account.AccountStore;
import tr.com.infumia.infumialib.account.LogInOutHandler;
import tr.com.infumia.infumialib.account.LoginResult;
import tr.com.infumia.infumialib.data.LoginChain;
import tr.com.infumia.infumialib.definition.Holder;
import tr.com.infumia.infumialib.dynamism.DynamicRegistry;
import tr.com.infumia.infumialib.dynamism.defaults.DynamicLanguage;
import tr.com.infumia.infumialib.log.LogService;
import tr.com.infumia.infumialib.shared.proto.Logging;

public interface LogInOut
extends Holder.AccountStoreHolder,
LogInOutHandler {
    @NotNull
    public static LogInOut create(@NotNull AccountStore accountStore, @NotNull LogService logService, @NotNull DynamicRegistry dynamicRegistry) {
        return new Impl(accountStore, logService, dynamicRegistry);
    }

    @NotNull
    public ObjectList<AccountHandler> accountHandlers();

    public void addAccountHandler(@NotNull AccountHandler var1);

    public void addLogInOutHandler(@NotNull LogInOutHandler var1);

    @NotNull
    public ObjectList<LogInOutHandler> logInOutHandlers();

    public static final class Impl
    implements LogInOut {
        private final ObjectList<AccountHandler> accountHandlers = new ObjectArrayList();
        @NotNull
        private final AccountStore accountStore;
        private final Set<String> joining = ConcurrentHashMap.newKeySet();
        private final ObjectList<LogInOutHandler> logInOutHandlers = new ObjectArrayList();
        @NotNull
        private final LogService logService;
        private final Set<String> quiting = ConcurrentHashMap.newKeySet();
        @NotNull
        private final DynamicRegistry registry;

        @Override
        @NotNull
        public ObjectList<AccountHandler> accountHandlers() {
            return ObjectLists.unmodifiable(this.accountHandlers);
        }

        @Override
        public void addAccountHandler(@NotNull AccountHandler handler) {
            this.accountHandlers.add((Object)handler);
        }

        @Override
        public void addLogInOutHandler(@NotNull LogInOutHandler handler) {
            this.logInOutHandlers.add((Object)handler);
        }

        @Override
        @NotNull
        public ObjectList<LogInOutHandler> logInOutHandlers() {
            return ObjectLists.unmodifiable(this.logInOutHandlers);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public LoginResult onLogin(@NotNull LoginChain chain) {
            String uniqueId = chain.uniqueId();
            if (this.joining.contains(uniqueId)) {
                return LoginResult.error();
            }
            if (this.quiting.contains(uniqueId)) {
                return LoginResult.error();
            }
            this.joining.add(uniqueId);
            try {
                long now = System.currentTimeMillis();
                LoginResult result = this.onLogin0(chain);
                if (result.done()) {
                    this.logService.log(Logging.LogType.PLAYER_JOIN, uniqueId, "%s@%s logged in took %sms!".formatted(chain.name(), chain.address(), System.currentTimeMillis() - now));
                }
                LoginResult loginResult = result;
                return loginResult;
            }
            finally {
                this.joining.remove(uniqueId);
            }
        }

        @Override
        public void onQuit(@NotNull Account account) {
        }

        @NotNull
        private LoginResult onLogin0(@NotNull LoginChain chain) {
            Optional<Account> accountOptional = this.accountStore.get(chain.uniqueId());
            if (accountOptional.isPresent()) {
                String language = accountOptional.get().dynamicStore().dynamic(DynamicLanguage.class).language();
                return LoginResult.error();
            }
            LoginResult result = LoginResult.succeed();
            for (LogInOutHandler handler : this.logInOutHandlers) {
                LoginResult loginResult = handler.onLogin(chain);
                if (loginResult.done()) continue;
                result = loginResult;
                break;
            }
            if (!result.done()) {
                return result;
            }
            Account account = Account.create(this.registry, chain);
            for (AccountHandler handler : this.accountHandlers) {
                LoginResult loginResult = handler.onAccountCreate(account);
                if (loginResult.done()) continue;
                return loginResult;
            }
            this.accountStore.put(account);
            return result;
        }

        private Impl(@NotNull AccountStore accountStore, @NotNull LogService logService, @NotNull DynamicRegistry registry) {
            if (accountStore == null) {
                throw new NullPointerException("accountStore is marked non-null but is null");
            }
            if (logService == null) {
                throw new NullPointerException("logService is marked non-null but is null");
            }
            if (registry == null) {
                throw new NullPointerException("registry is marked non-null but is null");
            }
            this.accountStore = accountStore;
            this.logService = logService;
            this.registry = registry;
        }

        @Override
        @NotNull
        public AccountStore accountStore() {
            return this.accountStore;
        }
    }
}

