/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.messaging;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.definition.Definition;
import tr.com.infumia.infumialib.messaging.Travel;
import tr.com.infumia.infumialib.messaging.proto.Definitions;
import tr.com.infumia.infumialib.registries.Registry;
import tr.com.infumia.infumialib.teleport.Teleport;

public interface Portal
extends Definition.TeleportHolder,
Definition.TravelHolder,
Definition.BytesSerializer<String>,
Definition.Key<String>,
Definition.Type {
    public static final Registry<String, Portal> PORTALS = new Registry();

    @NotNull
    public static Optional<Portal> get(@NotNull String key) {
        return PORTALS.get(key);
    }

    public static void register(@NotNull Portal portal) {
        PORTALS.register(portal);
    }

    @Override
    @NotNull
    default public String key() {
        return this.type();
    }

    @NotNull
    public PositionResult onRequest(@NotNull Definitions.OfflineUser var1, @NotNull String var2);

    public boolean requiredOnLogin();

    @NotNull
    public BooleanResult sendRequest(@NotNull Definitions.OfflineUser var1, @NotNull String var2);

    public static final class PositionResult
    extends ErrorResult<Definitions.Position> {
        @Contract(value="null, null -> fail")
        public PositionResult(@Nullable Definitions.Error error, @Nullable @Nullable Supplier<Pair< @Nullable Definitions.Position,  @Nullable Definitions.Error>> supplier) {
            super(error, supplier);
        }
    }

    public static abstract class ErrorResult<T> {
        @Nullable
        private final Definitions.Error error;
        @Nullable
        private final @Nullable Supplier<Pair<@Nullable T,  @Nullable Definitions.Error>> supplier;

        @Contract(value="null, null -> fail")
        protected ErrorResult(@Nullable Definitions.Error error, @Nullable @Nullable Supplier<Pair<@Nullable T,  @Nullable Definitions.Error>> supplier) {
            Preconditions.checkState((error != null || supplier != null ? 1 : 0) != 0, (Object)"Both error and supplier are null!");
            this.error = error;
            this.supplier = supplier;
        }

        @Nullable
        public Definitions.Error error() {
            return this.error;
        }

        @Nullable
        public @Nullable Supplier<Pair<@Nullable T,  @Nullable Definitions.Error>> supplier() {
            return this.supplier;
        }
    }

    public static final class BooleanResult
    extends ErrorResult<Boolean> {
        @Contract(value="null, null -> fail")
        public BooleanResult(@Nullable Definitions.Error error, @Nullable @Nullable Supplier<Pair<@Nullable Boolean,  @Nullable Definitions.Error>> supplier) {
            super(error, supplier);
        }
    }

    public static abstract class Base
    implements Portal {
        private final boolean requiredOnLogin;
        @NotNull
        private final Teleport teleport;
        @NotNull
        private final Travel travel;
        @NotNull
        private final String type;

        @Override
        public boolean requiredOnLogin() {
            return this.requiredOnLogin;
        }

        @Override
        @NotNull
        public Teleport teleport() {
            return this.teleport;
        }

        @Override
        @NotNull
        public Travel travel() {
            return this.travel;
        }

        @Override
        @NotNull
        public String type() {
            return this.type;
        }

        protected Base(boolean requiredOnLogin, @NotNull Teleport teleport, @NotNull Travel travel, @NotNull String type) {
            if (teleport == null) {
                throw new NullPointerException("teleport is marked non-null but is null");
            }
            if (travel == null) {
                throw new NullPointerException("travel is marked non-null but is null");
            }
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.requiredOnLogin = requiredOnLogin;
            this.teleport = teleport;
            this.travel = travel;
            this.type = type;
        }
    }
}

