/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.resolver.data;

import io.github.slimjar.relocation.RelocationRule;
import io.github.slimjar.resolver.data.Dependency;
import io.github.slimjar.resolver.data.Mirror;
import io.github.slimjar.resolver.data.Repository;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public final class DependencyData {
    private final Collection<Mirror> mirrors;
    private final Collection<Repository> repositories;
    private final Collection<Dependency> dependencies;
    private final Collection<RelocationRule> relocations;

    public DependencyData(Collection<Mirror> mirrors, Collection<Repository> repositories, Collection<Dependency> dependencies, Collection<RelocationRule> relocations) {
        this.mirrors = Collections.unmodifiableCollection(mirrors);
        this.repositories = Collections.unmodifiableCollection(repositories);
        this.dependencies = Collections.unmodifiableCollection(dependencies);
        this.relocations = Collections.unmodifiableCollection(relocations);
    }

    public Collection<Repository> getRepositories() {
        return this.repositories;
    }

    public Collection<Dependency> getDependencies() {
        return this.dependencies;
    }

    public Collection<RelocationRule> getRelocations() {
        return this.relocations;
    }

    public Collection<Mirror> getMirrors() {
        return this.mirrors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DependencyData that = (DependencyData)o;
        return this.isCollectionEqual(this.repositories, that.repositories) && this.isCollectionEqual(this.dependencies, that.dependencies) && this.isCollectionEqual(this.relocations, that.relocations);
    }

    private <T> boolean isCollectionEqual(Collection<T> a, Collection<T> b) {
        return a.containsAll(b) && b.containsAll(a);
    }

    public int hashCode() {
        return Objects.hash(this.repositories, this.dependencies, this.relocations);
    }

    public String toString() {
        return "DependencyData{mirrors=" + this.mirrors + ", repositories=" + this.repositories + ", dependencies=" + this.dependencies + ", relocations=" + this.relocations + '}';
    }
}

