/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.common.transformer;

import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.common.transformer.declarations.GenericDeclaration;
import tr.com.infumia.infumialib.common.transformer.declarations.GenericHolder;
import tr.com.infumia.infumialib.common.transformer.declarations.GenericPair;

public interface Transformer<R, F>
extends GenericHolder<R, F> {
    @NotNull
    public static <R, F> Transformer<R, F> create(@NotNull Class<R> rawType, @NotNull Class<F> finalType, @NotNull @NotNull Function<@NotNull R, @Nullable F> transformation) {
        return new Impl<R, F>(rawType, finalType, transformation);
    }

    @NotNull
    public static <R, F> Transformer<R, F> create(@NotNull Class<R> rawType, @NotNull Class<F> finalType, @NotNull @NotNull Function<@NotNull R, @Nullable F> transformation, @NotNull @NotNull BiFunction<@NotNull R, @NotNull F, @Nullable F> transformationWithField) {
        return new Impl<R, F>(rawType, finalType, transformation, transformationWithField);
    }

    @NotNull
    public Optional<F> transform(@NotNull R var1);

    @NotNull
    public Optional<F> transformWithField(@NotNull R var1, @NotNull F var2);

    public static final class Impl<R, F>
    extends Base<R, F> {
        private Impl(@NotNull Class<R> rawType, @NotNull Class<F> finalType, @NotNull @NotNull Function<@NotNull R, @Nullable F> transformation) {
            super(rawType, finalType, transformation, (r, field) -> transformation.apply(r));
        }

        private Impl(@NotNull Class<R> rawType, @NotNull Class<F> finalType, @NotNull @NotNull Function<@NotNull R, @Nullable F> transformation, @NotNull @NotNull BiFunction<@NotNull R, @NotNull F, @Nullable F> transformationWithField) {
            super(rawType, finalType, transformation, transformationWithField);
        }
    }

    public static abstract class Base<R, F>
    implements Transformer<R, F> {
        @NotNull
        private final GenericHolder<R, F> holder;
        @NotNull
        private final @NotNull Function<@NotNull R, @Nullable F> transformation;
        @NotNull
        private final @NotNull BiFunction<@NotNull R, @NotNull F, @Nullable F> transformationWithField;

        protected Base(@NotNull Class<R> rawType, @NotNull Class<F> finalType, @NotNull @NotNull Function<@NotNull R, @Nullable F> transformation) {
            this(GenericHolder.create(rawType, finalType), transformation, (R r, F field) -> transformation.apply(r));
        }

        protected Base(@NotNull Class<R> rawType, @NotNull Class<F> finalType, @NotNull @NotNull Function<@NotNull R, @Nullable F> transformation, @NotNull @NotNull BiFunction<@NotNull R, @NotNull F, @Nullable F> transformationWithField) {
            this(GenericHolder.create(rawType, finalType), transformation, transformationWithField);
        }

        @Override
        @NotNull
        public final Optional<F> transform(@NotNull R r) {
            return Optional.ofNullable(this.transformation.apply(r));
        }

        @Override
        @NotNull
        public final Optional<F> transformWithField(@NotNull R r, @NotNull F field) {
            return Optional.ofNullable(this.transformationWithField.apply(r, field));
        }

        protected Base(@NotNull GenericHolder<R, F> holder, @NotNull @NotNull Function<@NotNull R, @Nullable F> transformation, @NotNull @NotNull BiFunction<@NotNull R, @NotNull F, @Nullable F> transformationWithField) {
            if (holder == null) {
                throw new NullPointerException("holder is marked non-null but is null");
            }
            if (transformation == null) {
                throw new NullPointerException("transformation is marked non-null but is null");
            }
            if (transformationWithField == null) {
                throw new NullPointerException("transformationWithField is marked non-null but is null");
            }
            this.holder = holder;
            this.transformation = transformation;
            this.transformationWithField = transformationWithField;
        }

        @Override
        public GenericDeclaration getLeftType() {
            return this.holder.getLeftType();
        }

        @Override
        public GenericPair getPair() {
            return this.holder.getPair();
        }

        @Override
        public GenericDeclaration getRightType() {
            return this.holder.getRightType();
        }
    }
}

