/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.common.transformer;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.common.transformer.TransformResolver;
import tr.com.infumia.infumialib.common.transformer.declarations.GenericDeclaration;

public final class TransformedData {
    private final Map<String, Object> deserializedMap;
    @NotNull
    private final TransformResolver resolver;
    private final boolean serialization;
    private final Map<String, Object> serializedMap;

    @NotNull
    public static TransformedData deserialization(@NotNull TransformResolver resolver, @NotNull Map<String, Object> map) {
        return new TransformedData(new ConcurrentHashMap<String, Object>(map), resolver, false, new ConcurrentHashMap<String, Object>());
    }

    @NotNull
    public static TransformedData serialization(@NotNull TransformResolver resolver) {
        return new TransformedData(new ConcurrentHashMap<String, Object>(), resolver, true, new ConcurrentHashMap<String, Object>());
    }

    public void add(@NotNull String path, @Nullable Object value) {
        if (this.canDeserialize()) {
            return;
        }
        if (value == null) {
            this.remove(path);
        } else {
            this.serializedMap.put(path, this.resolver.serialize(value, null, true));
        }
    }

    public <T> void add(@NotNull String path, @Nullable Object value, @NotNull Class<T> cls) {
        if (this.canDeserialize()) {
            return;
        }
        if (value == null) {
            this.remove(path);
        } else {
            this.serializedMap.put(path, this.resolver.serialize(value, GenericDeclaration.of(cls), true));
        }
    }

    public void add(@NotNull String path, @Nullable TransformedData value) {
        if (this.canDeserialize()) {
            return;
        }
        if (value == null) {
            this.remove(path);
        } else {
            this.serializedMap.put(path, value.serializedMap());
        }
    }

    public <T> void addAsCollection(@NotNull String path, @Nullable Collection<T> value, @NotNull Class<T> elementClass) {
        if (this.canDeserialize()) {
            return;
        }
        if (value == null) {
            this.remove(path);
        } else {
            this.serializedMap.put(path, this.resolver.serializeCollection(value, GenericDeclaration.of(value.getClass(), elementClass), true));
        }
    }

    public <K, V> void addAsMap(@NotNull String path, @Nullable Map<K, V> value, @NotNull Class<K> keyClass, @NotNull Class<V> valueClass) {
        if (this.canDeserialize()) {
            return;
        }
        if (value == null) {
            this.remove(path);
        } else {
            this.serializedMap.put(path, this.resolver.serializeMap(value, GenericDeclaration.of(value.getClass(), keyClass, valueClass), true));
        }
    }

    public void addFormatted(@NotNull String path, @Nullable String value, Object ... args) {
        if (value == null) {
            this.remove(path);
        } else {
            this.add(path, MessageFormat.format(value, args), String.class);
        }
    }

    public boolean containsKey(@NotNull String key) {
        return this.canDeserialize() && this.deserializedMap.containsKey(key);
    }

    @NotNull
    public TransformedData copy() {
        return this.copy(new ConcurrentHashMap<String, Object>());
    }

    @NotNull
    public TransformedData copy(@NotNull Map<String, Object> deserializedMap) {
        return new TransformedData(deserializedMap, this.resolver, this.serialization, new ConcurrentHashMap<String, Object>());
    }

    @NotNull
    public Map<String, Object> deserializedMap() {
        return Collections.unmodifiableMap(this.deserializedMap);
    }

    @NotNull
    public <T> Optional<T> get(@NotNull String key, @NotNull Class<T> objectClass) {
        return this.get(key, objectClass, null);
    }

    @NotNull
    public <T> Optional<T> get(@NotNull String key, @NotNull Class<T> objectClass, @Nullable T defaultValue) {
        if (this.canSerialize()) {
            return Optional.empty();
        }
        Object object = this.deserializedMap.get(key);
        if (object == null) {
            return Optional.empty();
        }
        return Optional.of(this.resolver.deserialize(object, GenericDeclaration.of(object), objectClass, null, defaultValue));
    }

    @NotNull
    public <T> Optional<List<T>> getAsCollection(@NotNull String key, @NotNull Class<T> elementClass) {
        return this.getAsCollection(key, elementClass, null);
    }

    @NotNull
    public <T> Optional<List<T>> getAsCollection(@NotNull String key, @NotNull Class<T> elementClass, @Nullable T defaultValue) {
        if (this.canSerialize()) {
            return Optional.empty();
        }
        Object object = this.deserializedMap.get(key);
        if (object == null) {
            return Optional.empty();
        }
        return Optional.of(this.resolver.deserialize(object, GenericDeclaration.of(object), List.class, GenericDeclaration.of(List.class, elementClass), defaultValue));
    }

    @NotNull
    public <K, V> Optional<Map<K, V>> getAsMap(@NotNull String key, @NotNull Class<K> keyClass, @NotNull Class<V> valueClass) {
        return this.getAsMap(key, GenericDeclaration.of(keyClass), GenericDeclaration.of(valueClass));
    }

    @NotNull
    public <K, V> Optional<Map<K, V>> getAsMap(@NotNull String key, @NotNull GenericDeclaration keyClass, @NotNull GenericDeclaration valueClass) {
        if (this.canSerialize()) {
            return Optional.empty();
        }
        Object object = this.deserializedMap.get(key);
        if (object == null) {
            return Optional.empty();
        }
        return Optional.of(this.resolver.deserialize(object, GenericDeclaration.of(object), Map.class, GenericDeclaration.of(Map.class, keyClass, valueClass), null));
    }

    public void remove(@NotNull String path) {
        if (this.canSerialize()) {
            this.serializedMap.remove(path);
        }
    }

    @NotNull
    public Map<String, Object> serializedMap() {
        return Collections.unmodifiableMap(this.serializedMap);
    }

    private boolean canDeserialize() {
        return !this.serialization;
    }

    private boolean canSerialize() {
        return this.serialization;
    }

    private TransformedData(Map<String, Object> deserializedMap, @NotNull TransformResolver resolver, boolean serialization, Map<String, Object> serializedMap) {
        if (resolver == null) {
            throw new NullPointerException("resolver is marked non-null but is null");
        }
        this.deserializedMap = deserializedMap;
        this.resolver = resolver;
        this.serialization = serialization;
        this.serializedMap = serializedMap;
    }

    @NotNull
    public TransformResolver resolver() {
        return this.resolver;
    }
}

