/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.github.AbuseLimitHandler;
import org.kohsuke.github.GHIOException;
import org.kohsuke.github.GHMyself;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.GitHubRateLimitChecker;
import org.kohsuke.github.GitHubRequest;
import org.kohsuke.github.GitHubResponse;
import org.kohsuke.github.HttpConnector;
import org.kohsuke.github.HttpException;
import org.kohsuke.github.RateLimitHandler;
import org.kohsuke.github.authorization.AuthorizationProvider;

class GitHubHttpUrlConnectionClient
extends GitHubClient {
    GitHubHttpUrlConnectionClient(String apiUrl, HttpConnector connector, RateLimitHandler rateLimitHandler, AbuseLimitHandler abuseLimitHandler, GitHubRateLimitChecker rateLimitChecker, Consumer<GHMyself> myselfConsumer, AuthorizationProvider authorizationProvider) throws IOException {
        super(apiUrl, connector, rateLimitHandler, abuseLimitHandler, rateLimitChecker, myselfConsumer, authorizationProvider);
    }

    @Override
    @Nonnull
    protected GitHubResponse.ResponseInfo getResponseInfo(GitHubRequest request) throws IOException {
        HttpURLConnection connection;
        try {
            connection = HttpURLConnectionResponseInfo.setupConnection(this, request);
        }
        catch (IOException e) {
            throw new GHIOException(e.getMessage(), e);
        }
        int statusCode = connection.getResponseCode();
        Map<String, List<String>> headers = connection.getHeaderFields();
        return new HttpURLConnectionResponseInfo(request, statusCode, headers, connection);
    }

    @Override
    protected void handleLimitingErrors(@Nonnull GitHubResponse.ResponseInfo responseInfo) throws IOException {
        if (GitHubHttpUrlConnectionClient.isRateLimitResponse(responseInfo)) {
            GHIOException e = new HttpException("Rate limit violation", responseInfo.statusCode(), responseInfo.headerField("Status"), responseInfo.url().toString()).withResponseHeaderFields(responseInfo.headers());
            this.rateLimitHandler.onError(e, ((HttpURLConnectionResponseInfo)responseInfo).connection);
        } else if (GitHubHttpUrlConnectionClient.isAbuseLimitResponse(responseInfo)) {
            GHIOException e = new HttpException("Abuse limit violation", responseInfo.statusCode(), responseInfo.headerField("Status"), responseInfo.url().toString()).withResponseHeaderFields(responseInfo.headers());
            this.abuseLimitHandler.onError(e, ((HttpURLConnectionResponseInfo)responseInfo).connection);
        }
    }

    static class HttpURLConnectionResponseInfo
    extends GitHubResponse.ResponseInfo {
        @Nonnull
        private final HttpURLConnection connection;
        private static final Logger LOGGER = Logger.getLogger(GitHubClient.class.getName());

        HttpURLConnectionResponseInfo(@Nonnull GitHubRequest request, int statusCode, @Nonnull Map<String, List<String>> headers, @Nonnull HttpURLConnection connection) {
            super(request, statusCode, headers);
            this.connection = connection;
        }

        @Nonnull
        static HttpURLConnection setupConnection(@Nonnull GitHubClient client, @Nonnull GitHubRequest request) throws IOException {
            String authorization;
            HttpURLConnection connection = client.getConnector().connect(request.url());
            if (!request.headers().containsKey("Authorization") && (authorization = client.getEncodedAuthorization()) != null) {
                connection.setRequestProperty("Authorization", client.getEncodedAuthorization());
            }
            HttpURLConnectionResponseInfo.setRequestMethod(request.method(), connection);
            HttpURLConnectionResponseInfo.buildRequest(request, connection);
            return connection;
        }

        private static void buildRequest(GitHubRequest request, HttpURLConnection connection) throws IOException {
            for (Map.Entry<String, String> e : request.headers().entrySet()) {
                String v = e.getValue();
                if (v == null) continue;
                connection.setRequestProperty(e.getKey(), v);
            }
            connection.setRequestProperty("Accept-Encoding", "gzip");
            if (request.inBody()) {
                connection.setDoOutput(true);
                try (InputStream body = request.body();){
                    if (body != null) {
                        int read;
                        connection.setRequestProperty("Content-type", StringUtils.defaultString(request.contentType(), "application/x-www-form-urlencoded"));
                        byte[] bytes = new byte[32768];
                        while ((read = body.read(bytes)) != -1) {
                            connection.getOutputStream().write(bytes, 0, read);
                        }
                    } else {
                        connection.setRequestProperty("Content-type", StringUtils.defaultString(request.contentType(), "application/json"));
                        HashMap<String, Object> json = new HashMap<String, Object>();
                        for (GitHubRequest.Entry e : request.args()) {
                            json.put(e.key, e.value);
                        }
                        GitHubClient.getMappingObjectWriter().writeValue(connection.getOutputStream(), json);
                    }
                }
            }
        }

        private static void setRequestMethod(String method, HttpURLConnection connection) throws IOException {
            try {
                connection.setRequestMethod(method);
            }
            catch (ProtocolException e) {
                connection.setRequestProperty("X-HTTP-Method-Override", method);
                connection.setRequestMethod("POST");
            }
        }

        @Override
        InputStream bodyStream() throws IOException {
            return this.wrapStream(this.connection.getInputStream());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        String errorMessage() {
            String result = null;
            InputStream stream = null;
            try {
                stream = this.connection.getErrorStream();
                if (stream != null) {
                    result = IOUtils.toString(this.wrapStream(stream), StandardCharsets.UTF_8);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.FINER, "Ignored exception get error message", e);
            }
            finally {
                IOUtils.closeQuietly(stream);
            }
            return result;
        }

        private InputStream wrapStream(InputStream stream) throws IOException {
            String encoding = this.headerField("Content-Encoding");
            if (encoding == null || stream == null) {
                return stream;
            }
            if (encoding.equals("gzip")) {
                return new GZIPInputStream(stream);
            }
            throw new UnsupportedOperationException("Unexpected Content-Encoding: " + encoding);
        }

        @Override
        public void close() throws IOException {
            IOUtils.closeQuietly(this.connection.getInputStream());
        }
    }
}

