/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs;

import io.github.portlek.configs.ConfigHolder;
import io.github.portlek.configs.ConfigType;
import io.github.portlek.configs.FieldLoader;
import io.github.portlek.configs.Loader;
import io.github.portlek.configs.annotation.FileVersion;
import io.github.portlek.configs.configuration.FileConfiguration;
import io.github.portlek.configs.exceptions.InvalidConfigurationException;
import io.github.portlek.configs.loaders.impl.FlConfigHolder;
import io.github.portlek.configs.loaders.impl.FlConfigLoader;
import io.github.portlek.configs.loaders.impl.FlConfiguration;
import io.github.portlek.configs.loaders.impl.FlConfigurationSection;
import io.github.portlek.configs.loaders.impl.FlFile;
import io.github.portlek.configs.loaders.impl.FlInetSocketAddress;
import io.github.portlek.configs.loaders.impl.FlLangLoader;
import io.github.portlek.configs.loaders.impl.FlLangValueLoader;
import io.github.portlek.configs.loaders.impl.FlLocale;
import io.github.portlek.configs.loaders.impl.FlRawField;
import io.github.portlek.configs.loaders.impl.FlUniqueId;
import io.github.portlek.configs.util.Validate;
import io.github.portlek.reflection.clazz.ClassOf;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigLoader
implements Loader {
    @NotNull
    private final Executor asyncExecutor;
    @Nullable
    private final ConfigHolder configHolder;
    @NotNull
    private final ConfigType configType;
    @NotNull
    private final String fileName;
    private final int fileVersion;
    private final Map<Integer, Consumer<Loader>> fileVersionOperations;
    @NotNull
    private final Path folderPath;
    @NotNull
    private final List<FieldLoader.Func> loaders;
    @Nullable
    private FileConfiguration configuration;
    @Nullable
    private File file;

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public static Builder builder(@NotNull String fileName, @NotNull File folder, @NotNull ConfigType configType) {
        return ConfigLoader.builder(fileName, folder.toPath(), configType);
    }

    @NotNull
    public static Builder builder(@NotNull String fileName, @NotNull Path folder, @NotNull ConfigType configType) {
        return ConfigLoader.builder().setFileName(fileName).setFolder(folder).setConfigType(configType);
    }

    @NotNull
    public static Builder builderForLang(@NotNull String fileName, @NotNull File folder, @NotNull ConfigType configType) {
        return ConfigLoader.builderForLang(fileName, folder.toPath(), configType);
    }

    @NotNull
    public static Builder builderForLang(@NotNull String fileName, @NotNull Path folder, @NotNull ConfigType configType) {
        return ConfigLoader.builder().setFileName(fileName).setFolder(folder).setConfigType(configType).setLoaders(List.of(FlConfigurationSection.INSTANCE, FlLangValueLoader.INSTANCE, FlConfiguration.INSTANCE, FlConfigHolder.INSTANCE, FlLangLoader.INSTANCE, FlFile.INSTANCE));
    }

    @Override
    @NotNull
    public File getFile() {
        return Objects.requireNonNull(this.file, "Use #load() method before use #getFile() method!");
    }

    @Override
    @NotNull
    public FileConfiguration getFileConfiguration() {
        return Objects.requireNonNull(this.configuration, "Use #load() method before use #getConfiguration() method!");
    }

    @NotNull
    public ConfigLoader load() {
        return this.load(false);
    }

    @NotNull
    public ConfigLoader load(boolean save) {
        return this.load(save, false).join();
    }

    @NotNull
    public CompletableFuture<ConfigLoader> load(boolean save, boolean async) {
        CompletableFuture<ConfigLoader> future = new CompletableFuture<ConfigLoader>();
        Supplier<ConfigLoader> job = () -> {
            this.createFolderAndFile();
            this.loadFile();
            this.loadFieldsAndSave(save);
            return this;
        };
        if (async) {
            future.completeAsync(job, this.asyncExecutor);
        } else {
            future.complete(job.get());
        }
        return future;
    }

    public void save() {
        try {
            this.configType.save(this.getFile(), this.getFileConfiguration());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void createFolderAndFile() {
        Path filePath = this.folderPath.resolve(this.fileName + this.configType.getSuffix());
        this.file = filePath.toFile();
        if (!Files.notExists(filePath, new LinkOption[0])) {
            return;
        }
        try {
            Files.createFile(filePath, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void loadFile() {
        Validate.checkNull(this.file, "file", new Object[0]);
        try {
            this.configuration = this.configType.load(this.file);
        }
        catch (InvalidConfigurationException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadFieldsAndSave(boolean save) {
        if (this.configHolder != null) {
            FieldLoader.load(this, this.configHolder);
        }
        if (save) {
            this.save();
        }
    }

    private ConfigLoader(@NotNull Executor asyncExecutor, @Nullable ConfigHolder configHolder, @NotNull ConfigType configType, @NotNull String fileName, int fileVersion, Map<Integer, Consumer<Loader>> fileVersionOperations, @NotNull Path folderPath, @NotNull List<FieldLoader.Func> loaders) {
        if (asyncExecutor == null) {
            throw new NullPointerException("asyncExecutor is marked non-null but is null");
        }
        if (configType == null) {
            throw new NullPointerException("configType is marked non-null but is null");
        }
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        if (folderPath == null) {
            throw new NullPointerException("folderPath is marked non-null but is null");
        }
        if (loaders == null) {
            throw new NullPointerException("loaders is marked non-null but is null");
        }
        this.asyncExecutor = asyncExecutor;
        this.configHolder = configHolder;
        this.configType = configType;
        this.fileName = fileName;
        this.fileVersion = fileVersion;
        this.fileVersionOperations = fileVersionOperations;
        this.folderPath = folderPath;
        this.loaders = loaders;
    }

    @NotNull
    public Executor getAsyncExecutor() {
        return this.asyncExecutor;
    }

    @Override
    @Nullable
    public ConfigHolder getConfigHolder() {
        return this.configHolder;
    }

    @NotNull
    public ConfigType getConfigType() {
        return this.configType;
    }

    @NotNull
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public int getFileVersion() {
        return this.fileVersion;
    }

    @Override
    public Map<Integer, Consumer<Loader>> getFileVersionOperations() {
        return this.fileVersionOperations;
    }

    @NotNull
    public Path getFolderPath() {
        return this.folderPath;
    }

    @Override
    @NotNull
    public List<FieldLoader.Func> getLoaders() {
        return this.loaders;
    }

    @Nullable
    public FileConfiguration getConfiguration() {
        return this.configuration;
    }

    public static final class Builder {
        private final Map<Integer, Consumer<Loader>> fileVersionOperations = new HashMap<Integer, Consumer<Loader>>();
        @NotNull
        private Executor asyncExecutor = Executors.newWorkStealingPool();
        @Nullable
        private ConfigHolder configHolder;
        @Nullable
        private ConfigType configType;
        @Nullable
        private String fileName;
        private int fileVersion = 1;
        @Nullable
        private Path folderPath;
        @NotNull
        private List<FieldLoader.Func> loaders = new ArrayList<FieldLoader.Func>(){
            {
                this.add(FlConfigurationSection.INSTANCE);
                this.add(FlInetSocketAddress.INSTANCE);
                this.add(FlConfiguration.INSTANCE);
                this.add(FlConfigHolder.INSTANCE);
                this.add(FlConfigLoader.INSTANCE);
                this.add(FlRawField.INSTANCE);
                this.add(FlUniqueId.INSTANCE);
                this.add(FlLocale.INSTANCE);
                this.add(FlFile.INSTANCE);
            }
        };

        @SafeVarargs
        @NotNull
        public final Builder addFileVersionOperation(Map.Entry<Integer, Consumer<Loader>> ... operations) {
            for (Map.Entry<Integer, Consumer<Loader>> operation : operations) {
                this.addFileVersionOperation(operation.getKey(), operation.getValue());
            }
            return this;
        }

        @NotNull
        public Builder addFileVersionOperation(int version, @NotNull Consumer<Loader> operations) {
            this.fileVersionOperations.put(version, operations);
            return this;
        }

        @NotNull
        public Builder addLoaders(FieldLoader.Func ... loaders) {
            Collections.addAll(this.loaders, loaders);
            return this;
        }

        @NotNull
        public ConfigLoader build() {
            Validate.checkNull(this.configType, "Use #setConfigType(ConfigType) method to set config type!", new Object[0]);
            Validate.checkNull(this.fileName, "Use #setFileName(String) method to set file name!", new Object[0]);
            Validate.checkNull(this.folderPath, "Use #setFolderPath(Path) method to set file path!", new Object[0]);
            if (this.configHolder != null) {
                new ClassOf<ConfigHolder>(this.configHolder).getAnnotation(FileVersion.class, fileVersion -> {
                    this.fileVersion = fileVersion.value();
                });
            }
            return new ConfigLoader(this.asyncExecutor, this.configHolder, this.configType, this.fileName, this.fileVersion, this.fileVersionOperations, this.folderPath, this.loaders);
        }

        @NotNull
        public Builder setAsyncExecutor(@NotNull Executor asyncExecutor) {
            this.asyncExecutor = asyncExecutor;
            return this;
        }

        @NotNull
        public Builder setConfigHolder(@NotNull ConfigHolder configHolder) {
            this.configHolder = configHolder;
            return this;
        }

        @NotNull
        public Builder setConfigType(@NotNull ConfigType configType) {
            this.configType = configType;
            return this;
        }

        @NotNull
        public Builder setFileName(@NotNull String fileName) {
            this.fileName = fileName;
            return this;
        }

        @NotNull
        public Builder setFileVersion(int fileVersion) {
            if (fileVersion < 1) {
                throw new IllegalArgumentException("The file version must be bigger than 0!");
            }
            this.fileVersion = fileVersion;
            return this;
        }

        @NotNull
        public Builder setFolder(@NotNull File folder) {
            this.folderPath = folder.toPath();
            return this;
        }

        @NotNull
        public Builder setFolder(@NotNull Path folderPath) {
            this.folderPath = folderPath;
            return this;
        }

        @NotNull
        public Builder setLoaders(@NotNull List<FieldLoader.Func> loaders) {
            this.loaders = loaders;
            return this;
        }

        public Map<Integer, Consumer<Loader>> getFileVersionOperations() {
            return this.fileVersionOperations;
        }

        @NotNull
        public Executor getAsyncExecutor() {
            return this.asyncExecutor;
        }

        @Nullable
        public ConfigHolder getConfigHolder() {
            return this.configHolder;
        }

        @Nullable
        public ConfigType getConfigType() {
            return this.configType;
        }

        @Nullable
        public String getFileName() {
            return this.fileName;
        }

        public int getFileVersion() {
            return this.fileVersion;
        }

        @Nullable
        public Path getFolderPath() {
            return this.folderPath;
        }

        @NotNull
        public List<FieldLoader.Func> getLoaders() {
            return this.loaders;
        }

        private Builder() {
        }
    }
}

