/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.util;

import io.github.portlek.configs.FieldLoader;
import io.github.portlek.configs.Loader;
import io.github.portlek.configs.annotation.From;
import io.github.portlek.configs.annotation.Route;
import io.github.portlek.configs.configuration.FileConfiguration;
import io.github.portlek.reflection.RefField;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;

public final class FileVersions {
    public static void load(@NotNull Loader loader, @NotNull Collection<Map.Entry<RefField, FieldLoader>> fields) {
        int fileVersion;
        FileConfiguration configuration = loader.getFileConfiguration();
        if (configuration.contains("file-version")) {
            fileVersion = configuration.getInt("file-version", 1);
        } else {
            configuration.set("file-version", 1);
            fileVersion = 1;
        }
        HashSet<Map.Entry<RefField, FieldLoader>> nonFromFields = new HashSet<Map.Entry<RefField, FieldLoader>>();
        HashSet<Map.Entry<RefField, FieldLoader>> fromFields = new HashSet<Map.Entry<RefField, FieldLoader>>();
        for (Map.Entry<RefField, FieldLoader> field : fields) {
            if (field.getKey().hasAnnotation(From.class)) {
                fromFields.add(field);
                continue;
            }
            nonFromFields.addAll(fields);
        }
        nonFromFields.forEach(entry -> ((FieldLoader)entry.getValue()).onLoad(loader, (RefField)entry.getKey()));
        IntStream.range(fileVersion, loader.getFileVersion() + 1).forEach(index -> {
            fromFields.forEach(entry -> FileVersions.onLoadField(loader, (RefField)entry.getKey(), (FieldLoader)entry.getValue()));
            FileVersions.onLoad(loader, index);
        });
    }

    private static void onLoad(@NotNull Loader loader, int fileVersionIndex) {
        Optional.ofNullable(loader.getFileVersionOperations().get(fileVersionIndex)).ifPresent(operation -> operation.accept(loader));
        FileVersions.onUpdate(loader);
    }

    private static void onLoadField(@NotNull Loader loader, @NotNull RefField field, @NotNull FieldLoader fieldLoader) {
        int fileVersion = loader.getFileConfiguration().getInt("file-version", 1);
        field.getAnnotation(From.class, from -> {
            if (from.removedVersion() == fileVersion) {
                String path = field.getAnnotation(Route.class).map(Route::value).orElse(field.getName());
                fieldLoader.getSection().remove(path);
            } else if (from.version() == fileVersion) {
                fieldLoader.onLoad(loader, field);
            }
        });
    }

    private static void onUpdate(@NotNull Loader loader) {
        FileConfiguration configuration = loader.getFileConfiguration();
        int latestVersion = loader.getFileVersion();
        int fileVersion = configuration.getInt("file-version", 1);
        if (fileVersion < 1) {
            configuration.set("file-version", 1);
        } else if (fileVersion > latestVersion) {
            configuration.set("file-version", latestVersion);
        }
        int actualVersion = configuration.getInt("file-version", 1);
        if (latestVersion > actualVersion) {
            configuration.set("file-version", actualVersion + 1);
        }
    }

    private FileVersions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

