/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.loaders;

import io.github.portlek.configs.ConfigHolder;
import io.github.portlek.configs.Loader;
import io.github.portlek.configs.annotation.Route;
import io.github.portlek.configs.configuration.ConfigurationSection;
import io.github.portlek.configs.loaders.BaseFieldLoader;
import io.github.portlek.configs.loaders.DataSerializer;
import io.github.portlek.configs.loaders.SectionSerializer;
import io.github.portlek.reflection.RefField;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GenericFieldLoader<R, F>
extends BaseFieldLoader
implements SectionSerializer<R, F> {
    @NotNull
    private final Class<F> finalClass;

    protected GenericFieldLoader(@NotNull ConfigHolder holder, @NotNull ConfigurationSection section, @NotNull Class<F> finalClass) {
        super(holder, section);
        this.finalClass = finalClass;
    }

    @Override
    public boolean canLoad(@NotNull Loader loader, @NotNull RefField field) {
        return this.finalClass.isAssignableFrom(field.getType());
    }

    @Override
    public final void onLoad(@NotNull Loader loader, @NotNull RefField field) {
        String path = field.getAnnotation(Route.class).map(Route::value).orElse(field.getName());
        Optional<Object> fieldValueOptional = field.getValue().filter(o -> this.finalClass.isAssignableFrom(o.getClass())).map(this.finalClass::cast);
        Optional<Object> valueAtPath = this.valueAtPath(path, fieldValueOptional.orElse(null));
        if (fieldValueOptional.isPresent()) {
            if (valueAtPath.isPresent()) {
                field.setValue(valueAtPath.get());
            } else {
                Object fieldValue = fieldValueOptional.get();
                if (fieldValue instanceof DataSerializer) {
                    this.toRaw(this.getSection().getSectionOrCreate(path), (DataSerializer)fieldValue);
                } else {
                    this.toRaw(fieldValue).ifPresent(r -> this.getSection().set(path, r));
                }
            }
        } else {
            valueAtPath.ifPresent(field::setValue);
        }
    }

    @NotNull
    private Optional<F> valueAtPath(@NotNull String path, @Nullable F fieldValue) {
        Optional<F> finalValue = this.toFinal(this.getSection(), path, fieldValue);
        Optional<F> otherFinalValue = finalValue.isPresent() ? finalValue : this.toConfigObject(this.getSection(), path).flatMap(r -> this.toFinal(r, fieldValue));
        return this.getSection().contains(path) ? otherFinalValue : Optional.empty();
    }
}

